/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.crafting.recipe.DamageItemRecipe;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapelessRecipe;

public class SGearDamageItemRecipe
extends DamageItemRecipe {
    public static final ResourceLocation NAME = SilentGear.getId("damage_item");
    public static final IRecipeSerializer<SGearDamageItemRecipe> SERIALIZER = new Serializer();

    public SGearDamageItemRecipe(ShapelessRecipe recipe) {
        super(recipe);
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        return super.func_77569_a(inv, worldIn) && SGearDamageItemRecipe.hasNoBrokenGear((IInventory)inv);
    }

    private static boolean hasNoBrokenGear(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!GearHelper.isGear(stack) || !GearHelper.isBroken(stack)) continue;
            return false;
        }
        return true;
    }

    private static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<SGearDamageItemRecipe> {
        private Serializer() {
        }

        public SGearDamageItemRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new SGearDamageItemRecipe((ShapelessRecipe)DamageItemRecipe.SERIALIZER.read(recipeId, json));
        }

        @Nullable
        public SGearDamageItemRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            DamageItemRecipe read = (DamageItemRecipe)DamageItemRecipe.SERIALIZER.read(recipeId, buffer);
            return read != null ? new SGearDamageItemRecipe((ShapelessRecipe)read) : null;
        }

        public void write(PacketBuffer buffer, SGearDamageItemRecipe recipe) {
            DamageItemRecipe.SERIALIZER.write(buffer, (ExtendedShapelessRecipe)recipe);
        }
    }
}

