/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.lib.collection.StackList;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapelessRecipe;

public final class ShapelessCompoundPartRecipe
extends ExtendedShapelessRecipe {
    public static final ResourceLocation NAME = SilentGear.getId("compound_part");
    public static final ExtendedShapelessRecipe.Serializer<ShapelessCompoundPartRecipe> SERIALIZER = ExtendedShapelessRecipe.Serializer.basic(ShapelessCompoundPartRecipe::new);
    private final CompoundPartItem item;

    private ShapelessCompoundPartRecipe(ShapelessRecipe recipe) {
        super(recipe);
        ItemStack output = recipe.func_77571_b();
        if (!(output.func_77973_b() instanceof CompoundPartItem)) {
            throw new JsonParseException("result is not a compound part item: " + output);
        }
        this.item = (CompoundPartItem)output.func_77973_b();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        if (!this.getBaseRecipe().func_77569_a(inv, worldIn)) {
            return false;
        }
        return ShapelessCompoundPartRecipe.getMaterials((IInventory)inv).stream().allMatch(mat -> mat.getMaterial().isCraftingAllowed(this.item.getPartType()));
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        ItemStack result = this.item.create(ShapelessCompoundPartRecipe.getMaterials((IInventory)inv));
        result.func_190920_e(this.getBaseRecipe().func_77571_b().func_190916_E());
        return result;
    }

    private static Collection<MaterialInstance> getMaterials(IInventory inv) {
        return StackList.from((IInventory)inv).stream().map(stack -> stack.func_77946_l().func_77979_a(1)).map(MaterialInstance::from).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public ItemStack func_77571_b() {
        ItemStack result = this.item.create(Collections.singleton(new LazyMaterialInstance(SilentGear.getId("example"))));
        result.func_190920_e(this.getBaseRecipe().func_77571_b().func_190916_E());
        return result;
    }

    public boolean func_192399_d() {
        return true;
    }
}

