/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.api.parts.IUpgradePart;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gear.parts.PartPositions;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.lib.collection.StackList;

public class UpgradeGearRecipe
implements ICraftingRecipe {
    public static final ResourceLocation NAME = new ResourceLocation("silentgear", "upgrade_gear");
    public static final Serializer SERIALIZER = new Serializer();

    public boolean matches(CraftingInventory inv, World worldIn) {
        if (((Boolean)Config.GENERAL.upgradesInAnvilOnly.get()).booleanValue()) {
            return false;
        }
        StackList list = StackList.from((IInventory)inv);
        ItemStack gear = list.uniqueOfType(ICoreItem.class);
        if (gear.func_190926_b()) {
            return false;
        }
        Collection upgrades = list.allMatches(stack -> {
            PartData part = PartData.fromStackFast(stack);
            return part != null && part.getPart() instanceof IUpgradePart;
        });
        if (upgrades.isEmpty()) {
            return false;
        }
        HashSet<IPartPosition> positions = new HashSet<IPartPosition>();
        ItemStack test = gear.func_77946_l();
        for (ItemStack upgrade : upgrades) {
            PartData part = PartData.fromStackFast(upgrade);
            if (part == null || positions.contains(part.getPartPosition()) || !UpgradeGearRecipe.canApplyUpgrade(test, part)) {
                return false;
            }
            if (part.getPartPosition() != PartPositions.ANY) {
                positions.add(part.getPartPosition());
            }
            GearData.addUpgradePart(test, part);
        }
        return true;
    }

    private static boolean canApplyUpgrade(ItemStack gear, PartData part) {
        ICoreItem gearItem = (ICoreItem)gear.func_77973_b();
        IGearPart gearPart = part.getPart();
        return !GearData.hasPart(gear, gearPart) && gearPart instanceof IUpgradePart && ((IUpgradePart)((Object)gearPart)).isValidFor(gearItem);
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        StackList list = StackList.from((IInventory)inv);
        ItemStack gear = list.uniqueOfType(ICoreItem.class);
        if (gear.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        Collection upgrades = list.allMatches(stack -> {
            PartData part = PartData.fromStackFast(stack);
            return part != null && part.getPart() instanceof IUpgradePart;
        });
        ItemStack result = gear.func_77946_l();
        for (ItemStack upgrade : upgrades) {
            GearData.addUpgradePart(result, upgrade);
        }
        GearData.recalculateStats(result, null);
        return result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList list = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        StackList stackList = StackList.from((IInventory)inv);
        ItemStack gear = stackList.uniqueMatch(s -> s.func_77973_b() instanceof ICoreItem);
        PartDataList oldParts = GearData.getConstructionParts(gear);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b() instanceof ICoreItem) {
                list.set(i, (Object)ItemStack.field_190927_a);
                continue;
            }
            IGearPart part = PartManager.from(stack);
            if (part == null) continue;
            List<PartData> partsOfType = oldParts.getPartsOfType(part.getType());
            if (!partsOfType.isEmpty()) {
                PartData partData = partsOfType.get(0);
                partData.onRemoveFromGear(gear);
                list.set(i, (Object)partData.getCraftingItem());
                continue;
            }
            list.set(i, (Object)ItemStack.field_190927_a);
        }
        return list;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }

    public ResourceLocation func_199560_c() {
        return NAME;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static final class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<UpgradeGearRecipe> {
        public UpgradeGearRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new UpgradeGearRecipe();
        }

        public UpgradeGearRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new UpgradeGearRecipe();
        }

        public void write(PacketBuffer buffer, UpgradeGearRecipe recipe) {
        }
    }
}

