/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;

public class LazyMaterialInstance
implements IMaterialInstance {
    private final ResourceLocation materialId;
    private final MaterialGrade grade;

    public LazyMaterialInstance(ResourceLocation materialId) {
        this(materialId, MaterialGrade.NONE);
    }

    public LazyMaterialInstance(ResourceLocation materialId, MaterialGrade grade) {
        this.materialId = materialId;
        this.grade = grade;
    }

    @Override
    public ResourceLocation getMaterialId() {
        return this.materialId;
    }

    @Override
    @Nullable
    public IMaterial getMaterial() {
        return MaterialManager.get(this.materialId);
    }

    @Override
    public MaterialGrade getGrade() {
        return this.grade;
    }

    @Override
    public ItemStack getItem() {
        IMaterial material = this.getMaterial();
        return material != null ? MaterialInstance.of(material).getItem() : ItemStack.field_190927_a;
    }

    @Override
    public CompoundNBT write(CompoundNBT nbt) {
        nbt.func_74778_a("ID", this.materialId.toString());
        nbt.func_74778_a("Grade", this.grade.name());
        return nbt;
    }

    @Override
    public int getColor(PartType partType, ItemStack gear) {
        IMaterial material = this.getMaterial();
        return material != null ? material.getColor(gear, partType) : 0xFFFFFF;
    }

    @Override
    public ITextComponent getDisplayName(PartType partType, ItemStack gear) {
        IMaterial material = this.getMaterial();
        return material != null ? material.getDisplayName(partType, gear) : new StringTextComponent("INVALID");
    }
}

