/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;

public class MaterialInstance
implements IMaterialInstance {
    private static final Map<ResourceLocation, MaterialInstance> QUICK_CACHE = new HashMap<ResourceLocation, MaterialInstance>();
    private final IMaterial material;
    private final MaterialGrade grade;
    private final ItemStack item;

    private MaterialInstance(IMaterial material) {
        this(material, MaterialGrade.NONE, material.getDisplayItem(PartType.MAIN, 0));
    }

    private MaterialInstance(IMaterial material, MaterialGrade grade) {
        this(material, MaterialGrade.NONE, material.getDisplayItem(PartType.MAIN, 0));
    }

    private MaterialInstance(IMaterial material, ItemStack craftingItem) {
        this(material, MaterialGrade.NONE, craftingItem);
    }

    private MaterialInstance(IMaterial material, MaterialGrade grade, ItemStack craftingItem) {
        this.material = material;
        this.grade = grade;
        this.item = craftingItem;
    }

    public static MaterialInstance of(IMaterial material) {
        return QUICK_CACHE.computeIfAbsent(material.getId(), id -> new MaterialInstance(material));
    }

    public static MaterialInstance of(IMaterial material, MaterialGrade grade) {
        return new MaterialInstance(material, grade);
    }

    public static MaterialInstance of(IMaterial material, ItemStack craftingItem) {
        return new MaterialInstance(material, MaterialGrade.fromStack(craftingItem), craftingItem);
    }

    public static MaterialInstance of(IMaterial material, MaterialGrade grade, ItemStack craftingItem) {
        return new MaterialInstance(material, grade, craftingItem);
    }

    @Nullable
    public static MaterialInstance from(ItemStack stack) {
        IMaterial material = MaterialManager.from(stack);
        if (material != null) {
            return MaterialInstance.of(material, stack);
        }
        return null;
    }

    @Override
    public ResourceLocation getMaterialId() {
        return this.material.getId();
    }

    @Override
    @Nonnull
    public IMaterial getMaterial() {
        return this.material;
    }

    @Override
    public MaterialGrade getGrade() {
        return this.grade;
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }

    public Collection<StatInstance> getStatModifiers(ItemStat stat, PartType partType, ItemStack gear) {
        Collection<StatInstance> mods = this.material.getStatModifiers(stat, partType, gear);
        if (stat.isAffectedByGrades() && this.grade != MaterialGrade.NONE) {
            float bonus = 1.0f + (float)this.grade.bonusPercent / 100.0f;
            return mods.stream().map(m -> new StatInstance(m.getValue() * bonus, m.getOp())).collect(Collectors.toList());
        }
        return mods;
    }

    @Nullable
    public static MaterialInstance read(CompoundNBT nbt) {
        ResourceLocation id = ResourceLocation.func_208304_a((String)nbt.func_74779_i("ID"));
        IMaterial material = MaterialManager.get(id);
        if (material == null) {
            return null;
        }
        MaterialGrade grade = MaterialGrade.fromString(nbt.func_74779_i("Grade"));
        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Item"));
        return MaterialInstance.of(material, grade, stack);
    }

    @Nullable
    public static MaterialInstance readFast(CompoundNBT nbt) {
        ResourceLocation id = ResourceLocation.func_208304_a((String)nbt.func_74779_i("ID"));
        IMaterial material = MaterialManager.get(id);
        if (material == null) {
            return null;
        }
        return MaterialInstance.of(material);
    }

    @Override
    public CompoundNBT write(CompoundNBT nbt) {
        nbt.func_74778_a("ID", this.material.getId().toString());
        nbt.func_74778_a("Grade", this.grade.name());
        nbt.func_218657_a("Item", (INBT)this.item.func_77955_b(new CompoundNBT()));
        return nbt;
    }

    @Override
    public int getColor(PartType partType, ItemStack gear) {
        return this.material.getColor(gear, partType);
    }

    @Override
    public ITextComponent getDisplayName(PartType partType, ItemStack gear) {
        return this.material.getDisplayName(partType, gear);
    }
}

