/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.network.NetworkEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.gear.material.PartMaterial;
import net.silentchaos512.gear.network.SyncMaterialsPacket;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class MaterialManager
implements IResourceManagerReloadListener {
    public static final MaterialManager INSTANCE = new MaterialManager();
    public static final Marker MARKER = MarkerManager.getMarker((String)"MaterialManager");
    private static final String DATA_PATH = "silentgear_materials";
    private static final Map<ResourceLocation, IMaterial> MAP = Collections.synchronizedMap(new LinkedHashMap());
    private static final Collection<String> ERROR_LIST = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_195410_a(IResourceManager resourceManager) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Collection resources = resourceManager.func_199003_a(DATA_PATH, s -> s.endsWith(".json"));
        if (resources.isEmpty()) {
            return;
        }
        Map<ResourceLocation, IMaterial> map = MAP;
        synchronized (map) {
            MAP.clear();
            ERROR_LIST.clear();
            SilentGear.LOGGER.info(MARKER, "Reloading material files");
            for (ResourceLocation id : resources) {
                String path = id.func_110623_a().substring(DATA_PATH.length() + 1, id.func_110623_a().length() - ".json".length());
                ResourceLocation name = new ResourceLocation(id.func_110624_b(), path);
                String packName = "ERROR";
                try {
                    IResource iresource = resourceManager.func_199002_a(id);
                    Throwable throwable = null;
                    try {
                        packName = iresource.func_199026_d();
                        JsonObject json = (JsonObject)JSONUtils.func_188178_a((Gson)gson, (String)IOUtils.toString((InputStream)iresource.func_199027_b(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                        if (json == null) {
                            SilentGear.LOGGER.error(MARKER, "Could not load material {} as it's null or empty", (Object)name);
                            continue;
                        }
                        if (!CraftingHelper.processConditions((JsonObject)json, (String)"conditions")) {
                            SilentGear.LOGGER.info("Skipping loading material {} as its conditions were not met", (Object)name);
                            continue;
                        }
                        PartMaterial material = PartMaterial.Serializer.deserialize(name, packName, json);
                        MAP.put(material.getId(), material);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (iresource == null) continue;
                        if (throwable != null) {
                            try {
                                iresource.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        iresource.close();
                    }
                }
                catch (JsonParseException | IllegalArgumentException ex) {
                    SilentGear.LOGGER.error(MARKER, "Parsing error loading material {}", (Object)name, (Object)ex);
                    ERROR_LIST.add(String.format("%s (%s)", name, packName));
                }
                catch (IOException ex) {
                    SilentGear.LOGGER.error(MARKER, "Could not read material {}", (Object)name, (Object)ex);
                    ERROR_LIST.add(String.format("%s (%s)", name, packName));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<IMaterial> getValues() {
        Map<ResourceLocation, IMaterial> map = MAP;
        synchronized (map) {
            return MAP.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IMaterial get(@Nullable ResourceLocation id) {
        if (id == null) {
            return null;
        }
        Map<ResourceLocation, IMaterial> map = MAP;
        synchronized (map) {
            return MAP.get(id);
        }
    }

    @Nullable
    public static IMaterial from(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        for (IMaterial material : MaterialManager.getValues()) {
            if (!material.getIngredient(PartType.MAIN).test(stack)) continue;
            return material;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleSyncPacket(SyncMaterialsPacket msg, Supplier<NetworkEvent.Context> ctx) {
        Map<ResourceLocation, IMaterial> map = MAP;
        synchronized (map) {
            ImmutableMap oldMaterials = ImmutableMap.copyOf(MAP);
            MAP.clear();
            msg.getMaterials().forEach(arg_0 -> MaterialManager.lambda$handleSyncPacket$1((Map)oldMaterials, arg_0));
            SilentGear.LOGGER.info("Read {} materials from server", (Object)MAP.size());
        }
        ctx.get().setPacketHandled(true);
    }

    public static Collection<ITextComponent> getErrorMessages(ServerPlayerEntity player) {
        if (!ERROR_LIST.isEmpty()) {
            String listStr = String.join((CharSequence)", ", ERROR_LIST);
            return ImmutableList.of((Object)new StringTextComponent("[Silent Gear] The following materials failed to load, check your log file:").func_211708_a(TextFormatting.RED), (Object)new StringTextComponent(listStr));
        }
        return ImmutableList.of();
    }

    private static /* synthetic */ void lambda$handleSyncPacket$1(Map oldMaterials, IMaterial mat) {
        mat.retainData((IMaterial)oldMaterials.get(mat.getId()));
        MAP.put(mat.getId(), mat);
    }
}

