/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreArmor;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.item.BlueprintPackageItem;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.CustomTippedUpgrade;
import net.silentchaos512.gear.item.SlingshotAmmoItem;
import net.silentchaos512.gear.item.blueprint.GearBlueprintItem;
import net.silentchaos512.gear.item.blueprint.PartBlueprintItem;
import net.silentchaos512.gear.item.gear.CoreArmor;
import net.silentchaos512.gear.item.gear.CoreAxe;
import net.silentchaos512.gear.item.gear.CoreBow;
import net.silentchaos512.gear.item.gear.CoreCrossbow;
import net.silentchaos512.gear.item.gear.CoreDagger;
import net.silentchaos512.gear.item.gear.CoreExcavator;
import net.silentchaos512.gear.item.gear.CoreHammer;
import net.silentchaos512.gear.item.gear.CoreKatana;
import net.silentchaos512.gear.item.gear.CoreLumberAxe;
import net.silentchaos512.gear.item.gear.CoreMachete;
import net.silentchaos512.gear.item.gear.CoreMattock;
import net.silentchaos512.gear.item.gear.CorePaxel;
import net.silentchaos512.gear.item.gear.CorePickaxe;
import net.silentchaos512.gear.item.gear.CoreShears;
import net.silentchaos512.gear.item.gear.CoreShield;
import net.silentchaos512.gear.item.gear.CoreShovel;
import net.silentchaos512.gear.item.gear.CoreSickle;
import net.silentchaos512.gear.item.gear.CoreSlingshot;
import net.silentchaos512.gear.item.gear.CoreSpear;
import net.silentchaos512.gear.item.gear.CoreSword;
import net.silentchaos512.lib.util.TimeUtils;

public final class ModItems {
    public static final Map<ResourceLocation, ICoreTool> toolClasses = new LinkedHashMap<ResourceLocation, ICoreTool>();
    public static final Map<ResourceLocation, ICoreArmor> armorClasses = new LinkedHashMap<ResourceLocation, ICoreArmor>();
    public static final Map<ResourceLocation, ICoreItem> gearClasses = new LinkedHashMap<ResourceLocation, ICoreItem>();
    public static final List<GearBlueprintItem> blueprints = new ArrayList<GearBlueprintItem>();
    static final Map<String, BlockItem> blocksToRegister = new LinkedHashMap<String, BlockItem>();
    public static BlueprintPackageItem blueprintPackage;
    public static CustomTippedUpgrade customTippedUpgrade;
    public static BlockNamedItem flaxseeds;
    public static Item netherBanana;
    public static Item goldenNetherBanana;
    public static Item pebble;
    public static CoreSword sword;
    public static CoreDagger dagger;
    public static CoreKatana katana;
    public static CoreMachete machete;
    public static CoreSpear spear;
    public static CorePickaxe pickaxe;
    public static CoreShovel shovel;
    public static CoreAxe axe;
    public static CorePaxel paxel;
    public static CoreHammer hammer;
    public static CoreExcavator excavator;
    public static CoreLumberAxe lumberAxe;
    public static CoreMattock mattock;
    public static CoreSickle sickle;
    public static CoreShears shears;
    public static CoreBow bow;
    public static CoreCrossbow crossbow;
    public static CoreSlingshot slingshot;
    public static CoreShield shield;
    public static CoreArmor helmet;
    public static CoreArmor chestplate;
    public static CoreArmor leggings;
    public static CoreArmor boots;

    private ModItems() {
    }

    public static void registerAll(RegistryEvent.Register<Item> event) {
        blocksToRegister.forEach(ModItems::register);
        ModItems.initializeGear();
        blueprintPackage = ModItems.register("blueprint_package", new BlueprintPackageItem(SilentGear.getId("starter_blueprints")));
        ModItems.registerBlueprints("blueprint", false);
        ModItems.registerBlueprints("template", true);
        for (CraftingItems item2 : CraftingItems.values()) {
            ModItems.register(item2.func_176610_l(), item2.func_199767_j());
        }
        ModItems.register("custom_tipped_upgrade", customTippedUpgrade);
        ModItems.register("rod", new CompoundPartItem(SilentGear.getId("rod"), PartType.ROD, new Item.Properties().func_200916_a(SilentGear.ITEM_GROUP)));
        ModItems.register("long_rod", new CompoundPartItem(SilentGear.getId("long_rod"), PartType.ROD, new Item.Properties().func_200916_a(SilentGear.ITEM_GROUP)));
        ModItems.register("grip", new CompoundPartItem(SilentGear.getId("grip"), PartType.GRIP, new Item.Properties().func_200916_a(SilentGear.ITEM_GROUP)));
        ModItems.register("tip", new CompoundPartItem(SilentGear.getId("tip"), PartType.TIP, 1, new Item.Properties().func_200916_a(SilentGear.ITEM_GROUP)));
        flaxseeds = ModItems.register("flaxseeds", new BlockNamedItem(ModBlocks.FLAX_PLANT.asBlock(), ModItems.getBaseProperties()));
        netherBanana = ModItems.register("nether_banana", new Item(ModItems.getBaseProperties().func_221540_a(new Food.Builder().func_221456_a(5).func_221454_a(0.4f).func_221453_d())));
        goldenNetherBanana = ModItems.register("golden_nether_banana", new Item(ModItems.getBaseProperties().func_221540_a(new Food.Builder().func_221456_a(10).func_221454_a(1.0f).func_221455_b().effect(() -> new EffectInstance(Effects.field_76426_n, TimeUtils.ticksFromMinutes((float)10.0f)), 1.0f).effect(() -> new EffectInstance(Effects.field_76429_m, TimeUtils.ticksFromMinutes((float)5.0f)), 1.0f).effect(() -> new EffectInstance(Effects.field_76428_l, TimeUtils.ticksFromSeconds((float)10.0f)), 1.0f).func_221453_d())));
        pebble = ModItems.register("pebble", new SlingshotAmmoItem());
        gearClasses.forEach((key, item) -> ModItems.register(key, item.func_199767_j()));
    }

    private static Item.Properties getBaseProperties() {
        return new Item.Properties().func_200916_a(SilentGear.ITEM_GROUP);
    }

    private static void initializeGear() {
        toolClasses.put(SilentGear.getId("sword"), sword);
        toolClasses.put(SilentGear.getId("dagger"), dagger);
        toolClasses.put(SilentGear.getId("katana"), katana);
        toolClasses.put(SilentGear.getId("machete"), machete);
        toolClasses.put(SilentGear.getId("spear"), spear);
        toolClasses.put(SilentGear.getId("pickaxe"), pickaxe);
        toolClasses.put(SilentGear.getId("shovel"), shovel);
        toolClasses.put(SilentGear.getId("axe"), axe);
        toolClasses.put(SilentGear.getId("paxel"), paxel);
        toolClasses.put(SilentGear.getId("hammer"), hammer);
        toolClasses.put(SilentGear.getId("excavator"), excavator);
        toolClasses.put(SilentGear.getId("lumber_axe"), lumberAxe);
        toolClasses.put(SilentGear.getId("mattock"), mattock);
        toolClasses.put(SilentGear.getId("sickle"), sickle);
        toolClasses.put(SilentGear.getId("shears"), shears);
        toolClasses.put(SilentGear.getId("bow"), bow);
        toolClasses.put(SilentGear.getId("crossbow"), crossbow);
        toolClasses.put(SilentGear.getId("slingshot"), slingshot);
        armorClasses.put(SilentGear.getId("helmet"), helmet);
        armorClasses.put(SilentGear.getId("chestplate"), chestplate);
        armorClasses.put(SilentGear.getId("leggings"), leggings);
        armorClasses.put(SilentGear.getId("boots"), boots);
        gearClasses.put(SilentGear.getId("shield"), shield);
        gearClasses.putAll(toolClasses);
        gearClasses.putAll(armorClasses);
    }

    private static <T extends Item> T register(String name, T item) {
        return ModItems.register(SilentGear.getId(name), item);
    }

    private static <T extends Item> T register(ResourceLocation id, T item) {
        item.setRegistryName(id);
        ForgeRegistries.ITEMS.register(item);
        return item;
    }

    private static void registerBlueprints(String name, boolean singleUse) {
        gearClasses.forEach((key, item) -> {
            GearBlueprintItem blueprint = new GearBlueprintItem(singleUse, () -> item);
            blueprints.add(blueprint);
            ModItems.register(new ResourceLocation(key.func_110624_b(), name + "_" + key.func_110623_a()), blueprint);
        });
        ModItems.register(name + "_rod", new PartBlueprintItem(singleUse, PartType.ROD));
        ModItems.register(name + "_bowstring", new PartBlueprintItem(singleUse, PartType.BOWSTRING));
        ModItems.register(name + "_grip", new PartBlueprintItem(singleUse, PartType.GRIP));
        ModItems.register(name + "_tip", new PartBlueprintItem(singleUse, PartType.TIP));
    }

    static {
        customTippedUpgrade = new CustomTippedUpgrade();
        sword = new CoreSword();
        dagger = new CoreDagger();
        katana = new CoreKatana();
        machete = new CoreMachete();
        spear = new CoreSpear();
        pickaxe = new CorePickaxe();
        shovel = new CoreShovel();
        axe = new CoreAxe();
        paxel = new CorePaxel();
        hammer = new CoreHammer();
        excavator = new CoreExcavator();
        lumberAxe = new CoreLumberAxe();
        mattock = new CoreMattock();
        sickle = new CoreSickle();
        shears = new CoreShears();
        bow = new CoreBow();
        crossbow = new CoreCrossbow();
        slingshot = new CoreSlingshot();
        shield = new CoreShield();
        helmet = new CoreArmor(EquipmentSlotType.HEAD);
        chestplate = new CoreArmor(EquipmentSlotType.CHEST);
        leggings = new CoreArmor(EquipmentSlotType.LEGS);
        boots = new CoreArmor(EquipmentSlotType.FEET);
        ModItems.initializeGear();
    }
}

