/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.crafting.ingredient.CustomTippedUpgradeIngredient;
import net.silentchaos512.gear.crafting.ingredient.ExclusionIngredient;
import net.silentchaos512.gear.crafting.ingredient.GearPartIngredient;
import net.silentchaos512.gear.crafting.ingredient.PartMaterialIngredient;
import net.silentchaos512.gear.crafting.recipe.GearPartSwapRecipe;
import net.silentchaos512.gear.crafting.recipe.QuickRepairRecipe;
import net.silentchaos512.gear.crafting.recipe.RepairItemRecipeFix;
import net.silentchaos512.gear.crafting.recipe.ReplaceToolHeadRecipe;
import net.silentchaos512.gear.crafting.recipe.SGearDamageItemRecipe;
import net.silentchaos512.gear.crafting.recipe.ShapedGearRecipe;
import net.silentchaos512.gear.crafting.recipe.ShapelessCompoundPartRecipe;
import net.silentchaos512.gear.crafting.recipe.ShapelessGearRecipe;
import net.silentchaos512.gear.crafting.recipe.UpgradeGearRecipe;

public final class ModRecipes {
    private ModRecipes() {
    }

    public static void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        ModRecipes.register(ShapelessCompoundPartRecipe.NAME, ShapelessCompoundPartRecipe.SERIALIZER);
        ModRecipes.register(ShapedGearRecipe.NAME, ShapedGearRecipe.SERIALIZER);
        ModRecipes.register(ShapelessGearRecipe.NAME, ShapelessGearRecipe.SERIALIZER);
        ModRecipes.register(GearPartSwapRecipe.NAME, GearPartSwapRecipe.SERIALIZER);
        ModRecipes.register(QuickRepairRecipe.NAME, QuickRepairRecipe.SERIALIZER);
        ModRecipes.register(ReplaceToolHeadRecipe.NAME, ReplaceToolHeadRecipe.SERIALIZER);
        ModRecipes.register(UpgradeGearRecipe.NAME, UpgradeGearRecipe.SERIALIZER);
        ModRecipes.register(SGearDamageItemRecipe.NAME, SGearDamageItemRecipe.SERIALIZER);
        ModRecipes.register(SilentGear.getId("crafting_special_repairitem"), new SpecialRecipeSerializer(RepairItemRecipeFix::new));
        CraftingHelper.register((ResourceLocation)CustomTippedUpgradeIngredient.Serializer.NAME, (IIngredientSerializer)CustomTippedUpgradeIngredient.Serializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)ExclusionIngredient.Serializer.NAME, (IIngredientSerializer)ExclusionIngredient.Serializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)GearPartIngredient.Serializer.NAME, (IIngredientSerializer)GearPartIngredient.Serializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)PartMaterialIngredient.Serializer.NAME, (IIngredientSerializer)PartMaterialIngredient.Serializer.INSTANCE);
        if (SilentGear.isDevBuild()) {
            // empty if block
        }
    }

    private static void register(ResourceLocation id, IRecipeSerializer<?> serializer) {
        ForgeRegistries.RECIPE_SERIALIZERS.register((IForgeRegistryEntry)serializer.setRegistryName(id));
    }

    private static void onPlayerJoinServer(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player.field_70170_p.field_72995_K || player.field_70170_p.func_73046_m() == null) {
            return;
        }
        ResourceLocation[] recipes = (ResourceLocation[])player.field_70170_p.func_73046_m().func_199529_aN().func_199510_b().stream().map(IRecipe::func_199560_c).filter(name -> name.func_110624_b().equals("silentgear")).toArray(ResourceLocation[]::new);
        SilentGear.LOGGER.info("DEV: Unlocking {} recipes in recipe book", (Object)recipes.length);
        player.func_193102_a(recipes);
    }
}

