/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.config.Config;

@Mod.EventBusSubscriber(modid="silentgear")
public final class NerfedGear {
    public static final List<String> DEFAULT_ITEMS = ImmutableList.of((Object)"diamond_axe", (Object)"iron_axe", (Object)"golden_axe", (Object)"stone_axe", (Object)"wooden_axe", (Object)"diamond_hoe", (Object)"iron_hoe", (Object)"golden_hoe", (Object)"stone_hoe", (Object)"wooden_hoe", (Object)"diamond_pickaxe", (Object)"iron_pickaxe", (Object[])new String[]{"golden_pickaxe", "stone_pickaxe", "wooden_pickaxe", "diamond_shovel", "iron_shovel", "golden_shovel", "stone_shovel", "wooden_shovel", "diamond_sword", "iron_sword", "golden_sword", "stone_sword", "wooden_sword"});

    private NerfedGear() {
    }

    public static void init() {
        Field itemDamageField;
        try {
            itemDamageField = ObfuscationReflectionHelper.findField(Item.class, (String)"field_77699_b");
            itemDamageField.setAccessible(true);
        }
        catch (Exception ex) {
            SilentGear.LOGGER.error("Field to get Item damage field via reflection");
            SilentGear.LOGGER.catching((Throwable)ex);
            return;
        }
        for (Item item : ForgeRegistries.ITEMS) {
            if (!NerfedGear.isNerfedItem(item)) continue;
            SilentGear.LOGGER.debug("Try nerf durability of {}", (Object)item.getRegistryName());
            try {
                int maxDamage = (Integer)itemDamageField.get(item);
                int newMax = MathHelper.func_76125_a((int)((int)((double)maxDamage * (Double)Config.GENERAL.nerfedItemDurabilityMulti.get())), (int)1, (int)maxDamage);
                itemDamageField.set(item, newMax);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isNerfedItem(Item item) {
        return item.func_77645_m() && Config.GENERAL.isNerfedItem(item);
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack heldItem = event.getPlayer().func_184614_ca();
        if (NerfedGear.isNerfedItem(heldItem.func_77973_b())) {
            float newSpeed = event.getNewSpeed() * ((Double)Config.GENERAL.nerfedItemHarvestSpeedMulti.get()).floatValue();
            event.setNewSpeed(Math.max(newSpeed, 1.0f));
        }
    }
}

