/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;

public class CompoundPartItem
extends Item {
    private static final String NBT_COLOR = "Color";
    private static final String NBT_MATERIALS = "Materials";
    private final ResourceLocation partId;
    private final PartType partType;
    private final int tintLayer;

    public CompoundPartItem(ResourceLocation partId, PartType partType, Item.Properties properties) {
        this(partId, partType, 0, properties);
    }

    public CompoundPartItem(ResourceLocation partId, PartType partType, int tintLayer, Item.Properties properties) {
        super(properties);
        this.partId = partId;
        this.partType = partType;
        this.tintLayer = tintLayer;
    }

    public PartType getPartType() {
        return this.partType;
    }

    public ItemStack createFromItems(Collection<ItemStack> materials) {
        return this.create(materials.stream().map(MaterialManager::from).filter(Objects::nonNull).map(MaterialInstance::of).collect(Collectors.toList()));
    }

    public ItemStack create(Collection<? extends IMaterialInstance> materials) {
        ListNBT materialListNbt = new ListNBT();
        materials.forEach(m -> materialListNbt.add((Object)m.write(new CompoundNBT())));
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a(NBT_MATERIALS, (INBT)materialListNbt);
        tag.func_74768_a(NBT_COLOR, this.calculateBlendedColor(materials));
        ItemStack result = new ItemStack((IItemProvider)this);
        result.func_77982_d(tag);
        return result;
    }

    public static Collection<MaterialInstance> getMaterials(ItemStack stack) {
        ListNBT materialListNbt = stack.func_196082_o().func_150295_c(NBT_MATERIALS, 10);
        return materialListNbt.stream().filter(nbt -> nbt instanceof CompoundNBT).map(nbt -> (CompoundNBT)nbt).map(MaterialInstance::read).collect(Collectors.toList());
    }

    @Nullable
    public static MaterialInstance getPrimaryMaterial(ItemStack stack) {
        INBT nbt;
        ListNBT listNbt = stack.func_196082_o().func_150295_c(NBT_MATERIALS, 10);
        if (!listNbt.isEmpty() && (nbt = listNbt.get(0)) instanceof CompoundNBT) {
            return MaterialInstance.read((CompoundNBT)nbt);
        }
        return null;
    }

    public static int getColor(ItemStack stack) {
        return stack.func_196082_o().func_74762_e(NBT_COLOR);
    }

    public int getColor(ItemStack stack, int tintIndex) {
        return tintIndex == this.tintLayer ? CompoundPartItem.getColor(stack) : 0xFFFFFF;
    }

    private int calculateBlendedColor(Collection<? extends IMaterialInstance> materials) {
        int[] componentSums = new int[3];
        int maxColorSum = 0;
        int colorCount = 0;
        int i = 0;
        for (IMaterialInstance iMaterialInstance : materials) {
            int color = iMaterialInstance.getColor(this.partType);
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int colorWeight = materials.size() - i;
            for (int j = 0; j < colorWeight; ++j) {
                maxColorSum += Math.max(r, Math.max(g, b));
                componentSums[0] = componentSums[0] + r;
                componentSums[1] = componentSums[1] + g;
                componentSums[2] = componentSums[2] + b;
                ++colorCount;
            }
            ++i;
        }
        if (colorCount > 0) {
            int r = componentSums[0] / colorCount;
            int n = componentSums[1] / colorCount;
            int b = componentSums[2] / colorCount;
            float maxAverage = (float)maxColorSum / (float)colorCount;
            float max = Math.max(r, Math.max(n, b));
            r = (int)((float)r * maxAverage / max);
            int n2 = (int)((float)n * maxAverage / max);
            b = (int)((float)b * maxAverage / max);
            int finalColor = (r << 8) + n2;
            finalColor = (finalColor << 8) + b;
            return finalColor;
        }
        return 0xFFFFFF;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        MaterialInstance material = CompoundPartItem.getPrimaryMaterial(stack);
        if (material != null) {
            return new TranslationTextComponent(this.func_77658_a() + ".nameProper", new Object[]{material.getDisplayName(this.partType)});
        }
        return super.func_200295_i(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundPartItem.getMaterials(stack).stream().map(mat -> new StringTextComponent("- ").func_150257_a(mat.getDisplayNameWithGrade(this.partType).func_211708_a(TextFormatting.ITALIC))).forEach(tooltip::add);
    }
}

