/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreRangedWeapon;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.utils.MathUtils;

public class CoreBow
extends BowItem
implements ICoreRangedWeapon {
    private static final int MIN_DRAW_DELAY = 10;
    private static final int MAX_DRAW_DELAY = 100;

    public CoreBow() {
        super(GearHelper.getBuilder(null).func_200915_b(100));
        GearHelper.addModelTypeProperty(this);
        this.func_185043_a(new ResourceLocation("pull"), (stack, world, entity) -> {
            if (entity == null) {
                return 0.0f;
            }
            return !(entity.func_184607_cu().func_77973_b() instanceof CoreBow) ? 0.0f : (float)(stack.func_77988_m() - entity.func_184605_cv()) / this.getDrawDelay(stack);
        });
    }

    @Override
    public GearType getGearType() {
        return GearType.BOW;
    }

    @Override
    public Optional<StatInstance> getBaseStatModifier(ItemStat stat) {
        if (stat == ItemStats.RANGED_DAMAGE) {
            return Optional.of(StatInstance.makeBaseMod(2.0f));
        }
        if (stat == ItemStats.RANGED_SPEED) {
            return Optional.of(StatInstance.makeBaseMod(1.0f));
        }
        if (stat == ItemStats.REPAIR_EFFICIENCY) {
            return Optional.of(StatInstance.makeBaseMod(1.0f));
        }
        return Optional.empty();
    }

    @Override
    public Optional<StatInstance> getStatModifier(ItemStat stat) {
        if (stat == ItemStats.ENCHANTABILITY) {
            return Optional.of(StatInstance.makeGearMod(-0.45f));
        }
        return Optional.empty();
    }

    @Override
    public float getDrawDelay(@Nonnull ItemStack stack) {
        return MathHelper.func_76131_a((float)ICoreRangedWeapon.super.getDrawDelay(stack), (float)10.0f, (float)100.0f);
    }

    public float getArrowVelocity(ItemStack stack, int charge) {
        float f = (float)charge / this.getDrawDelay(stack);
        return (f = (f * f + f * 2.0f) / 3.0f) > 1.0f ? 1.0f : f;
    }

    public float getArrowDamage(ItemStack stack) {
        return GearData.getStat(stack, ItemStats.RANGED_DAMAGE);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (player.field_70170_p.field_72995_K) {
            float f = (float)(stack.func_77988_m() - player.func_184605_cv()) / this.getDrawDelay(stack);
        }
        super.onUsingTick(stack, player, count);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack itemstack;
        boolean flag = !player.func_213356_f(itemstack = player.func_184586_b(hand)).func_190926_b() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)itemstack) > 0;
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (World)world, (PlayerEntity)player, (Hand)hand, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        if (!player.field_71075_bZ.field_75098_d && !flag) {
            return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
        }
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (worldIn.field_72995_K) {
            // empty if block
        }
        if (entityLiving instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            boolean infiniteAmmo = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack ammoItem = player.func_213356_f(stack);
            int i = this.func_77626_a(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (PlayerEntity)player, (int)i, (!ammoItem.func_190926_b() || infiniteAmmo ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!ammoItem.func_190926_b() || infiniteAmmo) {
                float f;
                if (ammoItem.func_190926_b()) {
                    ammoItem = new ItemStack((IItemProvider)Items.field_151032_g);
                }
                if (!((double)(f = this.getArrowVelocity(stack, i)) < 0.1)) {
                    boolean flag1;
                    boolean bl = flag1 = player.field_71075_bZ.field_75098_d || ammoItem.func_77973_b() instanceof ArrowItem && ((ArrowItem)ammoItem.func_77973_b()).isInfinite(ammoItem, stack, player);
                    if (!worldIn.field_72995_K) {
                        int punchLevel;
                        int powerLevel;
                        ArrowItem arrowitem = (ArrowItem)(ammoItem.func_77973_b() instanceof ArrowItem ? ammoItem.func_77973_b() : Items.field_151032_g);
                        AbstractArrowEntity arrowEntity = arrowitem.func_200887_a(worldIn, ammoItem, (LivingEntity)player);
                        arrowEntity.func_70239_b((double)GearData.getStat(stack, ItemStats.RANGED_DAMAGE));
                        arrowEntity.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                        if (MathUtils.floatsEqual((float)f, (float)1.0f)) {
                            arrowEntity.func_70243_d(true);
                        }
                        if ((powerLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                            arrowEntity.func_70239_b(arrowEntity.func_70242_d() + (double)powerLevel * 0.5 + 0.5);
                        }
                        if ((punchLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                            arrowEntity.func_70240_a(punchLevel);
                        }
                        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                            arrowEntity.func_70015_d(100);
                        }
                        stack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(p.func_184600_cs()));
                        if (flag1 || player.field_71075_bZ.field_75098_d && (ammoItem.func_77973_b() == Items.field_185166_h || ammoItem.func_77973_b() == Items.field_185167_i)) {
                            arrowEntity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                        }
                        worldIn.func_217376_c((Entity)arrowEntity);
                    }
                    worldIn.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag1 && !player.field_71075_bZ.field_75098_d) {
                        ammoItem.func_190918_g(1);
                        if (ammoItem.func_190926_b()) {
                            player.field_71071_by.func_184437_d(ammoItem);
                        }
                    }
                    player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                }
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        GearClientHelper.addInformation(stack, worldIn, tooltip, flagIn);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return GearHelper.getAttributeModifiers(slot, stack, false);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable(toRepair, repair);
    }

    public int getItemEnchantability(ItemStack stack) {
        return GearData.getStatInt(stack, ItemStats.ENCHANTABILITY);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return GearHelper.getDisplayName(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        GearHelper.setDamage(stack, damage, (x$0, x$1) -> super.setDamage(x$0, x$1));
    }

    public int getMaxDamage(ItemStack stack) {
        return GearData.getStatInt(stack, ItemStats.DURABILITY);
    }

    public Rarity func_77613_e(ItemStack stack) {
        return GearHelper.getRarity(stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        GearHelper.fillItemGroup(this, group, items);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        GearHelper.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return GearClientHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }
}

