/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreRangedWeapon;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class CoreCrossbow
extends CrossbowItem
implements ICoreRangedWeapon {
    private static final int MIN_CHARGE_TIME = 5;
    private static final int MAX_CHARGE_TIME = 50;
    private boolean field_220034_c = false;
    private boolean field_220035_d = false;

    public CoreCrossbow() {
        super(GearHelper.getBuilder(null).func_200915_b(100));
        GearHelper.addModelTypeProperty(this);
    }

    @Override
    public GearType getGearType() {
        return GearType.CROSSBOW;
    }

    @Override
    public Optional<StatInstance> getBaseStatModifier(ItemStat stat) {
        if (stat == ItemStats.RANGED_DAMAGE) {
            return Optional.of(StatInstance.makeBaseMod(2.0f));
        }
        if (stat == ItemStats.RANGED_SPEED) {
            return Optional.of(StatInstance.makeBaseMod(1.0f));
        }
        if (stat == ItemStats.REPAIR_EFFICIENCY) {
            return Optional.of(StatInstance.makeBaseMod(1.0f));
        }
        return Optional.empty();
    }

    @Override
    public Optional<StatInstance> getStatModifier(ItemStat stat) {
        if (stat == ItemStats.ENCHANTABILITY) {
            return Optional.of(StatInstance.makeGearMod(-0.45f));
        }
        return Optional.empty();
    }

    public boolean func_219970_i(ItemStack stack) {
        return true;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.CROSSBOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (CoreCrossbow.func_220012_d((ItemStack)itemstack)) {
            CoreCrossbow.fireProjectiles(worldIn, (LivingEntity)playerIn, handIn, itemstack, CoreCrossbow.func_220013_l(itemstack), 1.0f);
            CoreCrossbow.func_220011_a((ItemStack)itemstack, (boolean)false);
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
        }
        if (!playerIn.func_213356_f(itemstack).func_190926_b()) {
            if (!CoreCrossbow.func_220012_d((ItemStack)itemstack)) {
                this.field_220034_c = false;
                this.field_220035_d = false;
                playerIn.func_184598_c(handIn);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        int i = this.func_77626_a(stack) - timeLeft;
        float f = CoreCrossbow.getCharge(i, stack);
        if (f >= 1.0f && !CoreCrossbow.func_220012_d((ItemStack)stack) && CoreCrossbow.hasAmmo(entityLiving, stack)) {
            CoreCrossbow.func_220011_a((ItemStack)stack, (boolean)true);
            SoundCategory soundcategory = entityLiving instanceof PlayerEntity ? SoundCategory.PLAYERS : SoundCategory.HOSTILE;
            worldIn.func_184148_a(null, entityLiving.func_226277_ct_(), entityLiving.func_226278_cu_(), entityLiving.func_226281_cx_(), SoundEvents.field_219610_bB, soundcategory, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private static boolean hasAmmo(LivingEntity shooter, ItemStack stack) {
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222192_G, (ItemStack)stack);
        int j = i == 0 ? 1 : 3;
        boolean flag = shooter instanceof PlayerEntity && ((PlayerEntity)shooter).field_71075_bZ.field_75098_d;
        ItemStack itemstack = shooter.func_213356_f(stack);
        ItemStack itemstack1 = itemstack.func_77946_l();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                itemstack = itemstack1.func_77946_l();
            }
            if (itemstack.func_190926_b() && flag) {
                itemstack = new ItemStack((IItemProvider)Items.field_151032_g);
                itemstack1 = itemstack.func_77946_l();
            }
            if (CoreCrossbow.func_220023_a(shooter, stack, itemstack, k > 0, flag)) continue;
            return false;
        }
        return true;
    }

    private static boolean func_220023_a(LivingEntity entityIn, ItemStack crossbow, ItemStack ammo, boolean p_220023_3_, boolean p_220023_4_) {
        ItemStack itemstack;
        boolean flag;
        if (ammo.func_190926_b()) {
            return false;
        }
        boolean bl = flag = p_220023_4_ && ammo.func_77973_b() instanceof ArrowItem;
        if (!(flag || p_220023_4_ || p_220023_3_)) {
            itemstack = ammo.func_77979_a(1);
            if (ammo.func_190926_b() && entityIn instanceof PlayerEntity) {
                ((PlayerEntity)entityIn).field_71071_by.func_184437_d(ammo);
            }
        } else {
            itemstack = ammo.func_77946_l();
        }
        CoreCrossbow.addChargedProjectile(crossbow, itemstack);
        return true;
    }

    private static void addChargedProjectile(ItemStack crossbow, ItemStack projectile) {
        CompoundNBT compoundnbt = crossbow.func_196082_o();
        ListNBT listnbt = compoundnbt.func_150297_b("ChargedProjectiles", 9) ? compoundnbt.func_150295_c("ChargedProjectiles", 10) : new ListNBT();
        CompoundNBT compoundnbt1 = new CompoundNBT();
        projectile.func_77955_b(compoundnbt1);
        listnbt.add((Object)compoundnbt1);
        compoundnbt.func_218657_a("ChargedProjectiles", (INBT)listnbt);
    }

    private static List<ItemStack> getChargedProjectiles(ItemStack p_220018_0_) {
        ListNBT listnbt;
        ArrayList list = Lists.newArrayList();
        CompoundNBT compoundnbt = p_220018_0_.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("ChargedProjectiles", 9) && (listnbt = compoundnbt.func_150295_c("ChargedProjectiles", 10)) != null) {
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compoundnbt1 = listnbt.func_150305_b(i);
                list.add(ItemStack.func_199557_a((CompoundNBT)compoundnbt1));
            }
        }
        return list;
    }

    private static void clearProjectiles(ItemStack p_220027_0_) {
        CompoundNBT compoundnbt = p_220027_0_.func_77978_p();
        if (compoundnbt != null) {
            ListNBT listnbt = compoundnbt.func_150295_c("ChargedProjectiles", 9);
            listnbt.clear();
            compoundnbt.func_218657_a("ChargedProjectiles", (INBT)listnbt);
        }
    }

    private static boolean hasChargedProjectile(ItemStack stack, Item ammoItem) {
        return CoreCrossbow.getChargedProjectiles(stack).stream().anyMatch(s -> s.func_77973_b() == ammoItem);
    }

    public int func_77626_a(ItemStack stack) {
        return 133700;
    }

    private SoundEvent func_220025_a(int p_220025_1_) {
        switch (p_220025_1_) {
            case 1: {
                return SoundEvents.field_219613_bE;
            }
            case 2: {
                return SoundEvents.field_219614_bF;
            }
            case 3: {
                return SoundEvents.field_219615_bG;
            }
        }
        return SoundEvents.field_219612_bD;
    }

    private static float getCharge(int useTime, ItemStack stack) {
        float f = (float)useTime / (float)CoreCrossbow.getChargeTime(stack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    private static void func_220016_a(World world, LivingEntity shooter, Hand hand, ItemStack crossbow, ItemStack projectile, float p_220016_5_, boolean p_220016_6_, float p_220016_7_, float p_220016_8_, float p_220016_9_) {
        if (!world.field_72995_K) {
            AbstractArrowEntity iprojectile;
            boolean flag;
            boolean bl = flag = projectile.func_77973_b() == Items.field_196152_dE;
            if (flag) {
                iprojectile = new FireworkRocketEntity(world, projectile, shooter.func_226277_ct_(), shooter.func_226278_cu_() + (double)shooter.func_70047_e() - (double)0.15f, shooter.func_226281_cx_(), true);
            } else {
                iprojectile = CoreCrossbow.func_220024_a(world, shooter, crossbow, projectile);
                if (p_220016_6_ || p_220016_9_ != 0.0f) {
                    iprojectile.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                }
            }
            if (shooter instanceof ICrossbowUser) {
                ICrossbowUser icrossbowuser = (ICrossbowUser)shooter;
                LivingEntity attackTarget = icrossbowuser.func_70638_az();
                if (attackTarget != null) {
                    icrossbowuser.func_213670_a(attackTarget, crossbow, (IProjectile)iprojectile, p_220016_9_);
                }
            } else {
                Vec3d vec3d1 = shooter.func_213286_i(1.0f);
                Quaternion quaternion = new Quaternion(new Vector3f(vec3d1), p_220016_9_, true);
                Vec3d vec3d = shooter.func_70676_i(1.0f);
                Vector3f vector3f = new Vector3f(vec3d);
                vector3f.func_214905_a(quaternion);
                iprojectile.func_70186_c((double)vector3f.func_195899_a(), (double)vector3f.func_195900_b(), (double)vector3f.func_195902_c(), p_220016_7_, p_220016_8_);
            }
            crossbow.func_222118_a(flag ? 3 : 1, shooter, p_220017_1_ -> p_220017_1_.func_213334_d(hand));
            world.func_217376_c((Entity)iprojectile);
            world.func_184148_a(null, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), SoundEvents.field_219616_bH, SoundCategory.PLAYERS, 1.0f, p_220016_5_);
        }
    }

    private static AbstractArrowEntity func_220024_a(World world, LivingEntity shooter, ItemStack crossbow, ItemStack projectile) {
        ArrowItem arrowitem = (ArrowItem)(projectile.func_77973_b() instanceof ArrowItem ? projectile.func_77973_b() : Items.field_151032_g);
        AbstractArrowEntity arrowEntity = arrowitem.func_200887_a(world, projectile, shooter);
        if (shooter instanceof PlayerEntity) {
            arrowEntity.func_70243_d(true);
        }
        arrowEntity.func_70239_b((double)GearData.getStat(crossbow, ItemStats.RANGED_DAMAGE));
        arrowEntity.func_213869_a(SoundEvents.field_219609_bA);
        arrowEntity.func_213865_o(true);
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222194_I, (ItemStack)crossbow);
        if (i > 0) {
            arrowEntity.func_213872_b((byte)i);
        }
        return arrowEntity;
    }

    public static void fireProjectiles(World world, LivingEntity shooter, Hand hand, ItemStack crossbow, float p_220014_4_, float p_220014_5_) {
        List<ItemStack> list = CoreCrossbow.getChargedProjectiles(crossbow);
        float[] afloat = CoreCrossbow.func_220028_a(shooter.func_70681_au());
        for (int i = 0; i < list.size(); ++i) {
            boolean flag;
            ItemStack itemstack = list.get(i);
            boolean bl = flag = shooter instanceof PlayerEntity && ((PlayerEntity)shooter).field_71075_bZ.field_75098_d;
            if (itemstack.func_190926_b()) continue;
            if (i == 0) {
                CoreCrossbow.func_220016_a(world, shooter, hand, crossbow, itemstack, afloat[i], flag, p_220014_4_, p_220014_5_, 0.0f);
                continue;
            }
            if (i == 1) {
                CoreCrossbow.func_220016_a(world, shooter, hand, crossbow, itemstack, afloat[i], flag, p_220014_4_, p_220014_5_, -10.0f);
                continue;
            }
            if (i != 2) continue;
            CoreCrossbow.func_220016_a(world, shooter, hand, crossbow, itemstack, afloat[i], flag, p_220014_4_, p_220014_5_, 10.0f);
        }
        CoreCrossbow.func_220015_a(world, shooter, crossbow);
    }

    private static float[] func_220028_a(Random p_220028_0_) {
        boolean flag = p_220028_0_.nextBoolean();
        return new float[]{1.0f, CoreCrossbow.func_220032_a(flag), CoreCrossbow.func_220032_a(!flag)};
    }

    private static float func_220032_a(boolean p_220032_0_) {
        float f = p_220032_0_ ? 0.63f : 0.43f;
        return 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.8f) + f;
    }

    private static void func_220015_a(World p_220015_0_, LivingEntity p_220015_1_, ItemStack p_220015_2_) {
        if (p_220015_1_ instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)p_220015_1_;
            if (!p_220015_0_.field_72995_K) {
                CriteriaTriggers.field_215099_F.func_215111_a(serverplayerentity, p_220015_2_);
            }
            serverplayerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)p_220015_2_.func_77973_b()));
        }
        CoreCrossbow.clearProjectiles(p_220015_2_);
    }

    public void func_219972_a(World worldIn, LivingEntity livingEntityIn, ItemStack stack, int count) {
        if (!worldIn.field_72995_K) {
            int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)stack);
            SoundEvent soundevent = this.func_220025_a(i);
            SoundEvent soundevent1 = i == 0 ? SoundEvents.field_219611_bC : null;
            float f = (float)(stack.func_77988_m() - count) / (float)CoreCrossbow.getChargeTime(stack);
            if (f < 0.2f) {
                this.field_220034_c = false;
                this.field_220035_d = false;
            }
            if (f >= 0.2f && !this.field_220034_c) {
                this.field_220034_c = true;
                worldIn.func_184148_a(null, livingEntityIn.func_226277_ct_(), livingEntityIn.func_226278_cu_(), livingEntityIn.func_226281_cx_(), soundevent, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
            if (f >= 0.5f && soundevent1 != null && !this.field_220035_d) {
                this.field_220035_d = true;
                worldIn.func_184148_a(null, livingEntityIn.func_226277_ct_(), livingEntityIn.func_226278_cu_(), livingEntityIn.func_226281_cx_(), soundevent1, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public static int getChargeTime(ItemStack stack) {
        float baseTime = 25.0f / GearData.getStat(stack, ItemStats.RANGED_SPEED);
        int quickCharge = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)stack);
        return Math.round(MathHelper.func_76131_a((float)(baseTime - (float)(5 * quickCharge)), (float)5.0f, (float)50.0f));
    }

    private static float func_220013_l(ItemStack stack) {
        return stack.func_77973_b() instanceof CoreCrossbow && CoreCrossbow.hasChargedProjectile(stack, Items.field_196152_dE) ? 1.6f : 3.15f;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        GearClientHelper.addInformation(stack, worldIn, tooltip, flagIn);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return GearHelper.getAttributeModifiers(slot, stack, false);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable(toRepair, repair);
    }

    public int getItemEnchantability(ItemStack stack) {
        return GearData.getStatInt(stack, ItemStats.ENCHANTABILITY);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return GearHelper.getDisplayName(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        GearHelper.setDamage(stack, damage, (x$0, x$1) -> super.setDamage(x$0, x$1));
    }

    public int getMaxDamage(ItemStack stack) {
        return GearData.getStatInt(stack, ItemStats.DURABILITY);
    }

    public Rarity func_77613_e(ItemStack stack) {
        return GearHelper.getRarity(stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        GearHelper.fillItemGroup(this, group, items);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        GearHelper.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return GearClientHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }
}

