/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.loot.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.loot.condition.GearLootCondition;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class HasPartCondition
extends GearLootCondition {
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation partId;
    private final MaterialGrade.Range gradeRange;

    public HasPartCondition(ResourceLocation partId, MaterialGrade.Range gradeRange) {
        this.partId = partId;
        this.gradeRange = gradeRange;
    }

    public boolean test(LootContext context) {
        ItemStack tool = HasPartCondition.getItemUsed(context);
        if (!GearHelper.isGear(tool)) {
            return false;
        }
        return GearData.hasPart(tool, this.partId, this.gradeRange);
    }

    public static ILootCondition.IBuilder builder(ResourceLocation partId) {
        return HasPartCondition.builder(partId, MaterialGrade.Range.OPEN);
    }

    public static ILootCondition.IBuilder builder(ResourceLocation partId, MaterialGrade.Range gradeRange) {
        return () -> new HasPartCondition(partId, gradeRange);
    }

    public static class Serializer
    extends ILootCondition.AbstractSerializer<HasPartCondition> {
        protected Serializer() {
            super(SilentGear.getId("has_part"), HasPartCondition.class);
        }

        public void serialize(JsonObject json, HasPartCondition value, JsonSerializationContext context) {
            json.addProperty("part", value.partId.toString());
        }

        public HasPartCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            ResourceLocation partId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"part"));
            MaterialGrade.Range gradeRange = json.has("grade") ? MaterialGrade.Range.deserialize(json.get("grade")) : MaterialGrade.Range.OPEN;
            return new HasPartCondition(partId, gradeRange);
        }
    }
}

