/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.parts;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.IPartData;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.api.parts.IUpgradePart;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.parts.PartTraitInstance;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gear.parts.RepairContext;

public final class PartData
implements IPartData {
    private static final Map<ResourceLocation, PartData> CACHE_UNGRADED_PARTS = new HashMap<ResourceLocation, PartData>();
    public static final String NBT_ID = "ID";
    private final IGearPart part;
    @Deprecated
    private final MaterialGrade grade;
    private final ItemStack craftingItem;

    private PartData(IGearPart part, MaterialGrade grade) {
        this(part, grade, part.getMaterials().getDisplayItem(0));
    }

    private PartData(IGearPart part, MaterialGrade grade, ItemStack craftingItem) {
        this.part = part;
        this.grade = grade;
        this.craftingItem = craftingItem.func_77946_l();
        this.craftingItem.func_190920_e(1);
    }

    public static PartData of(IGearPart part) {
        ResourceLocation name = part.getId();
        if (CACHE_UNGRADED_PARTS.containsKey(name)) {
            return CACHE_UNGRADED_PARTS.get(name);
        }
        PartData inst = new PartData(part, MaterialGrade.NONE);
        CACHE_UNGRADED_PARTS.put(name, inst);
        return inst;
    }

    public static PartData of(IGearPart part, ItemStack craftingItem) {
        return new PartData(part, MaterialGrade.NONE, craftingItem);
    }

    @Deprecated
    public static PartData of(IGearPart part, MaterialGrade grade) {
        return new PartData(part, grade);
    }

    @Deprecated
    public static PartData of(IGearPart part, MaterialGrade grade, ItemStack craftingItem) {
        return new PartData(part, grade, craftingItem);
    }

    @Nullable
    public static PartData ofNullable(@Nullable IGearPart part) {
        if (part == null) {
            return null;
        }
        return PartData.of(part);
    }

    @Nullable
    public static PartData from(ItemStack craftingItem) {
        IGearPart part = PartManager.from(craftingItem);
        if (part == null) {
            return null;
        }
        return PartData.of(part, craftingItem);
    }

    @Nullable
    public static PartData fromStackFast(ItemStack craftingItem) {
        return PartData.ofNullable(PartManager.from(craftingItem));
    }

    @Nullable
    public static PartData fromId(ResourceLocation partId) {
        return PartData.ofNullable(PartManager.get(partId));
    }

    @Nullable
    public static PartData read(CompoundNBT tags) {
        String key = tags.func_74779_i(NBT_ID);
        IGearPart part = PartManager.get(new ResourceLocation(key));
        if (part == null) {
            return null;
        }
        MaterialGrade grade = MaterialGrade.fromString(tags.func_74779_i("Grade"));
        ItemStack craftingItem = ItemStack.func_199557_a((CompoundNBT)tags.func_74775_l("Item"));
        return PartData.of(part, grade, craftingItem);
    }

    @Nullable
    public static PartData readFast(CompoundNBT tags) {
        String key = tags.func_74779_i(NBT_ID);
        if (key.isEmpty()) {
            return null;
        }
        IGearPart part = PartManager.get(new ResourceLocation(key));
        if (part == null) {
            return null;
        }
        return PartData.of(part);
    }

    @Override
    public CompoundNBT write(@Nonnull CompoundNBT tags) {
        tags.func_74778_a(NBT_ID, this.part.getId().toString());
        if (this.grade != MaterialGrade.NONE) {
            tags.func_74778_a("Grade", this.grade.name());
        }
        CompoundNBT itemTag = new CompoundNBT();
        this.craftingItem.func_77955_b(itemTag);
        tags.func_218657_a("Item", (INBT)itemTag);
        return tags;
    }

    @Override
    public ResourceLocation getPartId() {
        return this.part.getId();
    }

    @Override
    @Nonnull
    public IGearPart getPart() {
        return this.part;
    }

    @Override
    @Deprecated
    public MaterialGrade getGrade() {
        return this.grade;
    }

    @Override
    public ItemStack getCraftingItem() {
        return this.craftingItem;
    }

    @Override
    public int getTier() {
        return this.part.getTier();
    }

    @Override
    @Nonnull
    public PartType getType() {
        return this.part.getType();
    }

    public float computeStat(ItemStat stat) {
        return this.part.computeStatValue(stat, this);
    }

    public Collection<StatInstance> getStatModifiers(ItemStack gear, ItemStat stat) {
        return this.part.getStatModifiers(gear, stat, this);
    }

    @Override
    public List<PartTraitInstance> getTraits() {
        return this.getTraits(ItemStack.field_190927_a);
    }

    public List<PartTraitInstance> getTraits(ItemStack gear) {
        return this.part.getTraits(gear, this);
    }

    public ITextComponent getDisplayName(ItemStack gear) {
        return this.part.getDisplayName(this, gear);
    }

    public float getRepairAmount(ItemStack gear, RepairContext.Type type) {
        return this.part.getRepairAmount(new RepairContext(type, gear, this));
    }

    @Deprecated
    @Nullable
    public ResourceLocation getTexture(ItemStack gear, GearType gearClass, IPartPosition position, int animationFrame) {
        return this.part.getTexture(this, gear, gearClass, position, animationFrame);
    }

    @Deprecated
    @Nullable
    public ResourceLocation getBrokenTexture(ItemStack gear, GearType gearClass, IPartPosition position) {
        return this.part.getBrokenTexture(this, gear, gearClass, position);
    }

    @Deprecated
    public String getModelIndex(int animationFrame) {
        return this.part.getModelIndex(this, animationFrame);
    }

    public int getColor(ItemStack gear, int animationFrame) {
        return this.part.getColor(this, gear, animationFrame);
    }

    @Deprecated
    public int getFallbackColor(ItemStack gear, int animationFrame) {
        return this.part.getDisplayProperties(this, gear, animationFrame).getFallbackColor();
    }

    public int getArmorColor(ItemStack gear) {
        return this.part.getDisplayProperties(this, gear, 0).getArmorColor();
    }

    @Override
    public void onAddToGear(ItemStack gear) {
        if (this.part instanceof IUpgradePart) {
            ((IUpgradePart)((Object)this.part)).onAddToGear(gear, this.craftingItem);
        }
    }

    public void onRemoveFromGear(ItemStack gear) {
        this.part.onRemoveFromGear(gear, this);
    }

    public String toString() {
        return "PartData{" + this.part + "}";
    }
}

