/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.parts.type;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.event.GetStatModifierEvent;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.api.parts.IPartSerializer;
import net.silentchaos512.gear.api.parts.PartTraitInstance;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.parts.AbstractGearPart;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartPositions;
import net.silentchaos512.gear.parts.PartTextureType;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.utils.EnumUtils;

public class CompoundPart
extends AbstractGearPart {
    public static final Serializer SERIALIZER = new Serializer(SilentGear.getId("compound_part"), CompoundPart::new);
    private PartType partType;
    private IPartPosition partPosition;

    public CompoundPart(ResourceLocation name) {
        super(name);
    }

    @Override
    public PartType getType() {
        return this.partType;
    }

    @Override
    public IPartPosition getPartPosition() {
        return this.partPosition;
    }

    @Override
    public IPartSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public PartTextureType getLiteTexture(PartData part, ItemStack gear) {
        MaterialInstance material = CompoundPartItem.getPrimaryMaterial(part.getCraftingItem());
        if (material != null) {
            return material.getMaterial().getTexture(this.partType, gear);
        }
        return super.getLiteTexture(part, gear);
    }

    @Override
    public int getColor(PartData part, ItemStack gear, int animationFrame) {
        return CompoundPartItem.getColor(part.getCraftingItem());
    }

    @Override
    public ITextComponent getDisplayName(@Nullable PartData part, ItemStack gear) {
        return part != null ? part.getCraftingItem().func_200301_q() : super.getDisplayName(part, gear);
    }

    @Override
    public Collection<StatInstance> getStatModifiers(ItemStack gear, ItemStat stat, PartData part) {
        ArrayList<StatInstance> baseStats = new ArrayList<StatInstance>(this.stats.get(stat));
        ItemStack stack = part.getCraftingItem();
        if (!(stack.func_77973_b() instanceof CompoundPartItem)) {
            return baseStats;
        }
        Collection<MaterialInstance> materials = CompoundPartItem.getMaterials(stack);
        Collection statMods = materials.stream().flatMap(m -> m.getStatModifiers(stat, this.partType, gear).stream()).collect(Collectors.toList());
        ArrayList<StatInstance> ret = new ArrayList<StatInstance>(baseStats);
        for (StatInstance.Operation op : StatInstance.Operation.values()) {
            Collection modsForOp = statMods.stream().filter(s -> s.getOp() == op).collect(Collectors.toList());
            if (modsForOp.isEmpty()) continue;
            StatInstance mod = StatInstance.getWeightedAverageMod(modsForOp, op);
            ret.add(mod);
        }
        GetStatModifierEvent event = new GetStatModifierEvent(part, stat, ret);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getModifiers();
    }

    @Override
    public List<PartTraitInstance> getTraits(ItemStack gear, PartData part) {
        ArrayList<PartTraitInstance> ret = new ArrayList<PartTraitInstance>(super.getTraits(gear, part));
        TraitHelper.getTraits(CompoundPartItem.getMaterials(part.getCraftingItem()), PartType.ROD, gear).forEach((trait, level) -> ret.add(new PartTraitInstance((ITrait)trait, (int)level, (Collection<ITraitCondition>)Collections.emptyList())));
        return ret;
    }

    private static class Serializer
    extends AbstractGearPart.Serializer<CompoundPart> {
        Serializer(ResourceLocation serializerId, Function<ResourceLocation, CompoundPart> function) {
            super(serializerId, function);
        }

        @Override
        public CompoundPart read(ResourceLocation id, JsonObject json) {
            CompoundPart part = (CompoundPart)super.read(id, json);
            part.partType = PartType.get(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"part_type")));
            part.partPosition = (IPartPosition)((Object)EnumUtils.byName((String)JSONUtils.func_151200_h((JsonObject)json, (String)"part_position"), (Enum)PartPositions.ANY));
            return part;
        }

        @Override
        public CompoundPart read(ResourceLocation id, PacketBuffer buffer) {
            CompoundPart part = (CompoundPart)super.read(id, buffer);
            part.partType = PartType.get(buffer.func_192575_l());
            part.partPosition = (IPartPosition)((Object)EnumUtils.byName((String)buffer.func_218666_n(), (Enum)PartPositions.ANY));
            return part;
        }

        @Override
        public void write(PacketBuffer buffer, CompoundPart part) {
            super.write(buffer, part);
            buffer.func_192572_a(part.partType.getName());
            for (PartPositions pos : PartPositions.values()) {
                if (pos != part.partPosition) continue;
                buffer.func_180714_a(pos.name());
                break;
            }
        }
    }
}

