/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.traits;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.traits.AttributeTrait;
import net.silentchaos512.gear.traits.BlockPlacerTrait;
import net.silentchaos512.gear.traits.DamageTypeTrait;
import net.silentchaos512.gear.traits.DurabilityTrait;
import net.silentchaos512.gear.traits.EnchantmentTrait;
import net.silentchaos512.gear.traits.NBTTrait;
import net.silentchaos512.gear.traits.PotionEffectTrait;
import net.silentchaos512.gear.traits.SimpleTrait;
import net.silentchaos512.gear.traits.StatModifierTrait;
import net.silentchaos512.gear.traits.SynergyTrait;
import net.silentchaos512.gear.traits.TraitManager;

public final class TraitSerializers {
    private static final Map<ResourceLocation, ITraitSerializer<?>> REGISTRY = new HashMap();

    private TraitSerializers() {
    }

    public static <S extends ITraitSerializer<T>, T extends ITrait> S register(S serializer) {
        if (REGISTRY.containsKey(serializer.getName())) {
            throw new IllegalArgumentException("Duplicate trait serializer " + serializer.getName());
        }
        SilentGear.LOGGER.info(TraitManager.MARKER, "Registered serializer '{}'", (Object)serializer.getName());
        REGISTRY.put(serializer.getName(), serializer);
        return serializer;
    }

    public static ITrait deserialize(ResourceLocation id, JsonObject json) {
        String typeStr = JSONUtils.func_151200_h((JsonObject)json, (String)"type");
        if (!typeStr.contains(":")) {
            typeStr = "silentgear:" + typeStr;
        }
        ResourceLocation type = new ResourceLocation(typeStr);
        TraitSerializers.log(() -> "deserialize " + id + " (type " + type + ")");
        ITraitSerializer<?> serializer = REGISTRY.get(type);
        if (serializer == null) {
            throw new JsonParseException("Invalid or unsupported trait type " + type);
        }
        return serializer.read(id, json);
    }

    public static ITrait read(PacketBuffer buffer) {
        ResourceLocation id = buffer.func_192575_l();
        ResourceLocation type = buffer.func_192575_l();
        TraitSerializers.log(() -> "read " + id + " (type " + type + ")");
        ITraitSerializer<?> serializer = REGISTRY.get(type);
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown trait serializer " + type);
        }
        return serializer.read(id, buffer);
    }

    public static <T extends ITrait> void write(T trait, PacketBuffer buffer) {
        ResourceLocation id = trait.getId();
        ResourceLocation type = trait.getSerializer().getName();
        TraitSerializers.log(() -> "write " + id + " (type " + type + ")");
        buffer.func_192572_a(id);
        buffer.func_192572_a(type);
        ITraitSerializer<?> serializer = trait.getSerializer();
        serializer.write(buffer, trait);
    }

    private static void log(Supplier<?> msg) {
        if (((Boolean)Config.GENERAL.extraPartAndTraitLogging.get()).booleanValue()) {
            SilentGear.LOGGER.info(TraitManager.MARKER, msg.get());
        }
    }

    static {
        TraitSerializers.register(SimpleTrait.SERIALIZER);
        TraitSerializers.register(DamageTypeTrait.SERIALIZER);
        TraitSerializers.register(DurabilityTrait.SERIALIZER);
        TraitSerializers.register(EnchantmentTrait.SERIALIZER);
        TraitSerializers.register(NBTTrait.SERIALIZER);
        TraitSerializers.register(PotionEffectTrait.SERIALIZER);
        TraitSerializers.register(StatModifierTrait.SERIALIZER);
        TraitSerializers.register(AttributeTrait.SERIALIZER);
        TraitSerializers.register(BlockPlacerTrait.SERIALIZER);
        TraitSerializers.register(SynergyTrait.SERIALIZER);
    }
}

