/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.EndNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreArmor;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.IPartData;
import net.silentchaos512.gear.api.parts.IUpgradePart;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.parts.PartConst;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gear.traits.SynergyTrait;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.collection.StackList;

public final class GearData {
    private static final String NBT_ROOT = "SGear_Data";
    private static final String NBT_ROOT_CONSTRUCTION = "Construction";
    private static final String NBT_ROOT_PROPERTIES = "Properties";
    @Deprecated
    private static final String NBT_ROOT_MODEL_KEYS = "ModelKeys";
    private static final String NBT_ROOT_RENDERING = "Rendering";
    private static final String NBT_ROOT_STATISTICS = "Statistics";
    @Deprecated
    private static final String NBT_ARMOR_COLOR = "ArmorColor";
    @Deprecated
    private static final String NBT_BLENDED_HEAD_COLOR = "BlendedHeadColor";
    private static final String NBT_COLORS = "Colors";
    private static final String NBT_CONSTRUCTION_PARTS = "Parts";
    private static final String NBT_LOCK_STATS = "LockStats";
    private static final String NBT_IS_EXAMPLE = "IsExample";
    @Deprecated
    private static final String NBT_RANDOM_GRADING_DONE = "RandomGradingDone";
    private static final String NBT_SYNERGY = "synergy";
    private static final String NBT_TIER = "Tier";
    private static final String NBT_UUID = "SGear_UUID";
    private static final String NBT_BROKEN_COUNT = "BrokenCount";
    private static final String NBT_REPAIR_COUNT = "RepairCount";
    public static final String NBT_STATS = "Stats";
    private static final boolean STAT_DEBUGGING = true;
    private static final double SYNERGY_MULTI = 1.1;

    private GearData() {
        throw new IllegalAccessError("Utility class");
    }

    @Deprecated
    public static void recalculateStats(ItemStack stack) {
        GearData.recalculateStats(stack, null);
    }

    public static void recalculateStats(ItemStack stack, @Nullable PlayerEntity player) {
        boolean partsListValid;
        if (!GearHelper.isGear(stack)) {
            SilentGear.LOGGER.error("Called recalculateStats on non-gear item, {}", (Object)stack);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return;
        }
        GearData.getUUID(stack);
        ICoreItem item = (ICoreItem)stack.func_77973_b();
        PartDataList parts = GearData.getConstructionParts(stack);
        CompoundNBT propertiesCompound = GearData.getData(stack, NBT_ROOT_PROPERTIES);
        if (!propertiesCompound.func_74764_b(NBT_LOCK_STATS)) {
            propertiesCompound.func_74757_a(NBT_LOCK_STATS, false);
        }
        boolean statsUnlocked = !propertiesCompound.func_74767_n(NBT_LOCK_STATS);
        boolean bl = partsListValid = !parts.isEmpty() && !parts.getMains().isEmpty();
        if (statsUnlocked && partsListValid) {
            if (player != null) {
                SilentGear.LOGGER.debug("Recalculating for {}'s {}", (Object)player.func_195047_I_(), (Object)stack.func_200301_q().func_150254_d());
            }
            GearData.clearCachedData(stack);
            GearData.addOrRemoveHighlightPart(stack, parts);
            propertiesCompound.func_74778_a("ModVersion", SilentGear.getVersion());
            PartDataList uniqueParts = parts.getUniqueParts(true);
            Map<ITrait, Integer> traits = TraitHelper.getTraits(stack, parts);
            double synergy = GearData.calculateSynergyValue(parts, uniqueParts, traits);
            boolean hasMissingRod = item instanceof ICoreTool && parts.getRods().isEmpty();
            Multimap<ItemStat, StatInstance> stats = GearData.getStatModifiers(stack, item, parts, synergy);
            Map<ItemStat, Float> oldStatValues = GearData.getCurrentStatsForDebugging(stack);
            float damageRatio = (float)stack.func_77952_i() / (float)stack.func_77958_k();
            CompoundNBT statsCompound = new CompoundNBT();
            for (ItemStat stat : stats.keySet()) {
                float initialValue = stat.compute(0.0f, stats.get((Object)stat));
                float withMissingParts = hasMissingRod ? stat.withMissingRodEffect(initialValue) : initialValue;
                float withTraits = TraitHelper.activateTraits(stack, withMissingParts, (trait, level, val) -> {
                    TraitActionContext context = new TraitActionContext(player, level, stack);
                    return trait.onGetStat(context, stat, val, damageRatio);
                });
                float value = Config.GENERAL.getStatWithMultiplier(stat, withTraits);
                ResourceLocation statId = Objects.requireNonNull(stat.getRegistryName());
                propertiesCompound.func_82580_o(statId.func_110623_a());
                statsCompound.func_74776_a(statId.toString(), stat.clampValue(value));
            }
            propertiesCompound.func_218657_a(NBT_STATS, (INBT)statsCompound);
            if (player != null) {
                GearData.printStatsForDebugging(stack, stats, oldStatValues);
            }
            ListNBT traitList = new ListNBT();
            traits.forEach((trait, level) -> traitList.add((Object)trait.write((int)level)));
            propertiesCompound.func_218657_a("Traits", (INBT)traitList);
            propertiesCompound.func_74776_a(NBT_SYNERGY, (float)synergy);
        } else {
            SilentGear.LOGGER.debug("Not recalculating stats for {}'s {}", (Object)player, (Object)stack);
            GearData.fixStatsCompound(propertiesCompound);
        }
        GearData.updateRenderingInfo(stack, parts);
    }

    private static void fixStatsCompound(CompoundNBT properties) {
        CompoundNBT statsTag = properties.func_74775_l(NBT_STATS);
        for (ItemStat stat : (IForgeRegistry)ItemStats.REGISTRY.get()) {
            ResourceLocation statId = Objects.requireNonNull(stat.getRegistryName());
            String oldKey = statId.func_110623_a();
            if (!properties.func_74764_b(oldKey)) continue;
            float value = properties.func_74760_g(oldKey);
            properties.func_82580_o(oldKey);
            statsTag.func_74776_a(statId.toString(), value);
        }
        properties.func_218657_a(NBT_STATS, (INBT)statsTag);
    }

    @Nullable
    private static Map<ItemStat, Float> getCurrentStatsForDebugging(ItemStack stack) {
        HashMap<ItemStat, Float> map = new HashMap<ItemStat, Float>();
        ItemStats.allStatsOrdered().forEach(stat -> map.put((ItemStat)((Object)stat), Float.valueOf(GearData.getStat(stack, stat))));
        return map;
    }

    private static void printStatsForDebugging(ItemStack stack, Multimap<ItemStat, StatInstance> stats, @Nullable Map<ItemStat, Float> oldStats) {
        if (oldStats != null && SilentGear.LOGGER.isDebugEnabled()) {
            Map<ItemStat, Float> newStats = GearData.getCurrentStatsForDebugging(stack);
            assert (newStats != null);
            for (ItemStat stat : stats.keySet()) {
                float oldValue = oldStats.get((Object)stat).floatValue();
                float newValue = newStats.get((Object)stat).floatValue();
                float change = newValue - oldValue;
                SilentGear.LOGGER.debug(" - {}: {} -> {} ({}) - mods: [{}]", (Object)stat.getDisplayName().func_150254_d(), (Object)Float.valueOf(oldValue), (Object)Float.valueOf(newValue), change < 0.0f ? Float.valueOf(change) : "+" + change, (Object)stats.get((Object)stat).stream().map(m -> m.formattedString(stat, 5, false)).collect(Collectors.joining(", ")));
            }
        }
    }

    @Deprecated
    private static void addOrRemoveHighlightPart(ItemStack stack, PartDataList parts) {
        PartData primary = parts.getPrimaryMain();
        if (primary == null) {
            return;
        }
        boolean changed = false;
        if (primary.getPart().getDisplayProperties(primary, stack, 0).hasHighlight()) {
            if (parts.getParts(p -> p.getType() == PartType.HIGHLIGHT).isEmpty()) {
                IGearPart highlight = PartManager.get(PartConst.HIGHLIGHT);
                if (highlight != null) {
                    parts.add(PartData.of(highlight));
                    changed = true;
                } else {
                    SilentGear.LOGGER.error("GearData#addOrRemoveHighlightPart: highlight part is missing?");
                }
            }
        } else {
            changed = parts.removeIf(p -> p.getType() == PartType.HIGHLIGHT);
        }
        if (changed) {
            GearData.writeConstructionParts(stack, parts);
        }
    }

    private static void clearCachedData(ItemStack stack) {
        CompoundNBT construction = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        construction.func_82580_o(NBT_TIER);
    }

    private static void updateRenderingInfo(ItemStack stack, PartDataList parts) {
        CompoundNBT nbt = GearData.getData(stack, NBT_ROOT_RENDERING);
        List<PartData> mains = parts.getMains();
        nbt.func_82580_o(NBT_ARMOR_COLOR);
        nbt.func_82580_o(NBT_BLENDED_HEAD_COLOR);
        CompoundNBT colors = nbt.func_74775_l(NBT_COLORS);
        for (PartType partType : PartType.getValues()) {
            int color;
            List<PartData> list = parts.getPartsOfType(partType);
            String key = partType.getName().func_110623_a();
            colors.func_82580_o(key);
            if (list.isEmpty() || (color = GearData.getBlendedColor(stack, list) & 0xFFFFFF) >= 0xFFFFFF) continue;
            colors.func_74768_a(key, color);
        }
        if (stack.func_77973_b() instanceof ICoreArmor) {
            colors.func_74768_a("armor", GearData.getPrimaryColor(stack, mains));
        } else {
            colors.func_82580_o("armor");
        }
        nbt.func_218657_a(NBT_COLORS, (INBT)colors);
        GearData.createAndSaveModelKeys(stack, (ICoreItem)stack.func_77973_b(), parts);
    }

    @Deprecated
    private static void createAndSaveModelKeys(ItemStack stack, ICoreItem item, PartDataList parts) {
        stack.func_190925_c(NBT_ROOT).func_82580_o(NBT_ROOT_MODEL_KEYS);
    }

    @Deprecated
    public static String getCachedModelKey(ItemStack stack, int animationFrame) {
        return "DEPRECATED";
    }

    public static Multimap<ItemStat, StatInstance> getStatModifiers(ItemStack stack, @Nullable ICoreItem item, PartDataList parts, double synergy) {
        StatModifierMap stats = new StatModifierMap();
        for (ItemStat stat : ItemStats.allStatsOrderedExcluding(item != null ? item.getExcludedStats(stack) : Collections.emptyList())) {
            if (item != null) {
                item.getBaseStatModifier(stat).ifPresent(mod -> stats.put((Object)stat, mod));
                item.getStatModifier(stat).ifPresent(mod -> stats.put((Object)stat, mod));
            }
            parts.forEach(part -> part.getStatModifiers(stack, stat).forEach(mod -> stats.put((Object)stat, mod.copy())));
            if (!stat.doesSynergyApply()) continue;
            stats.put((Object)stat, new StatInstance((float)synergy - 1.0f, StatInstance.Operation.MUL2));
        }
        return stats;
    }

    private static double getBaseSynergy(PartDataList parts) {
        int x = parts.getMains().size();
        double a = 1.1;
        return 1.1 * ((double)x / ((double)x + 1.1)) + 0.47619047619047616;
    }

    public static double calculateSynergyValue(PartDataList parts, PartDataList uniqueParts, Map<ITrait, Integer> traits) {
        float primaryRarity;
        double synergy = GearData.getBaseSynergy(uniqueParts);
        PartData primaryMain = parts.getPrimaryMain();
        float maxRarity = primaryRarity = primaryMain == null ? 0.0f : primaryMain.computeStat(ItemStats.RARITY);
        int maxTier = 0;
        for (PartData data : uniqueParts) {
            maxRarity = Math.max(maxRarity, data.computeStat(ItemStats.RARITY));
            maxTier = Math.max(maxTier, data.getPart().getTier());
        }
        for (PartData data : uniqueParts) {
            if (maxRarity > 0.0f) {
                float rarity = data.computeStat(ItemStats.RARITY);
                synergy -= 0.005 * (double)Math.abs(primaryRarity - rarity);
            }
            if (maxTier <= 0) continue;
            int tier = data.getPart().getTier();
            synergy -= (double)(0.16f * (float)Math.abs(maxTier - tier));
        }
        for (ITrait trait : traits.keySet()) {
            if (!(trait instanceof SynergyTrait)) continue;
            synergy = ((SynergyTrait)trait).apply(synergy, traits.get(trait));
        }
        return synergy;
    }

    public static float getStat(ItemStack stack, ItemStat stat) {
        String key;
        CompoundNBT tags = GearData.getData(stack, NBT_ROOT_PROPERTIES).func_74775_l(NBT_STATS);
        return tags.func_74764_b(key = Objects.requireNonNull(stat.getRegistryName()).toString()) ? tags.func_74760_g(key) : stat.getDefaultValue();
    }

    public static int getStatInt(ItemStack stack, ItemStat stat) {
        return Math.round(GearData.getStat(stack, stat));
    }

    public static boolean hasLockedStats(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_PROPERTIES).func_74767_n(NBT_LOCK_STATS);
    }

    public static void setLockedStats(ItemStack stack, boolean lock) {
        GearData.getData(stack, NBT_ROOT_PROPERTIES).func_74757_a(NBT_LOCK_STATS, lock);
    }

    public static PartDataList getConstructionParts(ItemStack stack) {
        if (!GearHelper.isGear(stack)) {
            return PartDataList.empty();
        }
        CompoundNBT tags = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        ListNBT tagList = tags.func_150295_c(NBT_CONSTRUCTION_PARTS, 10);
        PartDataList list = PartDataList.empty();
        HashMap<PartType, Integer> partCounts = new HashMap<PartType, Integer>();
        for (INBT nbt : tagList) {
            int count;
            PartType type;
            CompoundNBT partCompound;
            PartData part;
            if (!(nbt instanceof CompoundNBT) || (part = PartData.read(partCompound = (CompoundNBT)nbt)) == null || (type = part.getType()) == null || (count = partCounts.getOrDefault(type, 0).intValue()) >= type.getMaxPerItem()) continue;
            list.add(part);
            partCounts.put(type, count + 1);
        }
        return list;
    }

    public static float getSynergyDisplayValue(ItemStack gear) {
        return GearData.getData(gear, NBT_ROOT_PROPERTIES).func_74760_g(NBT_SYNERGY);
    }

    public static int getTier(ItemStack gear) {
        if (!GearHelper.isGear(gear)) {
            return -1;
        }
        CompoundNBT data = GearData.getData(gear, NBT_ROOT_CONSTRUCTION);
        if (!data.func_74764_b(NBT_TIER)) {
            List<PartData> parts = GearData.getConstructionParts(gear).getMains();
            int max = 0;
            for (PartData part : parts) {
                if (part.getTier() <= max) continue;
                max = part.getTier();
            }
            data.func_74768_a(NBT_TIER, max);
        }
        return data.func_74762_e(NBT_TIER);
    }

    public static int getColor(ItemStack stack, PartType partType) {
        String key;
        CompoundNBT colors = GearData.getData(stack, NBT_ROOT_RENDERING).func_74775_l(NBT_COLORS);
        return colors.func_74764_b(key = partType.getName().func_110623_a()) ? colors.func_74762_e(key) : 0xFFFFFF;
    }

    public static int getHeadColor(ItemStack stack, boolean colorBlending) {
        return GearData.getColor(stack, PartType.MAIN);
    }

    public static int getArmorColor(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_RENDERING).func_74775_l(NBT_COLORS).func_74762_e("armor");
    }

    private static int getPrimaryColor(ItemStack gear, List<PartData> parts) {
        if (!parts.isEmpty()) {
            PartData part = parts.get(0);
            return part.getArmorColor(gear);
        }
        return 0xFFFFFF;
    }

    private static int getBlendedColor(ItemStack gear, List<PartData> parts) {
        int[] componentSums = new int[3];
        int maxColorSum = 0;
        int colorCount = 0;
        int partCount = parts.size();
        for (int i = 0; i < partCount; ++i) {
            PartData part = parts.get(i);
            int color = part.getPart().getColor(part, gear, 0);
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int colorWeight = (partCount - i) * (partCount - i);
            for (int j = 0; j < colorWeight; ++j) {
                maxColorSum += Math.max(r, Math.max(g, b));
                componentSums[0] = componentSums[0] + r;
                componentSums[1] = componentSums[1] + g;
                componentSums[2] = componentSums[2] + b;
                ++colorCount;
            }
        }
        if (colorCount > 0) {
            int r = componentSums[0] / colorCount;
            int g = componentSums[1] / colorCount;
            int b = componentSums[2] / colorCount;
            float maxAverage = (float)maxColorSum / (float)colorCount;
            float max = Math.max(r, Math.max(g, b));
            r = (int)((float)r * maxAverage / max);
            g = (int)((float)g * maxAverage / max);
            b = (int)((float)b * maxAverage / max);
            int finalColor = (r << 8) + g;
            finalColor = (finalColor << 8) + b;
            return finalColor;
        }
        return 0xFFFFFF;
    }

    @Nullable
    public static PartData getPrimaryPart(ItemStack stack) {
        return GearData.getPartByIndex(stack, 0);
    }

    @Nullable
    public static PartData getSecondaryPart(ItemStack stack) {
        return GearData.getPartByIndex(stack, 1);
    }

    @Nullable
    public static PartData getPrimaryRenderPartFast(ItemStack stack) {
        CompoundNBT tags = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        ListNBT tagList = tags.func_150295_c(NBT_CONSTRUCTION_PARTS, 10);
        if (tagList.isEmpty()) {
            return null;
        }
        INBT nbt = tagList.get(0);
        if (nbt instanceof CompoundNBT) {
            return PartData.readFast((CompoundNBT)nbt);
        }
        return null;
    }

    @Nullable
    private static PartData getPartByIndex(ItemStack stack, int index) {
        CompoundNBT tags = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        ListNBT tagList = tags.func_150295_c(NBT_CONSTRUCTION_PARTS, 10);
        if (index >= tagList.size()) {
            return null;
        }
        INBT nbt = tagList.get(index);
        if (nbt instanceof EndNBT) {
            return null;
        }
        PartData data = PartData.readFast((CompoundNBT)nbt);
        return data != null && data.getType() == PartType.MAIN ? data : null;
    }

    @Nullable
    public static PartData getPartOfType(ItemStack stack, PartType type) {
        CompoundNBT tags = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        ListNBT tagList = tags.func_150295_c(NBT_CONSTRUCTION_PARTS, 10);
        for (INBT nbt : tagList) {
            PartData part;
            if (!(nbt instanceof CompoundNBT) || (part = PartData.read((CompoundNBT)nbt)) == null || part.getType() != type) continue;
            return part;
        }
        return null;
    }

    public static boolean hasPartOfType(ItemStack stack, PartType type) {
        CompoundNBT tags = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        ListNBT tagList = tags.func_150295_c(NBT_CONSTRUCTION_PARTS, 10);
        for (INBT nbt : tagList) {
            PartData part;
            if (!(nbt instanceof CompoundNBT) || (part = PartData.readFast((CompoundNBT)nbt)) == null || part.getType() != type) continue;
            return true;
        }
        return false;
    }

    public static boolean isMissingRequiredPart(ItemStack gear, PartType type) {
        if (!GearHelper.isGear(gear)) {
            return false;
        }
        return ((ICoreItem)gear.func_77973_b()).requiresPartOfType(type) && !GearData.hasPartOfType(gear, type);
    }

    public static void addUpgradePart(ItemStack gear, ItemStack partStack) {
        PartData part = PartData.from(partStack);
        if (part != null) {
            GearData.addUpgradePart(gear, part);
        }
    }

    public static void addUpgradePart(ItemStack gear, PartData part) {
        if (!GearHelper.isGear(gear)) {
            return;
        }
        PartDataList parts = GearData.getConstructionParts(gear);
        if (part.getPart() instanceof IUpgradePart) {
            IUpgradePart upgradePart = (IUpgradePart)((Object)part.getPart());
            if (!upgradePart.isValidFor((ICoreItem)gear.func_77973_b())) {
                return;
            }
            if (upgradePart.replacesExisting()) {
                parts.removeIf(p -> p.getPart().getPartPosition() == part.getPart().getPartPosition());
            }
            part.onAddToGear(gear);
        }
        for (PartData partInList : parts) {
            if (partInList.getPart() != part.getPart()) continue;
            return;
        }
        parts.add(part);
        GearData.writeConstructionParts(gear, parts);
    }

    public static boolean hasPart(ItemStack gear, ResourceLocation partId) {
        IGearPart part = PartManager.get(partId);
        if (part == null) {
            return false;
        }
        return GearData.hasPart(gear, part, MaterialGrade.Range.OPEN);
    }

    public static boolean hasPart(ItemStack gear, ResourceLocation partId, MaterialGrade.Range gradeRange) {
        IGearPart part = PartManager.get(partId);
        if (part == null) {
            return false;
        }
        return GearData.hasPart(gear, part, gradeRange);
    }

    public static boolean hasPart(ItemStack gear, IGearPart part) {
        return GearData.hasPart(gear, part, MaterialGrade.Range.OPEN);
    }

    public static boolean hasPart(ItemStack gear, IGearPart part, MaterialGrade.Range gradeRange) {
        if (!GearHelper.isGear(gear)) {
            SilentGear.LOGGER.error("Called hasPart on non-gear item, {}", (Object)gear);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return false;
        }
        CompoundNBT tags = GearData.getData(gear, NBT_ROOT_CONSTRUCTION);
        ListNBT tagList = tags.func_150295_c(NBT_CONSTRUCTION_PARTS, 10);
        String upgradeName = part.getId().toString();
        for (INBT nbt : tagList) {
            if (!(nbt instanceof CompoundNBT)) continue;
            CompoundNBT partCompound = (CompoundNBT)nbt;
            String partKey = partCompound.func_74779_i("ID");
            MaterialGrade grade = MaterialGrade.fromString(partCompound.func_74779_i("Grade"));
            if (!partKey.equals(upgradeName) || !gradeRange.test(grade)) continue;
            return true;
        }
        return false;
    }

    public static void addPart(ItemStack gear, PartData part) {
        PartDataList parts = GearData.getConstructionParts(gear);
        parts.add(part);
        GearData.writeConstructionParts(gear, parts);
        part.onAddToGear(gear);
    }

    public static boolean removePart(ItemStack gear, PartData part) {
        PartDataList parts = GearData.getConstructionParts(gear);
        boolean removed = parts.remove(part);
        if (removed) {
            GearData.writeConstructionParts(gear, parts);
            part.onRemoveFromGear(gear);
        }
        return removed;
    }

    public static void writeConstructionParts(ItemStack stack, Collection<? extends IPartData> parts) {
        if (!GearHelper.isGear(stack)) {
            SilentGear.LOGGER.error("Called writeConstructionParts on non-gear item, {}", (Object)stack);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return;
        }
        CompoundNBT tags = GearData.getData(stack, NBT_ROOT_CONSTRUCTION);
        ListNBT tagList = new ListNBT();
        parts.stream().filter(p -> p.getType() == PartType.MAIN).map(p -> p.write(new CompoundNBT())).forEach(arg_0 -> tagList.add(arg_0));
        parts.stream().filter(p -> p.getType() != PartType.MAIN).map(p -> p.write(new CompoundNBT())).forEach(arg_0 -> tagList.add(arg_0));
        tags.func_218657_a(NBT_CONSTRUCTION_PARTS, (INBT)tagList);
    }

    public static UUID getUUID(ItemStack gear) {
        if (!GearHelper.isGear(gear)) {
            SilentGear.LOGGER.error("Called getUUID on non-gear item, {}", (Object)gear);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return new UUID(0L, 0L);
        }
        CompoundNBT tags = gear.func_196082_o();
        if (!tags.func_186855_b(NBT_UUID)) {
            UUID uuid = UUID.randomUUID();
            tags.func_186854_a(NBT_UUID, uuid);
            return uuid;
        }
        return tags.func_186857_a(NBT_UUID);
    }

    private static CompoundNBT getData(ItemStack stack, String compoundKey) {
        if (SilentGear.isDevBuild() && !GearHelper.isGear(stack)) {
            SilentGear.LOGGER.error("Called getData on non-gear item, {}", (Object)stack);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return new CompoundNBT();
        }
        CompoundNBT rootTag = stack.func_190925_c(NBT_ROOT);
        if (!rootTag.func_74764_b(compoundKey)) {
            rootTag.func_218657_a(compoundKey, (INBT)new CompoundNBT());
        }
        return rootTag.func_74775_l(compoundKey);
    }

    static CompoundNBT getPropertiesData(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_PROPERTIES);
    }

    static CompoundNBT getStatisticsCompound(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_STATISTICS);
    }

    public static void setExampleTag(ItemStack stack, boolean value) {
        GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74757_a(NBT_IS_EXAMPLE, value);
    }

    public static boolean isExampleGear(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74767_n(NBT_IS_EXAMPLE);
    }

    @Deprecated
    public static boolean isRandomGradingDone(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74767_n(NBT_RANDOM_GRADING_DONE);
    }

    @Deprecated
    static void setRandomGradingDone(ItemStack stack, boolean value) {
        GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74757_a(NBT_RANDOM_GRADING_DONE, value);
    }

    public static int getBrokenCount(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74762_e(NBT_BROKEN_COUNT);
    }

    static void incrementBrokenCount(ItemStack stack) {
        GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74768_a(NBT_BROKEN_COUNT, GearData.getBrokenCount(stack) + 1);
    }

    public static int getRepairCount(ItemStack stack) {
        return GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74762_e(NBT_REPAIR_COUNT);
    }

    public static void incrementRepairCount(ItemStack stack, int amount) {
        GearData.getData(stack, NBT_ROOT_CONSTRUCTION).func_74768_a(NBT_REPAIR_COUNT, GearData.getRepairCount(stack) + amount);
    }

    @Mod.EventBusSubscriber(modid="silentgear")
    public static final class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            PlayerEntity player = event.getPlayer();
            StackList.from((IInventory)player.field_71071_by).stream().filter(s -> s.func_77973_b() instanceof ICoreItem).forEach(s -> GearData.recalculateStats(s, player));
        }
    }
}

