/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public final class DimPos {
    public static final DimPos ZERO = new DimPos(0, 0, 0, (RegistryKey<World>)World.field_234918_g_);
    private final int posX;
    private final int posY;
    private final int posZ;
    private final RegistryKey<World> dimension;

    public static DimPos of(BlockPos pos, RegistryKey<World> dimension) {
        return new DimPos(pos, dimension);
    }

    public static DimPos of(int x, int y, int z, RegistryKey<World> dimension) {
        return new DimPos(x, y, z, dimension);
    }

    public static DimPos of(Entity entity) {
        return new DimPos(entity.func_233580_cy_(), (RegistryKey<World>)entity.field_70170_p.func_234923_W_());
    }

    private DimPos(BlockPos pos, RegistryKey<World> dimension) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dimension);
    }

    private DimPos(int x, int y, int z, RegistryKey<World> dimension) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.dimension = dimension;
    }

    public int getX() {
        return this.posX;
    }

    public int getY() {
        return this.posY;
    }

    public int getZ() {
        return this.posZ;
    }

    public RegistryKey<World> getDimension() {
        return this.dimension;
    }

    public static DimPos read(CompoundNBT tags) {
        return DimPos.of(tags.func_74762_e("posX"), tags.func_74762_e("posY"), tags.func_74762_e("posZ"), (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(tags.func_74779_i("dim"))));
    }

    public void write(CompoundNBT tags) {
        tags.func_74768_a("posX", this.posX);
        tags.func_74768_a("posY", this.posY);
        tags.func_74768_a("posZ", this.posZ);
        tags.func_74778_a("dim", this.dimension.getRegistryName().toString());
    }

    public BlockPos getPos() {
        return new BlockPos(this.posX, this.posY, this.posZ);
    }

    public Vector3d getPosCentered(double yOffset) {
        return new Vector3d((double)this.posX + 0.5, (double)this.posY + yOffset, (double)this.posZ + 0.5);
    }

    public DimPos offset(Direction facing, int n) {
        if (n == 0) {
            return this;
        }
        return new DimPos(this.posX + facing.func_82601_c() * n, this.posY + facing.func_96559_d() * n, this.posZ + facing.func_82599_e() * n, this.dimension);
    }

    public String toString() {
        return String.format("(%d, %d, %d, d%d)", this.posX, this.posY, this.posZ, this.dimension);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DimPos)) {
            return false;
        }
        DimPos pos = (DimPos)other;
        return pos.dimension == this.dimension && pos.posX == this.posX && pos.posY == this.posY && pos.posZ == this.posZ;
    }

    public int hashCode() {
        return 31 * (31 * (31 * this.posX + this.posY) + this.posZ) + this.dimension.getRegistryName().hashCode();
    }
}

