/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.world.feature;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.FlowersFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class PlantFeature
extends FlowersFeature<NoFeatureConfig> {
    private final BlockState plant;
    private final int tryCount;
    private final int maxCount;

    public PlantFeature(BlockState plant, int tryCount, int maxCount) {
        super(NoFeatureConfig.field_236558_a_);
        this.plant = plant;
        this.tryCount = tryCount;
        this.maxCount = maxCount;
    }

    public boolean func_241855_a(ISeedReader worldIn, ChunkGenerator chunkGenerator, Random rand, BlockPos pos, NoFeatureConfig config) {
        BlockState toPlace = this.getFlowerToPlace(rand, pos, config);
        int placedCount = 0;
        for (int j = 0; j < this.tryCount && placedCount < this.maxCount; ++j) {
            BlockPos pos1 = pos.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            if (!worldIn.func_175623_d(pos1) || pos1.func_177956_o() >= 255 || !toPlace.func_196955_c((IWorldReader)worldIn, pos1)) continue;
            worldIn.func_180501_a(pos1, toPlace, 2);
            ++placedCount;
        }
        return placedCount > 0;
    }

    public BlockState getFlowerToPlace(Random random, BlockPos pos, NoFeatureConfig config) {
        return this.plant;
    }

    public boolean isValidPosition(IWorld world, BlockPos pos, NoFeatureConfig config) {
        return this.plant.equals(world.func_180495_p(pos));
    }

    public int getFlowerCount(NoFeatureConfig config) {
        return this.maxCount;
    }

    public BlockPos getNearbyPos(Random random, BlockPos pos, NoFeatureConfig config) {
        return pos.func_177982_a(random.nextInt(8) - random.nextInt(8), random.nextInt(4) - random.nextInt(4), random.nextInt(8) - random.nextInt(8));
    }
}

