/*
 * Decompiled with CFR 0.152.
 */
package com.ironnugget.simplysalty;

import com.ironnugget.simplysalty.init.BlockInit;
import com.ironnugget.simplysalty.init.ItemInit;
import com.ironnugget.simplysalty.world.gen.SimplySaltyOreGen;
import java.util.stream.Collectors;
import net.minecraft.block.LanternBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="simplysalty")
@Mod.EventBusSubscriber(modid="simplysalty", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SimplySalty {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "simplysalty";
    public static SimplySalty instance;

    public SimplySalty() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        ItemInit.ITEMS.register(modEventBus);
        BlockInit.BLOCKS.register(modEventBus);
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        BlockInit.BLOCKS.getEntries().stream().filter(block -> !(block.get() instanceof LanternBlock)).map(RegistryObject::get).forEach(block -> {
            Item.Properties properties = new Item.Properties().func_200916_a((ItemGroup)SimplySaltyItemGroup.instance);
            BlockItem blockItem = new BlockItem(block, properties);
            blockItem.setRegistryName(block.getRegistryName());
            registry.register((IForgeRegistryEntry)blockItem);
        });
        LOGGER.debug("Registered BlockItems!");
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    @SubscribeEvent
    public static void loadCompleteEvent(FMLLoadCompleteEvent event) {
        SimplySaltyOreGen.generateOre();
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"examplemod", (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    public static class SimplySaltyItemGroup
    extends ItemGroup {
        public static final SimplySaltyItemGroup instance = new SimplySaltyItemGroup(ItemGroup.field_78032_a.length, "simplysalty");

        private SimplySaltyItemGroup(int index, String label) {
            super(index, label);
        }

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)BlockInit.salt_ore.get());
        }
    }
}

