/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont;

import bre.smoothfont.FontRasterizer;
import bre.smoothfont.FontRendererHookList;
import bre.smoothfont.FontShader;
import bre.smoothfont.FontTextureManager;
import bre.smoothfont.FontUtils;
import bre.smoothfont.GlStateManagerHelper;
import bre.smoothfont.RenderCharReplacedChecker;
import bre.smoothfont.asm.CorePlugin;
import bre.smoothfont.compat.MathHelper;
import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.config.GlobalConfig;
import bre.smoothfont.util.GLUtils;
import bre.smoothfont.util.Logger;
import bre.smoothfont.util.ModLib;
import bre.smoothfont.util.Reflection;
import java.awt.image.BufferedImage;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;

public class FontRendererHook {
    private float fontScale;
    public float roundedFontScale;
    public int autoBrightnessDefault;
    public int autoBrightnessUnicode;
    public float brightnessBoundaryScaleFactorDefault;
    public float brightnessBoundaryScaleFactorUnicode;
    private boolean overlayScreen;
    private boolean exclusionCondUnicode;
    private boolean exclusionCondDefault;
    public boolean orthographic;
    private boolean fractionCoord;
    private float prevTexLodBias;
    private boolean prevBlend;
    private int prevBlendSrcRGB;
    private int prevBlendDstRGB;
    private static Minecraft mc = Minecraft.func_71410_x();
    public FontRenderer fontRenderer;
    private static FontRendererHook mcDefaultFontRendererHook = null;
    public boolean disableAllFeatures = true;
    public String reasonForDisable = null;
    public boolean changeFont = false;
    public int precisionMode = 1;
    public boolean keepMcFontWidth = false;
    public boolean boldFlag = false;
    public boolean shadowFlag = false;
    public boolean thinFontFlag = false;
    public boolean ignoreHook = false;
    private static float fontScaleRoundingToleranceRate = 0.0f;
    private static final ResourceLocation[] unicodePageLocations = new ResourceLocation[256];
    private static final ResourceLocation[] osFontUnicodePageLocations = new ResourceLocation[256];
    private static ResourceLocation osFontDefaultPageLocation = new ResourceLocation("smoothfont", "osFontDefaultPage");
    private FontShader fontShader;
    private boolean anisotropicFilterEnabled = false;
    private FontTextureManager fontTextureManager;
    private FontRasterizer rasterizer;
    private float optifineOffsetBold = 1.0f;
    public float[] optifineCharWidthFloat = null;
    private RenderCharReplacedChecker renderCharReplacedChecker = new RenderCharReplacedChecker();
    private boolean renderStringAtPosWorked = false;
    public static boolean modLoaded = false;
    public static List<FontRendererHook> uninitFontRendererHookList = new ArrayList<FontRendererHook>();
    public static float shadowAdjustVal = 0.0f;
    public static int texFilterSettingId = 0;
    public boolean enableHookRenderChar = false;
    public boolean enableHookGetStringWidth = false;
    public boolean enableHookGetCharWidth = false;
    public boolean enableHookTrimStringToWidth = false;
    public boolean enableHookSizeStringToWidth = false;
    private float horizontalMargin;
    private float verticalMargin;
    private FloatBuffer floatBuf = BufferUtils.createFloatBuffer((int)16);

    public FontRendererHook(FontRenderer renderer) {
        if (CorePlugin.optifineNoCharWidthInt) {
            // empty if block
        }
        this.disableAllFeatures = true;
        this.fontRenderer = renderer;
        this.fontTextureManager = FontTextureManager.getInstance();
        this.rasterizer = FontRasterizer.getInstance();
        FontRendererHookList.add(this);
        this.fontShader = FontShader.getInstance();
    }

    public void fontRendererExitHook() {
        if (GlobalConfig.configLoaded) {
            this.initAfterConfigLoaded(false);
        } else {
            uninitFontRendererHookList.add(this);
        }
        String cls = this.fontRenderer.getClass().getName();
        if ("net.minecraft.client.gui.FontRenderer".equals(cls) && this.fontRenderer.field_111273_g != null && ("textures/font/ascii_sga.png".equals(this.fontRenderer.field_111273_g.func_110623_a()) || "mcpatcher/font/ascii_sga.png".equals(this.fontRenderer.field_111273_g.func_110623_a()))) {
            this.disableAllFeatures = true;
            FontRendererHookList.remove(this);
        }
        if (GlobalConfig.configLoaded) {
            FontRendererHook.setUnicodeFlagSuitably(this);
        }
    }

    public static void initAfterConfigLoaded() {
        for (FontRendererHook fontRendererHook : uninitFontRendererHookList) {
            fontRendererHook.initAfterConfigLoaded(true);
        }
    }

    public void initAfterConfigLoaded(boolean deferredInit) {
        String cls = this.fontRenderer.getClass().getName();
        if ("net.minecraftforge.fml.client.SplashProgress$SplashFontRenderer".equals(cls)) {
            this.disableAllFeatures = true;
            FontRendererHookList.remove(this);
        } else if ("net.minecraftforge.client.model.SimpleModelFontRenderer".equals(cls)) {
            this.disableAllFeatures = true;
            FontRendererHookList.remove(this);
        } else {
            this.disableAllFeatures = false;
        }
        for (String c : CommonConfig.globalConfig.unaffectedClasses) {
            if (!cls.equals(c)) continue;
            this.disableAllFeatures = true;
            FontRendererHookList.remove(this);
        }
        for (String c : CommonConfig.globalConfig.highPrecisionClasses) {
            if (!cls.equals(c)) continue;
            this.precisionMode = 0;
        }
        for (String c : CommonConfig.globalConfig.vanillaPrecisionClasses) {
            if (!cls.equals(c)) continue;
            this.precisionMode = 2;
        }
        if ("net.minecraft.client.gui.FontRenderer".equals(cls) && CommonConfig.globalConfig.workaroundKeepOriginalWidthValues) {
            this.keepMcFontWidth = true;
        }
        this.updateChangeFontFlag();
        if (CommonConfig.currentConfig.useOSFont) {
            if (!this.rasterizer.glyphsGenerationError) {
                boolean result = this.rasterizer.initFontCache();
                if (!result) {
                    this.changeFont = false;
                    this.rasterizer.clearFontCache();
                }
            } else {
                this.changeFont = false;
            }
        }
        if (!this.disableAllFeatures && this.changeFont) {
            this.rasterizer.restoreGlyphWidth(this);
        }
        this.updateMargins();
        this.updateHookFlags();
        shadowAdjustVal = FontUtils.getShadowAdjustVal(CommonConfig.currentConfig.shadowLength);
        texFilterSettingId = FontUtils.getTexFilterSettingId();
        fontScaleRoundingToleranceRate = (float)CommonConfig.currentConfig.fontScaleRoundingTolerance * 0.01f;
        if (!this.disableAllFeatures) {
            try {
                FontTextureManager.supportAnisotropicFilter = GLUtils.checkAnisotropicFilterSupport();
                if (!FontTextureManager.supportAnisotropicFilter) {
                    CommonConfig.currentConfig.enableAnisotropicFilter = false;
                    CommonConfig.saveCurrentConfig();
                }
            }
            catch (Exception e) {
                if (CommonConfig.globalConfig.debugLog) {
                    e.printStackTrace();
                }
                Logger.info("Disabled smoothfont functions. (reason:" + e.getMessage() + "):" + this.fontRenderer.toString());
                this.disableAllFeatures = true;
            }
        }
        if (deferredInit) {
            this.readFontTextureExitHook();
            this.readGlyphSizesExitHook();
            FontRendererHook.setUnicodeFlagSuitably(this);
        }
    }

    public static void setUnicodeFlagSuitably(FontRendererHook frh) {
        if (CommonConfig.currentConfig.forceUnicode && mc.func_152349_b()) {
            if (frh.disableAllFeatures) {
                return;
            }
            frh.fontRenderer.field_78293_l = true;
        }
    }

    public static FontRendererHook getMcDefaultFontRendererHook() {
        if (mcDefaultFontRendererHook == null || FontRendererHook.mcDefaultFontRendererHook.fontRenderer != FontRendererHook.mc.field_71466_p) {
            mcDefaultFontRendererHook = FontRendererHookList.getFontRendererHook(FontRendererHook.mc.field_71466_p);
        }
        return mcDefaultFontRendererHook;
    }

    private void saveLodBias() {
        if (CommonConfig.currentConfig.enableMipmap) {
            this.prevTexLodBias = GL11.glGetTexEnvf((int)34048, (int)34049);
        }
    }

    private void restoreLodBias() {
        if (CommonConfig.currentConfig.enableMipmap) {
            GlStateManager.func_187436_a((int)34048, (int)34049, (float)this.prevTexLodBias);
        }
    }

    private void setLodBias() {
        if (CommonConfig.currentConfig.enableMipmap) {
            if (this.orthographic) {
                if (this.fractionCoord) {
                    GlStateManager.func_187436_a((int)34048, (int)34049, (float)((float)CommonConfig.currentConfig.mipmapLodBias / 10.0f));
                } else {
                    GlStateManager.func_187436_a((int)34048, (int)34049, (float)((float)CommonConfig.currentConfig.overlayLodBias / 10.0f));
                }
            } else {
                GlStateManager.func_187436_a((int)34048, (int)34049, (float)((float)CommonConfig.currentConfig.mipmapLodBias / 10.0f));
            }
        }
    }

    public float renderCharHook(char ch, boolean italic) {
        if (ch == ' ') {
            return this.getSpaceWidth();
        }
        return -1.0f;
    }

    public float renderDefaultCharHook(int id, boolean italic, float posX, float posY) {
        float width;
        float texW;
        float right;
        this.renderCharReplacedChecker.renderDefaultCharWorked = true;
        ResourceLocation curResLoc = this.changeFont ? osFontDefaultPageLocation : this.fontRenderer.field_111273_g;
        this.fontTextureManager.bindTexture(curResLoc, 256);
        char ch = FontUtils.asciiSheetChars[id];
        float left = 0.0f;
        if (this.changeFont) {
            left = (this.rasterizer.glyphWidthByte[ch] & 0xF0) >>> 4;
            switch (this.precisionMode) {
                default: {
                    right = left + this.rasterizer.glyphWidthFloat[ch];
                    texW = this.rasterizer.glyphWidthFloat[ch];
                    width = texW / 2.0f + 1.0f;
                    break;
                }
                case 2: {
                    width = this.optifineCharWidthFloat != null ? this.rasterizer.charWidthFloat[id] : (float)this.rasterizer.charWidthInt[id];
                    float width256 = width * 2.0f;
                    right = left + width256;
                    texW = width256 - 0.02f;
                    break;
                }
            }
        } else {
            width = this.optifineCharWidthFloat != null ? this.optifineCharWidthFloat[id] : (float)this.fontRenderer.field_78286_d[id];
            float width256 = width * 2.0f;
            right = left + width256;
            texW = width256 - 0.02f;
        }
        float borderWidthRate = this.fontTextureManager.getBorderWidthRate(curResLoc);
        float blankSpaceRate = this.fontTextureManager.getBlankSpaceRate(curResLoc);
        if (CommonConfig.currentConfig.fontAlignBaseline && this.changeFont) {
            posY += this.rasterizer.glyphBaselineGap[ch];
        }
        this.fontTextureManager.setAnisotropicFilter(curResLoc, this.anisotropicFilterEnabled);
        if (GlobalConfig.configLoaded && !this.exclusionCondDefault) {
            this.fontShader.setShaderParams(this, false);
            this.fontTextureManager.setTexParams(curResLoc, texFilterSettingId);
            this.renderCharCommon(id, italic, posX, posY, left, right, texW, borderWidthRate, blankSpaceRate);
        } else {
            this.fontTextureManager.setTexParamsNearest(curResLoc);
            this.renderCharCommon(id, italic, posX, posY, left, right, texW, borderWidthRate, blankSpaceRate);
        }
        return width;
    }

    public float renderUnicodeCharHook(char ch, boolean italic, byte[] glyphWidth, float posX, float posY) {
        float texW;
        float right;
        float left;
        this.renderCharReplacedChecker.renderUnicodeCharWorked = true;
        if (glyphWidth[ch] == 0) {
            return 0.0f;
        }
        if (CommonConfig.currentConfig.disableSmallItalic && this.fontScale < 2.1f) {
            italic = false;
        }
        int page = ch / 256;
        ResourceLocation unicodePageLocation = this.changeFont ? this.getOsFontUnicodePageLocation(page) : this.getUnicodePageLocation(page);
        this.fontTextureManager.bindTexture(unicodePageLocation, page);
        if (this.changeFont) {
            left = (this.rasterizer.glyphWidthByte[ch] & 0xF0) >>> 4;
            switch (this.precisionMode) {
                default: {
                    right = left + this.rasterizer.glyphWidthFloat[ch];
                    texW = this.rasterizer.glyphWidthFloat[ch];
                    break;
                }
                case 2: {
                    right = (this.rasterizer.glyphWidthByte[ch] & 0xF) + 1;
                    texW = right - left - 0.02f;
                    break;
                }
            }
        } else {
            left = (glyphWidth[ch] & 0xF0) >>> 4;
            right = (glyphWidth[ch] & 0xF) + 1;
            texW = right - left - 0.02f;
        }
        float borderWidthRate = this.fontTextureManager.getBorderWidthRate(unicodePageLocation);
        float blankSpaceRate = this.fontTextureManager.getBlankSpaceRate(unicodePageLocation);
        if (CommonConfig.currentConfig.fontAlignBaseline && this.changeFont) {
            posY += this.rasterizer.glyphBaselineGap[ch];
        }
        this.fontTextureManager.setAnisotropicFilter(unicodePageLocation, this.anisotropicFilterEnabled);
        if (GlobalConfig.configLoaded && !this.exclusionCondUnicode) {
            this.fontShader.setShaderParams(this, true);
            this.fontTextureManager.setTexParams(unicodePageLocation, texFilterSettingId);
            this.renderCharCommon(ch, italic, posX, posY, left, right, texW, borderWidthRate, blankSpaceRate);
        } else {
            this.fontTextureManager.setTexParamsNearest(unicodePageLocation);
            this.renderCharCommon(ch, italic, posX, posY, left, right, texW, borderWidthRate, blankSpaceRate);
        }
        return (right - left) / 2.0f + 1.0f;
    }

    private void renderCharCommon(int ch, boolean italic, float posX, float posY, float left, float right, float width, float borderWidthRate, float blankSpaceRate) {
        ScaledResolution scaledResolution;
        float it;
        float texSize = 256.0f + borderWidthRate * 16.0f + blankSpaceRate;
        float originMargin = borderWidthRate / 2.0f;
        float texX = (float)(ch % 16) * (16.0f + borderWidthRate) + left + originMargin;
        float texY = (float)((ch & 0xFF) / 16) * (16.0f + borderWidthRate) + originMargin;
        float f = it = italic ? 1.0f : 0.0f;
        if (this.shadowFlag) {
            posX += shadowAdjustVal;
            posY += shadowAdjustVal;
        }
        if (this.boldFlag && (scaledResolution = new ScaledResolution(mc)).func_78325_e() >= 3) {
            this.renderChar(posX - 0.25f, posY, left, right, texX, texY, width, texSize, it, originMargin);
        }
        this.renderChar(posX, posY, left, right, texX, texY, width, texSize, it, originMargin);
    }

    private void renderChar(float posX, float posY, float left, float right, float texX, float texY, float width, float texSize, float italic, float rightSideSpace) {
        float horizontalMarginLocal = this.horizontalMargin;
        if (right - left <= 15.0f) {
            // empty if block
        }
        float horizontalMarginRight = horizontalMarginLocal;
        if (left + width + horizontalMarginLocal > 16.0f + rightSideSpace) {
            horizontalMarginRight = 16.0f + rightSideSpace - width - left;
        }
        for (int i = 0; i < (CommonConfig.currentConfig.enableDouble ? 2 : 1); ++i) {
            GlStateManager.func_187447_r((int)5);
            GlStateManager.func_187426_b((float)((texX - horizontalMarginLocal) / texSize), (float)((texY - this.verticalMargin) / texSize));
            GlStateManager.func_187435_e((float)(posX - horizontalMarginLocal / 2.0f + italic), (float)(posY - this.verticalMargin / 2.0f), (float)0.0f);
            GlStateManager.func_187426_b((float)((texX - horizontalMarginLocal) / texSize), (float)((texY + 15.8f + this.verticalMargin) / texSize));
            GlStateManager.func_187435_e((float)(posX - horizontalMarginLocal / 2.0f - italic), (float)(posY + 7.9f + this.verticalMargin / 2.0f), (float)0.0f);
            GlStateManager.func_187426_b((float)((texX + horizontalMarginRight + width) / texSize), (float)((texY - this.verticalMargin) / texSize));
            GlStateManager.func_187435_e((float)(posX + horizontalMarginRight / 2.0f + width / 2.0f + italic), (float)(posY - this.verticalMargin / 2.0f), (float)0.0f);
            GlStateManager.func_187426_b((float)((texX + horizontalMarginRight + width) / texSize), (float)((texY + 15.8f + this.verticalMargin) / texSize));
            GlStateManager.func_187435_e((float)(posX + horizontalMarginRight / 2.0f + width / 2.0f - italic), (float)(posY + 7.9f + this.verticalMargin / 2.0f), (float)0.0f);
            GlStateManager.func_187437_J();
        }
    }

    public void updateMargins() {
        if (this.changeFont) {
            int fontRes = FontTextureManager.getInstance().getUnicodeFontRes(true);
            this.verticalMargin = this.horizontalMargin = (float)FontUtils.getBorderWidth(fontRes, true) / 2.0f * 16.0f / (float)fontRes;
        } else {
            this.horizontalMargin = Math.max((float)CommonConfig.currentConfig.horizontalMargin, 1.0f);
            this.verticalMargin = Math.max((float)CommonConfig.currentConfig.verticalMargin, 1.0f);
        }
    }

    public static void updateMarginsAll() {
        FontRendererHookList hookList = new FontRendererHookList(){

            @Override
            public boolean process(FontRendererHook frh) {
                frh.updateMargins();
                return true;
            }
        };
        hookList.executeAll();
    }

    public void renderStringAtPosEnterHook(String text, boolean unicodeFlag, boolean shadow) {
        Matrix4f mtxMod;
        Matrix4f mtxPrj;
        this.renderStringAtPosWorked = true;
        this.thinFontFlag = unicodeFlag;
        if (this.disableAllFeatures) {
            return;
        }
        if (this.renderCharReplacedChecker.needToCheck() && this.renderCharReplacedChecker.isReplaced(this.fontRenderer, text)) {
            this.disableAllFeatures("renderChar methods might be replaced.");
            return;
        }
        this.thinFontFlag = unicodeFlag || this.changeFont;
        this.shadowFlag = shadow;
        try {
            this.floatBuf.clear();
            GlStateManager.func_179111_a((int)2983, (FloatBuffer)this.floatBuf);
            this.floatBuf.rewind();
            mtxPrj = new Matrix4f();
            mtxPrj.load(this.floatBuf);
            this.floatBuf.clear();
            GlStateManager.func_179111_a((int)2982, (FloatBuffer)this.floatBuf);
            this.floatBuf.rewind();
            mtxMod = new Matrix4f();
            mtxMod.load(this.floatBuf);
        }
        catch (Exception e) {
            if (CommonConfig.globalConfig.debugLog) {
                e.printStackTrace();
            }
            this.disableAllFeatures(e.getMessage());
            return;
        }
        float fontScaleX = ModLib.roundIf(Math.abs((float)FontRendererHook.mc.field_71443_c * mtxPrj.m00 * mtxMod.m00), 1.0E-6f);
        float fontScaleY = ModLib.roundIf(Math.abs((float)FontRendererHook.mc.field_71440_d * mtxPrj.m11 * mtxMod.m11), 1.0E-6f);
        this.fontScale = (fontScaleX + fontScaleY) / 2.0f;
        if (mtxPrj.m22 == -0.001f && mtxPrj.m32 == -2.0f && mtxMod.m32 == -2000.0f) {
            this.overlayScreen = true;
            this.orthographic = true;
        } else {
            this.overlayScreen = false;
            if (mtxPrj.m33 == 0.0f) {
                this.orthographic = false;
                this.fontScale /= Math.abs(mtxMod.m32);
            } else {
                this.orthographic = true;
            }
        }
        float fontResUnicode = this.fontTextureManager.getUnicodeFontRes(this.changeFont);
        float fontResDefault = this.fontTextureManager.getDefaultFontRes(this.fontRenderer.field_111273_g, this.changeFont);
        if (this.orthographic) {
            this.fractionCoord = false;
            if (mtxMod.m30 * 10.0f % 5.0f != 0.0f || mtxMod.m31 * 10.0f % 5.0f != 0.0f) {
                this.fractionCoord = true;
            }
        } else {
            this.fractionCoord = true;
        }
        this.roundedFontScale = ModLib.roundIf(this.fontScale, this.fontScale * fontScaleRoundingToleranceRate);
        this.exclusionCondDefault = this.roundedFontScale * 4.0f == fontResDefault || this.orthographic && CommonConfig.currentConfig.excludeIntMultiple && this.roundedFontScale % (fontResDefault / 4.0f) == 0.0f || CommonConfig.currentConfig.excludeHighMag && (double)(this.roundedFontScale * 4.0f) >= (double)fontResDefault * CommonConfig.currentConfig.limitMagnification;
        boolean bl = this.exclusionCondUnicode = this.roundedFontScale * 4.0f == fontResUnicode || this.orthographic && CommonConfig.currentConfig.excludeIntMultiple && this.roundedFontScale % (fontResUnicode / 4.0f) == 0.0f || CommonConfig.currentConfig.excludeHighMag && (double)(this.roundedFontScale * 4.0f) >= (double)fontResUnicode * CommonConfig.currentConfig.limitMagnification;
        if (!(!CommonConfig.currentConfig.enableInterpolation || this.exclusionCondDefault && this.exclusionCondUnicode)) {
            this.fontShader.prepareAndEnableShader(this);
        }
        if (CommonConfig.currentConfig.enableAlphaBlend) {
            this.prevBlendSrcRGB = GL11.glGetInteger((int)32969);
            this.prevBlendDstRGB = GL11.glGetInteger((int)32968);
            GlStateManagerHelper.enableBlend();
            if (CommonConfig.currentConfig.enablePremultipliedAlpha) {
                GlStateManagerHelper.blendFunc(1, 771);
            } else {
                GlStateManagerHelper.blendFunc(770, 771);
            }
        }
        this.saveLodBias();
        this.setLodBias();
        this.anisotropicFilterEnabled = !this.orthographic && CommonConfig.currentConfig.enableAnisotropicFilter;
    }

    public void renderStringAtPosExitHook(boolean unicodeFlag) {
        if (GlobalConfig.configLoaded && !this.disableAllFeatures) {
            if (CommonConfig.currentConfig.enableAlphaBlend) {
                GlStateManagerHelper.blendFunc(this.prevBlendSrcRGB, this.prevBlendDstRGB);
                if (!this.prevBlend) {
                    GlStateManagerHelper.disableBlend();
                }
            }
            this.restoreLodBias();
            this.fontShader.restoreShader();
            GlStateManager.func_179144_i((int)0);
        }
    }

    public ResourceLocation getUnicodePageLocation(int page) {
        if (unicodePageLocations[page] == null) {
            FontRendererHook.unicodePageLocations[page] = new ResourceLocation(String.format("textures/font/unicode_page_%02x.png", page));
        }
        return unicodePageLocations[page];
    }

    public ResourceLocation getOsFontUnicodePageLocation(int page) {
        if (osFontUnicodePageLocations[page] == null) {
            FontRendererHook.osFontUnicodePageLocations[page] = new ResourceLocation("smoothfont", String.format("osFontUnicodePage_%02x", page));
        }
        return osFontUnicodePageLocations[page];
    }

    public void readFontTextureExitHook() {
        if (CorePlugin.optifineExist) {
            try {
                this.optifineOffsetBold = ((Float)Reflection.getField(this.fontRenderer, "offsetBold")).floatValue();
            }
            catch (Exception e) {
                Logger.error("Cannot get OptiFine offsetBold value. Use default value.");
                e.printStackTrace();
                this.optifineOffsetBold = 1.0f;
            }
            if (CorePlugin.optifineNoCharWidthInt) {
                try {
                    this.optifineCharWidthFloat = (float[])Reflection.getPrivateField(this.fontRenderer, "d");
                    Logger.info("Detected (float)charWidth[] of OptiFine.");
                }
                catch (Exception e) {
                    Logger.error("Failed to refer (float)charWidth[] of OptiFine.");
                    e.printStackTrace();
                    this.optifineCharWidthFloat = null;
                }
                if (this.optifineCharWidthFloat != null) {
                    for (int i = 0; i < this.fontRenderer.field_78286_d.length; ++i) {
                        this.fontRenderer.field_78286_d[i] = Math.round(this.optifineCharWidthFloat[i]);
                    }
                }
            } else {
                try {
                    this.optifineCharWidthFloat = (float[])Reflection.getPrivateField(this.fontRenderer, "charWidthFloat");
                    Logger.info("Detected charWidthFloat[] of OptiFine.");
                }
                catch (Exception e) {
                    Logger.error("Failed to refer charWidthFloat[] of OptiFine.");
                    e.printStackTrace();
                    this.optifineCharWidthFloat = null;
                }
            }
        }
        this.rasterizer.saveCharWidthOrig(this.fontRenderer.field_78286_d);
        if (this.disableAllFeatures) {
            return;
        }
        if (this.changeFont) {
            this.rasterizer.restoreCharWidth(this);
            if (this.optifineCharWidthFloat != null) {
                this.rasterizer.restoreCharWidthFloat(this);
            }
        }
    }

    public void readGlyphSizesExitHook() {
        this.rasterizer.saveGlyphWidthOrig(this.fontRenderer.field_78287_e);
        if (this.disableAllFeatures) {
            return;
        }
        if (this.changeFont) {
            this.rasterizer.restoreGlyphWidth(this);
        }
        if (!this.disableAllFeatures) {
            char[] sampleChars = new char[]{'1', '/', 'I'};
            this.autoBrightnessDefault = 0;
            this.autoBrightnessUnicode = 0;
            this.brightnessBoundaryScaleFactorDefault = 0.0f;
            this.brightnessBoundaryScaleFactorUnicode = 0.0f;
            int counterDefault = 0;
            int counterUnicode = 0;
            for (char ch : sampleChars) {
                BufferedImage bufImg = this.getDefaultCharImage(ch);
                int opacity = FontUtils.getTotalOpacityPosY(bufImg, bufImg.getHeight() / 2);
                if (opacity != 0) {
                    this.autoBrightnessDefault += FontUtils.getEstimatedBrightness(bufImg.getWidth(), opacity);
                    this.brightnessBoundaryScaleFactorDefault += FontUtils.getEstimatedBrightnessBoundaryScaleFactor(bufImg.getWidth(), opacity);
                    ++counterDefault;
                }
                if ((opacity = FontUtils.getTotalOpacityPosY(bufImg = this.getUnicodeCharImage(ch), bufImg.getHeight() / 2)) == 0) continue;
                this.autoBrightnessUnicode += FontUtils.getEstimatedBrightness(bufImg.getWidth(), opacity);
                this.brightnessBoundaryScaleFactorUnicode += FontUtils.getEstimatedBrightnessBoundaryScaleFactor(bufImg.getWidth(), opacity);
                ++counterUnicode;
            }
            if (counterDefault != 0) {
                this.autoBrightnessDefault /= counterDefault;
                this.brightnessBoundaryScaleFactorDefault /= (float)counterDefault;
            } else {
                this.autoBrightnessDefault = 0;
                this.brightnessBoundaryScaleFactorDefault = 0.0f;
            }
            if (counterUnicode != 0) {
                this.autoBrightnessUnicode /= counterUnicode;
                this.brightnessBoundaryScaleFactorUnicode /= (float)counterUnicode;
            } else {
                this.autoBrightnessUnicode = 0;
                this.brightnessBoundaryScaleFactorUnicode = 0.0f;
            }
            Logger.debug("Auto-brightness for Default font = " + this.autoBrightnessDefault + ", Boundary scaleFactor = " + this.brightnessBoundaryScaleFactorDefault);
            Logger.debug("Auto-brightness for Unicode font = " + this.autoBrightnessUnicode + ", Boundary scaleFactor = " + this.brightnessBoundaryScaleFactorUnicode);
        }
    }

    public boolean setUnicodeFlagHook(boolean unicodeFlag) {
        if (this.disableAllFeatures) {
            return unicodeFlag;
        }
        if (CommonConfig.currentConfig.forceUnicode && mc.func_152349_b()) {
            return true;
        }
        return unicodeFlag;
    }

    public float getCharWidthFloat(char character) {
        switch (character) {
            case '\u00a7': {
                return -1.0f;
            }
            case ' ': {
                return this.getSpaceWidth();
            }
        }
        int i = FontUtils.getDefaultGlyphIndex(character);
        if (character > '\u0000' && i != -1 && !this.fontRenderer.field_78293_l) {
            if (this.changeFont) {
                switch (this.precisionMode) {
                    default: {
                        return this.rasterizer.glyphWidthFloat[character] / 2.0f + 1.0f;
                    }
                    case 1: {
                        return Math.round(this.rasterizer.glyphWidthFloat[character] / 2.0f + 1.0f);
                    }
                    case 2: 
                }
                return this.rasterizer.charWidthInt[i];
            }
            if (CorePlugin.optifineExist && this.optifineCharWidthFloat != null) {
                return this.optifineCharWidthFloat[i];
            }
            return this.fontRenderer.field_78286_d[i];
        }
        if (this.fontRenderer.field_78287_e[character] != 0) {
            if (this.changeFont) {
                switch (this.precisionMode) {
                    default: {
                        return this.rasterizer.glyphWidthFloat[character] / 2.0f + 1.0f;
                    }
                    case 1: {
                        return Math.round(this.rasterizer.glyphWidthFloat[character] / 2.0f + 1.0f);
                    }
                    case 2: 
                }
                int j = this.rasterizer.glyphWidthByte[character] & 0xFF;
                int k = j >>> 4;
                int l = j & 0xF;
                return (++l - k) / 2 + 1;
            }
            int j = this.fontRenderer.field_78287_e[character] & 0xFF;
            int k = j >>> 4;
            int l = j & 0xF;
            ++l;
            if (CorePlugin.optifineExist) {
                return (float)(l - k) / 2.0f + 1.0f;
            }
            return (l - k) / 2 + 1;
        }
        return 0.0f;
    }

    public int renderStringHook(int color) {
        float curAlphaTestRef;
        int alphaTestBoundary;
        int curAlphaTestFunc;
        if (this.fontRenderer == FontRendererHook.mc.field_71466_p && this.precisionMode != 0 && CommonConfig.globalConfig.setMcRendererToHighPRC) {
            this.precisionMode = 0;
        }
        if (this.disableAllFeatures) {
            return color;
        }
        try {
            this.prevBlend = GL11.glIsEnabled((int)3042);
        }
        catch (Exception e) {
            if (CommonConfig.globalConfig.debugLog) {
                e.printStackTrace();
            }
            this.disableAllFeatures(e.getMessage());
            return color;
        }
        if (!this.prevBlend && CommonConfig.globalConfig.workaroundTransparentScoreboard && (curAlphaTestFunc = GlStateManager.func_187397_v((int)3009)) == 516 && color >> 24 > (alphaTestBoundary = (int)((curAlphaTestRef = GL11.glGetFloat((int)3010)) * 255.0f))) {
            color = 0xFF000000 | color;
        }
        return color;
    }

    public void renderStringExitHook(String text) {
        int textLen;
        if (this.disableAllFeatures) {
            return;
        }
        if (text == null) {
            return;
        }
        if (!this.renderStringAtPosWorked && (textLen = this.fontRenderer.func_78256_a(text)) > 0) {
            this.disableAllFeatures("renderStringAtPos method might be replaced.");
        }
    }

    public int getStringWidthFloatHook(String text) {
        if (text == null) {
            return 0;
        }
        float width = 0.0f;
        boolean bold = false;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            float chWidth = this.changeFont && this.precisionMode == 0 ? this.getCharWidthFloat(ch) : (float)this.fontRenderer.func_78263_a(ch);
            if (chWidth < 0.0f && i < text.length() - 1) {
                ch = text.charAt(++i);
                chWidth = 0.0f;
                switch (ch) {
                    case 'L': 
                    case 'l': {
                        bold = true;
                        break;
                    }
                    case 'R': 
                    case 'r': {
                        bold = false;
                        break;
                    }
                }
            }
            width += chWidth;
            if (!bold || !(chWidth > 0.0f)) continue;
            if (CorePlugin.optifineExist) {
                int defaultGlyph = FontUtils.getDefaultGlyphIndex(ch);
                width += defaultGlyph == -1 || this.thinFontFlag ? 0.5f : this.optifineOffsetBold;
                continue;
            }
            width += 1.0f;
        }
        return (int)width;
    }

    public int getCharWidthHook(char ch) {
        return (int)this.getCharWidthFloat(ch);
    }

    public String trimStringToWidthFloatHook(String text, int width, boolean reverse) {
        StringBuilder stringbuilder = new StringBuilder();
        float totalWidth = 0.0f;
        int length = text.length();
        int start = reverse ? length - 1 : 0;
        int step = reverse ? -1 : 1;
        boolean deco = false;
        boolean bold = false;
        for (int cur = start; cur >= 0 && cur < length && (int)totalWidth < width; cur += step) {
            char ch = text.charAt(cur);
            if (deco) {
                deco = false;
                switch (ch) {
                    case 'L': 
                    case 'l': {
                        bold = true;
                        break;
                    }
                    case 'R': 
                    case 'r': {
                        bold = false;
                        break;
                    }
                }
            } else if (ch == '\u00a7') {
                deco = true;
            } else {
                totalWidth = this.changeFont && this.precisionMode == 0 ? (totalWidth += this.getCharWidthFloat(ch)) : (totalWidth += (float)this.fontRenderer.func_78263_a(ch));
                if (bold) {
                    int defaultGlyph;
                    totalWidth = CorePlugin.optifineExist ? (totalWidth += (defaultGlyph = FontUtils.getDefaultGlyphIndex(ch)) == -1 || this.thinFontFlag ? 0.5f : this.optifineOffsetBold) : (totalWidth += 1.0f);
                }
            }
            if ((int)totalWidth > width) break;
            if (reverse) {
                stringbuilder.insert(0, ch);
                continue;
            }
            stringbuilder.append(ch);
        }
        return stringbuilder.toString();
    }

    public int sizeStringToWidthFloatHook(String str, int wrapWidth) {
        int pos;
        int len = str.length();
        float width = 0.0f;
        int breakPos = -1;
        boolean bold = false;
        block9: for (pos = 0; pos < len; ++pos) {
            char ch = str.charAt(pos);
            block0 : switch (ch) {
                case '\n': {
                    breakPos = pos;
                    break block9;
                }
                case '\u00a7': {
                    if (pos >= len - 1) break;
                    char decoCode = str.charAt(++pos);
                    switch (decoCode) {
                        case 'L': 
                        case 'l': {
                            bold = true;
                            break block0;
                        }
                        case 'R': 
                        case 'r': {
                            bold = false;
                            break block0;
                        }
                    }
                    if (!this.isFormatColor(decoCode)) break;
                    bold = false;
                    break;
                }
                case ' ': {
                    breakPos = pos;
                }
                default: {
                    width = this.changeFont && this.precisionMode == 0 ? (width += this.getCharWidthFloat(ch)) : (width += (float)this.fontRenderer.func_78263_a(ch));
                    if (!bold) break;
                    if (CorePlugin.optifineExist) {
                        int defaultGlyph = FontUtils.getDefaultGlyphIndex(ch);
                        width += defaultGlyph == -1 || this.thinFontFlag ? 0.5f : this.optifineOffsetBold;
                        break;
                    }
                    width += 1.0f;
                }
            }
            if ((int)width > wrapWidth) break;
        }
        return pos != len && breakPos != -1 && breakPos < pos ? breakPos : pos;
    }

    public void doDrawEnterHook() {
        if (!this.disableAllFeatures && (this.fontRenderer.field_78299_w || this.fontRenderer.field_78300_v)) {
            this.fontShader.restoreShaderTemporarily();
        }
    }

    public float doDrawHook(float f) {
        if (!this.disableAllFeatures) {
            if (this.fontRenderer.field_78299_w || this.fontRenderer.field_78300_v) {
                this.fontShader.resetShader(this);
            }
            if (this.changeFont) {
                switch (this.precisionMode) {
                    case 0: {
                        return f;
                    }
                    case 1: {
                        return Math.round(f);
                    }
                    case 2: {
                        return (int)f;
                    }
                }
            }
        }
        if (CorePlugin.optifineExist) {
            return f;
        }
        return (int)f;
    }

    private boolean isFormatColor(char colorChar) {
        return colorChar >= '0' && colorChar <= '9' || colorChar >= 'a' && colorChar <= 'f' || colorChar >= 'A' && colorChar <= 'F';
    }

    public void reloadResources() {
        boolean registered = false;
        for (IResourceManagerReloadListener listener : ((SimpleReloadableResourceManager)FontRendererHook.mc.func_110442_L()).field_110546_b) {
            if (listener != this.fontRenderer) continue;
            registered = true;
        }
        if (registered) {
            this.fontRenderer.func_110549_a(mc.func_110442_L());
            Logger.debug("onResourceManagerReload was executed: " + this.fontRenderer.toString());
        } else {
            try {
                this.fontRenderer.func_111272_d();
            }
            catch (Exception e) {
                Logger.info("Exception from readFontTexture(). The font texture file may not exist.");
            }
            try {
                this.fontRenderer.func_98306_d();
            }
            catch (Exception e) {
                Logger.info("Exception from readGlyphSizes(). The glyph_sizes.bin may not exist.");
            }
            Logger.debug("onResourceManagerReload is not registered: " + this.fontRenderer.toString());
        }
    }

    private void disableAllFeatures(String reason) {
        Logger.info("Disabled smoothfont functions.(reason:" + reason + "):" + this.fontRenderer.toString());
        this.disableAllFeatures = true;
        this.reasonForDisable = reason;
        this.reloadResources();
    }

    private BufferedImage getDefaultCharImage(char ch) {
        int id = FontUtils.getDefaultGlyphIndex(ch);
        if (id == -1) {
            return null;
        }
        BufferedImage fontImg = FontUtils.getMCFontImage(this.fontRenderer.field_111273_g);
        int chSize = fontImg.getWidth() / 16;
        int posX = id % 16 * chSize;
        int posY = (id & 0xFF) / 16 * chSize;
        BufferedImage chImg = fontImg.getSubimage(posX, posY, chSize, chSize);
        return chImg;
    }

    private BufferedImage getUnicodeCharImage(char ch) {
        int page = ch / 256;
        BufferedImage fontImg = FontUtils.getMCFontImage(this.getUnicodePageLocation(page));
        int chSize = fontImg.getWidth() / 16;
        int posX = ch % 16 * chSize;
        int posY = (ch & 0xFF) / 16 * chSize;
        BufferedImage chImg = fontImg.getSubimage(posX, posY, chSize, chSize);
        return chImg;
    }

    public void updateHookFlags() {
        this.enableHookRenderChar = this.changeFont;
        this.enableHookGetStringWidth = this.changeFont || !CorePlugin.optifineExist;
        this.enableHookGetCharWidth = this.changeFont;
        this.enableHookTrimStringToWidth = this.changeFont || !CorePlugin.optifineExist;
        this.enableHookSizeStringToWidth = this.changeFont || !CorePlugin.optifineExist;
    }

    public static void updateHookFlagsAll() {
        FontRendererHookList hookList = new FontRendererHookList(){

            @Override
            public boolean process(FontRendererHook frh) {
                frh.updateHookFlags();
                return true;
            }
        };
        hookList.executeAll();
    }

    public void updateChangeFontFlag() {
        switch (CommonConfig.currentConfig.fontTargetToReplace) {
            default: {
                if (this.fontRenderer.field_111273_g != null && "minecraft".equals(this.fontRenderer.field_111273_g.func_110624_b()) && ("textures/font/ascii.png".equals(this.fontRenderer.field_111273_g.func_110623_a()) || "mcpatcher/font/ascii.png".equals(this.fontRenderer.field_111273_g.func_110623_a()))) {
                    this.changeFont = CommonConfig.currentConfig.useOSFont;
                    break;
                }
                this.changeFont = false;
                break;
            }
            case 1: {
                this.changeFont = CommonConfig.currentConfig.useOSFont;
            }
        }
    }

    public static void updateChangeFontFlagAll() {
        FontRendererHookList hookList = new FontRendererHookList(){

            @Override
            public boolean process(FontRendererHook frh) {
                frh.updateChangeFontFlag();
                return true;
            }
        };
        hookList.executeAll();
    }

    public static void clearChangeFontFlagAll() {
        FontRendererHookList hookList = new FontRendererHookList(){

            @Override
            public boolean process(FontRendererHook frh) {
                frh.changeFont = false;
                return true;
            }
        };
        hookList.executeAll();
    }

    public float getSpaceWidth() {
        if (this.changeFont) {
            if (CommonConfig.currentConfig.fontSpaceWidth == 0) {
                switch (this.precisionMode) {
                    case 0: {
                        return this.rasterizer.glyphWidthFloat[32] / 2.0f + 1.0f;
                    }
                    case 1: 
                    case 2: {
                        return MathHelper.ceil(this.rasterizer.glyphWidthFloat[32] / 2.0f + 1.0f);
                    }
                }
            } else {
                return CommonConfig.currentConfig.fontSpaceWidth;
            }
        }
        if (CorePlugin.optifineExist && !this.fontRenderer.field_78293_l) {
            return this.optifineCharWidthFloat != null ? this.optifineCharWidthFloat[32] : 4.0f;
        }
        return 4.0f;
    }
}

