/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont;

import bre.smoothfont.FontRendererHook;
import bre.smoothfont.FontRendererHookList;
import bre.smoothfont.FontTexture;
import bre.smoothfont.FontUtils;
import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.util.Logger;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class FontTextureManager
implements IResourceManagerReloadListener {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static FontTextureManager INSTANCE = new FontTextureManager();
    private final Map<ResourceLocation, ITextureObject> mapTextureObjects = Maps.newHashMap();
    private IResourceManager theResourceManager = mc.func_110442_L();
    public static final int MAX_PAGES = 257;
    public static final int DEFAULT_FONT = 256;
    public static boolean supportAnisotropicFilter = false;

    public FontTextureManager() {
        ((IReloadableResourceManager)mc.func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
    }

    public static FontTextureManager getInstance() {
        return INSTANCE;
    }

    public void bindTexture(ResourceLocation resource, int page) {
        Object itextureobject = this.mapTextureObjects.get(resource);
        if (itextureobject == null) {
            itextureobject = new FontTexture(resource, page);
            this.loadTexture(resource, (ITextureObject)itextureobject);
        }
        GlStateManager.func_179144_i((int)itextureobject.func_110552_b());
    }

    public boolean loadTexture(ResourceLocation textureLocation, ITextureObject textureObj) {
        boolean flag = true;
        try {
            textureObj.func_110551_a(this.theResourceManager);
        }
        catch (Exception e) {
            Logger.error("Failed to load texture: " + textureLocation);
            e.printStackTrace();
            textureObj = TextureUtil.field_111001_a;
            this.mapTextureObjects.put(textureLocation, textureObj);
            flag = false;
        }
        this.mapTextureObjects.put(textureLocation, textureObj);
        return flag;
    }

    public void func_110549_a(IResourceManager iresourceManager) {
        this.clearMapTextureObjects();
        FontRendererHookList hookList = new FontRendererHookList(){

            @Override
            public boolean process(FontRendererHook frh) {
                frh.reloadResources();
                return true;
            }
        };
        hookList.executeAll();
    }

    public void clearMapTextureObjects() {
        ArrayList<ITextureObject> texObjList = new ArrayList<ITextureObject>(this.mapTextureObjects.values());
        for (ITextureObject texObj : texObjList) {
            ((AbstractTexture)texObj).func_147631_c();
        }
        this.mapTextureObjects.clear();
    }

    public void setUnicodeFlagAll() {
        FontRendererHookList hookList = new FontRendererHookList(){

            @Override
            public boolean process(FontRendererHook frh) {
                FontRendererHook.setUnicodeFlagSuitably(frh);
                return true;
            }
        };
        hookList.executeAll();
    }

    public int getUnicodeFontRes(boolean osFont) {
        if (osFont) {
            return FontUtils.getFontRes(CommonConfig.currentConfig.fontResIndex);
        }
        int texSize = FontTextureManager.getInstance().getGlyphRes(FontRendererHook.getMcDefaultFontRendererHook().getUnicodePageLocation(0));
        return texSize == 0 ? 16 : texSize;
    }

    public int getDefaultFontRes(ResourceLocation resourceLoc, boolean osFont) {
        if (osFont) {
            return FontUtils.getFontRes(CommonConfig.currentConfig.fontResIndex);
        }
        int texSize = FontTextureManager.getInstance().getGlyphRes(resourceLoc);
        return texSize == 0 ? 8 : texSize;
    }

    public int getGlyphRes(ResourceLocation resLoc) {
        FontTexture texObj = (FontTexture)this.mapTextureObjects.get(resLoc);
        return texObj == null ? 0 : texObj.fontRes;
    }

    public float getBorderWidthRate(ResourceLocation resLoc) {
        FontTexture texObj = (FontTexture)this.mapTextureObjects.get(resLoc);
        return texObj == null ? 0.0f : texObj.borderWidthRate;
    }

    public float getBlankSpaceRate(ResourceLocation resLoc) {
        FontTexture texObj = (FontTexture)this.mapTextureObjects.get(resLoc);
        return texObj == null ? 0.0f : texObj.blankSpaceRate;
    }

    private int getTexFilterSetting(ResourceLocation resLoc) {
        FontTexture texObj = (FontTexture)this.mapTextureObjects.get(resLoc);
        return texObj == null ? 0 : texObj.texFilterSetting;
    }

    private void setTexFilterSetting(ResourceLocation resLoc, int id) {
        FontTexture texObj = (FontTexture)this.mapTextureObjects.get(resLoc);
        if (texObj != null) {
            texObj.texFilterSetting = id;
        } else {
            Logger.error("setTexFilterSetting: textureObject is null.");
        }
    }

    private boolean getAnisotropicFilterSetting(ResourceLocation resLoc) {
        FontTexture texObj = (FontTexture)this.mapTextureObjects.get(resLoc);
        return texObj != null && texObj.anisotropicFilterSetting;
    }

    private void setAnisotropicFilterSetting(ResourceLocation resLoc, boolean flag) {
        FontTexture texObj = (FontTexture)this.mapTextureObjects.get(resLoc);
        if (texObj != null) {
            texObj.anisotropicFilterSetting = flag;
        } else {
            Logger.error("setTexFilterSetting: textureObject is null.");
        }
    }

    public void setTexParams(ResourceLocation resLoc, int filterId) {
        if (this.getTexFilterSetting(resLoc) != filterId) {
            this.setTexFilterSetting(resLoc, filterId);
            if (CommonConfig.currentConfig.allowNPOTTexture) {
                GlStateManager.func_187421_b((int)3553, (int)10242, (int)33071);
                GlStateManager.func_187421_b((int)3553, (int)10243, (int)33071);
            }
            if (CommonConfig.currentConfig.enableInterpolation) {
                if (CommonConfig.currentConfig.enableMipmap) {
                    GlStateManager.func_187421_b((int)3553, (int)10241, (int)9987);
                } else {
                    GlStateManager.func_187421_b((int)3553, (int)10241, (int)9729);
                }
                GlStateManager.func_187421_b((int)3553, (int)10240, (int)9729);
            } else {
                if (CommonConfig.currentConfig.enableMipmap) {
                    GlStateManager.func_187421_b((int)3553, (int)10241, (int)9986);
                } else {
                    GlStateManager.func_187421_b((int)3553, (int)10241, (int)9728);
                }
                GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
            }
        }
    }

    public void setTexParamsNearest(ResourceLocation resLoc) {
        if (this.getTexFilterSetting(resLoc) != 0) {
            this.setTexFilterSetting(resLoc, 0);
            if (CommonConfig.currentConfig.allowNPOTTexture) {
                GlStateManager.func_187421_b((int)3553, (int)10242, (int)33071);
                GlStateManager.func_187421_b((int)3553, (int)10243, (int)33071);
            }
            GlStateManager.func_187421_b((int)3553, (int)10241, (int)9728);
            GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
        }
    }

    public void setAnisotropicFilter(ResourceLocation resLoc, boolean enable) {
        if (supportAnisotropicFilter) {
            if (enable) {
                if (!this.getAnisotropicFilterSetting(resLoc)) {
                    float maxAnisotropic = GL11.glGetFloat((int)34047);
                    GlStateManager.func_187403_b((int)3553, (int)34046, (float)maxAnisotropic);
                    this.setAnisotropicFilterSetting(resLoc, true);
                }
            } else if (this.getAnisotropicFilterSetting(resLoc)) {
                GlStateManager.func_187403_b((int)3553, (int)34046, (float)1.0f);
                this.setAnisotropicFilterSetting(resLoc, false);
            }
        }
    }
}

