/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont;

import bre.smoothfont.FontRendererHook;
import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.gui.GuiFontSelection;
import bre.smoothfont.util.Logger;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.Language;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL11;

public class FontUtils {
    private static FontUtils DUMMY_INSTANCE = new FontUtils();
    private static Minecraft mc;
    private static final String defaultCharList = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000";
    public static char[] asciiSheetChars;
    private static Map<Character, Integer> defaultGlyphIdMap;

    public FontUtils() {
        FontUtils.initDefaultGlyphIdMap();
        asciiSheetChars = defaultCharList.toCharArray();
        mc = Minecraft.func_71410_x();
    }

    private static void initDefaultGlyphIdMap() {
        defaultGlyphIdMap = new HashMap<Character, Integer>();
        StringBuffer sb = new StringBuffer(defaultCharList);
        String chListReversed = sb.reverse().toString();
        int id = chListReversed.length() - 1;
        for (char ch : chListReversed.toCharArray()) {
            defaultGlyphIdMap.put(Character.valueOf(ch), id);
            --id;
        }
    }

    public static int getDefaultGlyphIndex(char character) {
        Integer id = defaultGlyphIdMap.get(Character.valueOf(character));
        return id == null ? -1 : id;
    }

    public static char getDefaultGlyphChar(int index) {
        return defaultCharList.charAt(index);
    }

    public static List<String> getFontList() {
        Font[] fonts;
        ArrayList<String> fontNameList = new ArrayList<String>();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (Font font : fonts = ge.getAllFonts()) {
            fontNameList.add(font.getName());
        }
        return fontNameList;
    }

    public static List<String> getFontFamilyList() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Language lang = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        String[] families = ge.getAvailableFontFamilyNames(lang.getJavaLocale());
        List<String> fontFamilyList = Arrays.asList(families);
        return fontFamilyList;
    }

    public static int getFontRes(int val) {
        switch (val) {
            case 0: {
                return 8;
            }
            case 1: {
                return 10;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 16;
            }
            case 4: {
                return 24;
            }
            case 5: {
                return 32;
            }
            case 6: {
                return 48;
            }
            case 7: {
                return 64;
            }
        }
        return 16;
    }

    public static int getBorderWidth(int texelSize, boolean osFont) {
        int border;
        int fontSizeAdjustValue = 0;
        int fontGapAdjustValue = 0;
        if (osFont) {
            if (CommonConfig.currentConfig.fontSizeAdjustment > 0) {
                fontSizeAdjustValue = MathHelper.func_76123_f((float)((float)(texelSize * CommonConfig.currentConfig.fontSizeAdjustment) * 0.05f));
            }
            if (CommonConfig.currentConfig.fontGap < 0) {
                fontGapAdjustValue = MathHelper.func_76123_f((float)((float)(Math.abs(CommonConfig.currentConfig.fontGap) * texelSize) / 16.0f / 2.0f));
            }
            border = Math.max(fontSizeAdjustValue, fontGapAdjustValue);
            float configMargin = Math.max(CommonConfig.currentConfig.horizontalMargin, CommonConfig.currentConfig.verticalMargin);
            float marginValue = Math.max(configMargin, 1.0f) * (float)texelSize / 16.0f;
            border += texelSize < 16 ? MathHelper.func_76123_f((float)marginValue) : (int)marginValue;
        } else {
            border = texelSize < 16 ? 1 : (int)((float)texelSize / 16.0f);
        }
        return ++border * 2;
    }

    public static int nearPOT(int value) {
        if (value < 0) {
            return 0;
        }
        int p = MathHelper.func_76123_f((float)FontUtils.log2(value));
        return (int)Math.pow(2.0, p);
    }

    public static boolean isPOT(int value) {
        return (value & value - 1) == 0;
    }

    private static float log2(int value) {
        return (float)(Math.log(value) / Math.log(2.0));
    }

    public static int getMaxFontSizeIndex() {
        int id;
        int maxTextureSize = FontUtils.getMaxTextureSize();
        for (id = 7; id >= 1 && FontUtils.calcTextureSize(FontUtils.getFontRes(id)) > maxTextureSize; --id) {
        }
        return id;
    }

    private static int getMaxTextureSize() {
        return GL11.glGetInteger((int)3379);
    }

    private static int calcTextureSize(int fontSize) {
        return (fontSize + FontUtils.getBorderWidth(fontSize, true)) * 16;
    }

    public static void showFontImage(BufferedImage img, int elementSize, int borderSize, boolean separation) {
        int pages = separation ? 3 : 1;
        BufferedImage newImg = new BufferedImage(img.getWidth() * pages, img.getHeight(), 6);
        Graphics2D g2 = newImg.createGraphics();
        int originMargin = borderSize / 2;
        g2.setBackground(Color.BLACK);
        g2.clearRect(0, 0, img.getWidth() * pages, img.getHeight());
        if (elementSize != 0 || borderSize != 0) {
            g2.setBackground(Color.BLUE);
            g2.clearRect(0, 0, originMargin, img.getHeight());
            g2.clearRect(0, 0, img.getWidth(), originMargin);
            for (int i = elementSize; i < img.getWidth(); i += elementSize + borderSize) {
                g2.clearRect(i + originMargin, 0, borderSize, img.getHeight());
                g2.clearRect(0, i + originMargin, img.getWidth(), borderSize);
            }
        }
        g2.drawImage((Image)img, 0, 0, null);
        if (separation) {
            int y;
            int x;
            for (x = 0; x < img.getWidth(); ++x) {
                for (y = 0; y < img.getHeight(); ++y) {
                    int rgb = img.getRGB(x, y) & 0xFFFFFF;
                    if (rgb == 0) continue;
                    g2.setColor(new Color(rgb));
                    g2.drawLine(img.getWidth() + x, y, img.getWidth() + x, y);
                }
            }
            for (x = 0; x < img.getWidth(); ++x) {
                for (y = 0; y < img.getHeight(); ++y) {
                    int alpha = img.getRGB(x, y) >>> 24;
                    if (alpha == 0) continue;
                    g2.setColor(new Color(alpha));
                    g2.drawLine(img.getWidth() * 2 + x, y, img.getWidth() * 2 + x, y);
                }
            }
        }
        g2.dispose();
        ImageIcon icon = new ImageIcon(newImg);
        JOptionPane.showMessageDialog(null, "type=" + img.getType(), "Unicode\u30c6\u30af\u30b9\u30c1\u30e3", -1, icon);
    }

    public static BufferedImage expandImage(BufferedImage origImg) {
        BufferedImage newImage;
        int scaleFactor = 2;
        int width = origImg.getWidth();
        int height = origImg.getHeight();
        int newWidth = width * scaleFactor;
        int newHeight = height * scaleFactor;
        if (origImg.getColorModel() instanceof IndexColorModel) {
            if (origImg.getType() == 12) {
                byte[] r = new byte[]{-1, -1};
                byte[] g = new byte[]{-1, -1};
                byte[] b = new byte[]{-1, -1};
                byte[] a = new byte[]{0, -1};
                IndexColorModel icm = new IndexColorModel(1, 2, r, g, b, a);
                newImage = new BufferedImage(newWidth, newHeight, origImg.getType(), icm);
            } else {
                newImage = new BufferedImage(newWidth, newHeight, origImg.getType(), (IndexColorModel)origImg.getColorModel());
            }
        } else {
            newImage = new BufferedImage(newWidth, newHeight, origImg.getType());
        }
        for (int y = 0; y < height; ++y) {
            int ny = y * 2;
            for (int x = 0; x < width; ++x) {
                int argb = origImg.getRGB(x, y);
                int nx = x * 2;
                newImage.setRGB(nx, ny, argb);
                newImage.setRGB(nx + 1, ny, argb);
                newImage.setRGB(nx, ny + 1, argb);
                newImage.setRGB(nx + 1, ny + 1, argb);
            }
        }
        return newImage;
    }

    public static BufferedImage resizeImageABGR(BufferedImage origImg, float scaleFactor, boolean lerp) {
        int width = origImg.getWidth();
        int height = origImg.getHeight();
        int newWidth = (int)((float)width * scaleFactor);
        int newHeight = (int)((float)height * scaleFactor);
        BufferedImage newImage = new BufferedImage(newWidth, newHeight, 6);
        Graphics2D g2 = newImage.createGraphics();
        FontUtils.clearGraphics2D(g2, 0, 0, newWidth, newHeight);
        if (lerp) {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
        g2.drawImage(origImg, 0, 0, newWidth, newHeight, 0, 0, width, height, null);
        g2.dispose();
        return newImage;
    }

    public static BufferedImage expandFrame(BufferedImage origImg, int newWidth, int newHeight) {
        if (origImg.getWidth() >= newWidth || origImg.getHeight() >= newHeight) {
            return origImg;
        }
        BufferedImage newImg = CommonConfig.currentConfig.enablePremultipliedAlpha ? new BufferedImage(newWidth, newHeight, 7) : new BufferedImage(newWidth, newHeight, 6);
        Graphics2D g2 = newImg.createGraphics();
        FontUtils.clearGraphics2D(g2, 0, 0, newImg.getWidth(), newImg.getHeight());
        g2.drawImage((Image)origImg, 0, 0, null);
        g2.dispose();
        return newImg;
    }

    public static String getCurrentLangStr() {
        Language lang = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        return lang.toString();
    }

    public static BufferedImage convertToPremultipliedAlpha(BufferedImage origImg) {
        BufferedImage newImg = new BufferedImage(origImg.getWidth(), origImg.getHeight(), 7);
        for (int x = 0; x < origImg.getWidth(); ++x) {
            for (int y = 0; y < origImg.getHeight(); ++y) {
                int argb = origImg.getRGB(x, y);
                int alpha = argb >>> 24;
                int red = ((argb & 0xFF0000) >>> 16) * alpha / 255;
                int green = ((argb & 0xFF00) >>> 8) * alpha / 255;
                int blue = (argb & 0xFF) * alpha / 255;
                int premultifiedAlpha = (alpha << 24) + (red << 16) + (green << 8) + blue;
                newImg.setRGB(x, y, premultifiedAlpha);
            }
        }
        return newImg;
    }

    public static BufferedImage fillColorChannel(BufferedImage fontImage, int rgb) {
        for (int x = 0; x < fontImage.getWidth(); ++x) {
            for (int y = 0; y < fontImage.getHeight(); ++y) {
                int argb = fontImage.getRGB(x, y);
                argb = argb & 0xFF000000 | rgb;
                fontImage.setRGB(x, y, argb);
            }
        }
        return fontImage;
    }

    public static void clearGraphics2D(Graphics2D g2, int x1, int y1, int x2, int y2) {
        if (CommonConfig.currentConfig.enablePremultipliedAlpha) {
            g2.setBackground(new Color(0, 0, 0, 0));
        } else {
            g2.setBackground(new Color(255, 255, 255, 0));
        }
        g2.clearRect(x1, y1, x2, y2);
    }

    public static void clearGraphics2DGray(Graphics2D g2, int x1, int y1, int x2, int y2) {
        g2.setBackground(Color.BLACK);
        g2.clearRect(x1, y1, x2, y2);
    }

    public static float getOpacityTotal(BufferedImage image) {
        int opacity = 0;
        int totalPixel = 0;
        int width = image.getWidth();
        int height = image.getHeight();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int alpha = image.getRGB(x, y) >>> 24;
                opacity += alpha;
                ++totalPixel;
            }
        }
        return (float)opacity / (float)totalPixel;
    }

    public static int getTotalOpacityPosY(BufferedImage image, int posY) {
        int opacity = 0;
        int width = image.getWidth();
        for (int x = 0; x < width; ++x) {
            int alpha = image.getRGB(x, posY) >>> 24;
            opacity += alpha;
        }
        return opacity;
    }

    public static int getTotalOpacityPosYGray(BufferedImage image, int posY) {
        int opacity = 0;
        int width = image.getWidth();
        for (int x = 0; x < width; ++x) {
            int alpha = image.getRGB(x, posY) & 0xFF;
            opacity += alpha;
        }
        return opacity;
    }

    public static int getEstimatedBrightness(int fontRes, int opacity) {
        int normalizedOpacity = opacity / fontRes;
        normalizedOpacity = Math.max(1, normalizedOpacity);
        int estimatedBrightnessValue = 60 / normalizedOpacity;
        Logger.debug("Estimated opacity = " + normalizedOpacity + ", Calculated brightness = " + estimatedBrightnessValue);
        return estimatedBrightnessValue;
    }

    public static float getEstimatedBrightnessBoundaryScaleFactor(int fontRes, int opacity) {
        float factor = 255.0f / (float)opacity * (float)fontRes / 4.0f;
        return factor;
    }

    public static float getShadowAdjustVal(int shadowLength) {
        return (float)(shadowLength - 5) / 10.0f;
    }

    public static int getTexFilterSettingId() {
        return (CommonConfig.currentConfig.enableInterpolation ? 2 : 0) + (CommonConfig.currentConfig.enableMipmap ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getMCFontImage(ResourceLocation resourceLoc) {
        IResourceManager iRegMgr = Minecraft.func_71410_x().func_110442_L();
        IResource iresource = null;
        BufferedImage bufImage = null;
        try {
            iresource = iRegMgr.func_110536_a(resourceLoc);
            bufImage = TextureUtil.func_177053_a((InputStream)iresource.func_110527_b());
        }
        catch (Exception e) {
            Logger.error("Failed to get font resource.");
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((Closeable)iresource);
        }
        return bufImage;
    }

    public static void applyAllConfigParameters(boolean changeAltLERP) {
        GuiFontSelection.reloadFonts();
        FontRendererHook.shadowAdjustVal = FontUtils.getShadowAdjustVal(CommonConfig.currentConfig.shadowLength);
        FontRendererHook.texFilterSettingId = FontUtils.getTexFilterSettingId();
        if (changeAltLERP) {
            mc.func_110436_a();
        }
    }

    public static boolean isFontAvailable(Font font) {
        String familyName = font.getFamily(Locale.ENGLISH);
        String settingName = font.getName();
        String[] settingNameSplitted = settingName.split("\\.");
        return !familyName.equals("Dialog") || settingNameSplitted[0].equals("Dialog");
    }

    @Deprecated
    public static BufferedImage convertGrayToABGR(BufferedImage origImg) {
        int width = origImg.getWidth();
        int height = origImg.getHeight();
        BufferedImage newImg = new BufferedImage(width, height, 6);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int argb = origImg.getRGB(x, y) << 24 | 0xFFFFFF;
                newImg.setRGB(x, y, argb);
            }
        }
        return newImg;
    }

    @Deprecated
    public static BufferedImage convertIntArrayGrayToABGR(BufferedImage origImg) {
        int width = origImg.getWidth();
        int height = origImg.getHeight();
        BufferedImage newImg = new BufferedImage(width, height, 6);
        int[] pixels = origImg.getRGB(0, 0, width, height, null, 0, width);
        for (int offset = 0; offset < height * width; offset += width) {
            for (int x = 0; x < width; ++x) {
                int i = offset + x;
                pixels[i] = pixels[i] << 24 | 0xFFFFFF;
            }
        }
        newImg.setRGB(0, 0, width, height, pixels, 0, width);
        return newImg;
    }

    public static BufferedImage convertDataBufferGrayToABGR(BufferedImage origImg) {
        int width = origImg.getWidth();
        int height = origImg.getHeight();
        BufferedImage newImg = new BufferedImage(width, height, 6);
        DataBuffer intBuf = origImg.getRaster().getDataBuffer();
        int[] pixels = new int[intBuf.getSize()];
        for (int i = 0; i < intBuf.getSize(); ++i) {
            pixels[i] = intBuf.getElem(i) << 24 | 0xFFFFFF;
        }
        int[] bandMasks = new int[]{0xFF0000, 65280, 255, -16777216};
        WritableRaster writableRaster = Raster.createPackedRaster(new DataBufferInt(pixels, width * height), width, height, width, bandMasks, null);
        newImg.setData(writableRaster);
        return newImg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static byte[] getPngBytesFromImage(BufferedImage image) {
        String[] formats = ImageIO.getWriterFormatNames();
        byte[] bytes = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bufout = new BufferedOutputStream(out);
        image.flush();
        try {
            ImageIO.write((RenderedImage)image, "png", bufout);
            bufout.flush();
            bufout.close();
            bytes = out.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static BufferedImage getImageFromBytes(byte[] bytes) {
        BufferedImage image = null;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            image = ImageIO.read(in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return image;
    }

    public static byte[] getBytesFromImage(BufferedImage image) {
        byte[] byteArray = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        byte[] result = new byte[byteArray.length];
        System.arraycopy(byteArray, 0, result, 0, result.length);
        return result;
    }

    public static BufferedImage getABGRImageFromABGRBytes(byte[] bytes) {
        int width = (int)MathHelper.func_76129_c((float)(bytes.length / 4));
        BufferedImage image = new BufferedImage(width, width, 6);
        byte[] byteArray = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        System.arraycopy(bytes, 0, byteArray, 0, byteArray.length);
        return image;
    }

    public static BufferedImage getABGRImageFromGrayBytes(byte[] bytes) {
        int width = (int)MathHelper.func_76129_c((float)bytes.length);
        BufferedImage image = new BufferedImage(width, width, 6);
        byte[] byteArray = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        Arrays.fill(byteArray, (byte)-1);
        for (int i = 0; i < bytes.length; ++i) {
            byteArray[i * 4] = bytes[i];
        }
        return image;
    }

    @Deprecated
    public static byte[] getBytesFromGrayImage(BufferedImage image) {
        DataBuffer dataBuf = image.getRaster().getDataBuffer();
        byte[] result = new byte[dataBuf.getSize()];
        for (int i = 0; i < dataBuf.getSize(); ++i) {
            result[i] = (byte)dataBuf.getElem(i);
        }
        return result;
    }

    @Deprecated
    public static BufferedImage getABGRImageFromGrayBytes2(byte[] bytes) {
        int width = (int)MathHelper.func_76129_c((float)bytes.length);
        int[] pixels = new int[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            pixels[i] = bytes[i] << 24 | 0xFFFFFF;
        }
        int[] bandMasks = new int[]{0xFF0000, 65280, 255, -16777216};
        WritableRaster writableRaster = Raster.createPackedRaster(new DataBufferInt(pixels, width * width), width, width, width, bandMasks, null);
        BufferedImage newImg = new BufferedImage(width, width, 6);
        newImg.setData(writableRaster);
        return newImg;
    }

    public static byte[] gzipBytes(byte[] bytes) {
        byte[] result;
        try {
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            GZIPOutputStream gzipOut = new GZIPOutputStream(byteArrayOut);
            gzipOut.write(bytes);
            gzipOut.close();
            byteArrayOut.close();
            result = byteArrayOut.toByteArray();
        }
        catch (Exception e) {
            Logger.error("Error during compressing byte array.");
            e.printStackTrace();
            result = bytes;
        }
        return result;
    }

    public static byte[] gunzipBytes(byte[] gzipBytes) {
        byte[] result;
        try {
            int length;
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            ByteArrayInputStream byteArrayIn = new ByteArrayInputStream(gzipBytes);
            GZIPInputStream gzipIn = new GZIPInputStream(byteArrayIn);
            byte[] buf = new byte[4096];
            while ((length = gzipIn.read(buf)) > 0) {
                byteArrayOut.write(buf, 0, length);
            }
            gzipIn.close();
            byteArrayIn.close();
            byteArrayOut.close();
            result = byteArrayOut.toByteArray();
        }
        catch (Exception e) {
            Logger.error("Error during uncompressing byte array.");
            e.printStackTrace();
            result = gzipBytes;
        }
        return result;
    }
}

