/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont;

import bre.smoothfont.FontRendererHook;
import bre.smoothfont.util.Logger;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class FontRendererHookList {
    private static List<WeakReference<FontRendererHook>> fontRendererHookList = new ArrayList<WeakReference<FontRendererHook>>();

    public boolean process(FontRendererHook frh) {
        return true;
    }

    public synchronized void executeAll() {
        ArrayList<WeakReference<FontRendererHook>> removeList = new ArrayList<WeakReference<FontRendererHook>>();
        int i = 0;
        for (WeakReference<FontRendererHook> weakRef : fontRendererHookList) {
            FontRendererHook frh = (FontRendererHook)weakRef.get();
            if (frh != null) {
                boolean ret = this.process(frh);
                if (!ret) {
                    break;
                }
            } else {
                removeList.add(weakRef);
                Logger.debug("FontRendererHook-" + i + " may had been already garbage-collected.");
            }
            ++i;
        }
        fontRendererHookList.removeAll(removeList);
    }

    public static synchronized void add(FontRendererHook frh) {
        WeakReference<FontRendererHook> weakRef = new WeakReference<FontRendererHook>(frh);
        fontRendererHookList.add(weakRef);
    }

    public static synchronized void remove(FontRendererHook target) {
        ArrayList<WeakReference<FontRendererHook>> removeList = new ArrayList<WeakReference<FontRendererHook>>();
        for (WeakReference<FontRendererHook> weakRef : fontRendererHookList) {
            FontRendererHook frh = (FontRendererHook)weakRef.get();
            if (frh != target) continue;
            removeList.add(weakRef);
            Logger.debug("FontRendererHook has been removed.(" + frh.fontRenderer.toString() + ")");
        }
        if (removeList.isEmpty()) {
            Logger.warn("Not found the FontRendererHook to remove from the list.(" + target.fontRenderer.toString() + ")");
        }
        fontRendererHookList.removeAll(removeList);
    }

    public static synchronized void refresh() {
        ArrayList<WeakReference<FontRendererHook>> removeList = new ArrayList<WeakReference<FontRendererHook>>();
        int i = 0;
        for (WeakReference<FontRendererHook> weakRef : fontRendererHookList) {
            FontRendererHook frh = (FontRendererHook)weakRef.get();
            if (frh == null) {
                removeList.add(weakRef);
                Logger.debug("FontRendererHook-" + i + " may had been already garbage-collected.");
            }
            ++i;
        }
        fontRendererHookList.removeAll(removeList);
    }

    public static synchronized int size() {
        FontRendererHookList.refresh();
        return fontRendererHookList.size();
    }

    public static synchronized FontRendererHook get(int id) {
        FontRendererHookList.refresh();
        FontRendererHook frh = null;
        WeakReference<FontRendererHook> weakRef = fontRendererHookList.get(id);
        if (weakRef != null) {
            frh = (FontRendererHook)weakRef.get();
        }
        return frh;
    }

    public static synchronized FontRendererHook getFontRendererHook(FontRenderer renderer) {
        FontRendererHookList.refresh();
        FontRendererHook frh = null;
        for (WeakReference<FontRendererHook> weakRef : fontRendererHookList) {
            frh = (FontRendererHook)weakRef.get();
            if (frh == null || frh.fontRenderer != Minecraft.func_71410_x().field_71466_p) continue;
            return frh;
        }
        return null;
    }
}

