/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont.gui;

import bre.smoothfont.FontRasterizer;
import bre.smoothfont.FontRendererHook;
import bre.smoothfont.FontTextureManager;
import bre.smoothfont.FontUtils;
import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.gui.GuiCommon;
import bre.smoothfont.gui.GuiSliderEx;
import bre.smoothfont.gui.GuiSliderFontRes;
import bre.smoothfont.gui.GuiSliderFontSize;
import bre.smoothfont.gui.GuiSliderZero;
import bre.smoothfont.gui.GuiTextFieldWithLabel;
import cpw.mods.fml.client.config.GuiSlider;
import cpw.mods.fml.client.config.HoverChecker;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;

@SideOnly(value=Side.CLIENT)
public class GuiFontSelection
extends GuiScreen {
    protected GuiScreen parentScreen;
    private FontList guiList;
    private GuiButton antiAliasBtn;
    private GuiButton doubleRenderBtn;
    private GuiButton detailListBtn;
    private GuiButton applyBtn;
    private GuiButton finishBtn;
    private GuiSliderFontRes fontResSld;
    private GuiButton autoSizingBtn;
    private GuiSliderFontSize fontSizeSld;
    private GuiSlider fontGapSld;
    private GuiSliderEx spaceWidthSld;
    private GuiButton alignBaselineBtn;
    private GuiButton targetToReplaceBtn;
    private GuiTextField fontFilterField;
    private GuiTextField sizeAdjustField;
    private final int DX = 160;
    private final int BTN_HEIGHT = 20;
    private final int BTN_VGAP = 2;
    private final int BTN_HGAP = 4;
    private final int BTN_WIDTH2 = 158;
    private final int BTN_WIDTH3 = 104;
    private final int BTN_WIDTH6 = 50;
    private final int SLOT_HEIGHT = 16;
    private final int TOP_MARGIN = 2;
    private final int BOTTOM_MARGIN = 2;
    private String filterText = "";
    private int tmpConfigAntiAlias;
    private int tmpConfigDoubleRendering;
    private int tmpConfigFontResIndex;
    private int tmpConfigFontGap;
    private int tmpConfigFontSizeIndex;
    private boolean tmpConfigFontAutoSizing;
    private String tmpConfigFontName;
    private String tmpConfigSecondaryFontName;
    private String tmpConfigSizeAdjustChars;
    private HoverChecker[] hoverChecker = new HoverChecker[GuiPart.values().length];
    private static final int tooltipTimer = 500;
    private int prevX;
    private int prevY;
    private int BTN_ROW1;
    private int BTN_ROW2;
    private int BTN_ROW3;
    private int BTN_ROW4;

    public GuiFontSelection(GuiScreen parent) {
        this.parentScreen = parent;
        this.tmpConfigAntiAlias = CommonConfig.currentConfig.fontAntiAlias;
        this.tmpConfigDoubleRendering = CommonConfig.currentConfig.fontEmphasis;
        this.tmpConfigFontResIndex = CommonConfig.currentConfig.fontResIndex;
        this.tmpConfigFontGap = CommonConfig.currentConfig.fontGap;
        this.tmpConfigFontSizeIndex = CommonConfig.currentConfig.fontSizeAdjustment;
        this.tmpConfigFontAutoSizing = CommonConfig.currentConfig.fontAutoSizing;
        this.tmpConfigFontName = CommonConfig.currentConfig.useOSFont ? CommonConfig.currentConfig.fontName : "Minecraft font (default)";
        this.tmpConfigSecondaryFontName = CommonConfig.currentConfig.secondaryFontName;
        this.tmpConfigSizeAdjustChars = CommonConfig.currentConfig.sizeAdjustChars;
    }

    public void func_73866_w_() {
        this.BTN_ROW1 = this.field_146295_m - 2 - 80 - 6;
        this.BTN_ROW2 = this.field_146295_m - 2 - 60 - 4;
        this.BTN_ROW3 = this.field_146295_m - 2 - 40 - 2;
        this.BTN_ROW4 = this.field_146295_m - 2 - 20;
        this.fontFilterField = new GuiTextFieldWithLabel(GuiPart.FIELD_FILTER.ordinal(), this.field_146289_q, this.field_146294_l - 130 + 50, 2, 70, 20, I18n.func_135052_a((String)"smoothfont.config.font.fontFilter", (Object[])new Object[0])){

            public void func_146192_a(int posX, int posY, int which) {
                boolean flag;
                boolean bl = flag = posX >= this.field_146209_f && posX < this.field_146209_f + this.field_146218_h && posY >= this.field_146210_g && posY < this.field_146210_g + this.field_146219_i;
                if (flag) {
                    switch (which) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            GuiFontSelection.this.filterText = "";
                            this.func_146180_a(GuiFontSelection.this.filterText);
                            GuiFontSelection.this.guiList.filteredFontList.clear();
                            GuiFontSelection.this.guiList.filteredFontList.addAll(GuiFontSelection.this.guiList.fontList);
                            GuiFontSelection.this.guiList.func_148145_f(-GuiFontSelection.this.guiList.func_148148_g());
                            GuiFontSelection.this.guiList.func_148145_f(GuiFontSelection.this.guiList.filteredFontList.indexOf(GuiFontSelection.this.tmpConfigFontName) * 16);
                            break;
                        }
                    }
                }
                super.func_146192_a(posX, posY, which);
            }
        };
        this.fontFilterField.func_146195_b(true);
        this.hoverChecker[GuiPart.FIELD_FILTER.ordinal()] = new HoverChecker(this.fontFilterField.field_146210_g, this.fontFilterField.field_146210_g + this.fontFilterField.field_146219_i, this.fontFilterField.field_146209_f, this.fontFilterField.field_146209_f + this.fontFilterField.field_146218_h, 500);
        this.sizeAdjustField = new GuiTextFieldWithLabel(GuiPart.FIELD_SIZE_ADJUST.ordinal(), this.field_146289_q, this.field_146294_l / 2 - 160, this.BTN_ROW3, 104, 20, I18n.func_135052_a((String)"smoothfont.config.font.sizeAdjustField", (Object[])new Object[0])){

            public void func_146192_a(int posX, int posY, int which) {
                boolean flag;
                boolean bl = flag = posX >= this.field_146209_f && posX < this.field_146209_f + this.field_146218_h && posY >= this.field_146210_g && posY < this.field_146210_g + this.field_146219_i;
                if (flag) {
                    switch (which) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            GuiFontSelection.this.tmpConfigSizeAdjustChars = "";
                            this.func_146180_a(GuiFontSelection.this.tmpConfigSizeAdjustChars);
                            break;
                        }
                    }
                }
                super.func_146192_a(posX, posY, which);
            }
        };
        this.sizeAdjustField.func_146180_a(this.tmpConfigSizeAdjustChars);
        this.hoverChecker[GuiPart.FIELD_SIZE_ADJUST.ordinal()] = new HoverChecker(this.sizeAdjustField.field_146210_g, this.sizeAdjustField.field_146210_g + this.sizeAdjustField.field_146219_i, this.sizeAdjustField.field_146209_f, this.sizeAdjustField.field_146209_f + this.sizeAdjustField.field_146218_h, 500);
        this.fontGapSld = this.addButton(new GuiSliderZero(GuiPart.SLD_FONT_GAP.ordinal(), this.field_146294_l / 2 - 160 + 216, this.BTN_ROW2, 104, 20, I18n.func_135052_a((String)"smoothfont.config.font.fontGap", (Object[])new Object[0]) + ": ", "", -5.0, 0.0, this.tmpConfigFontGap, false, true, I18n.func_135052_a((String)"smoothfont.config.font.fontGap.normal", (Object[])new Object[0])){

            protected void func_146119_b(Minecraft mc, int par1, int par2) {
                super.func_146119_b(mc, par1, par2);
                if (this.dragging) {
                    try {
                        GuiFontSelection.this.func_146284_a((GuiButton)this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.hoverChecker[GuiPart.SLD_FONT_GAP.ordinal()] = new HoverChecker((GuiButton)this.fontGapSld, 500);
        this.fontSizeSld = this.addButton(new GuiSliderFontSize(GuiPart.SLD_FONT_SIZE.ordinal(), this.field_146294_l / 2 - 160 + 104 + 4, this.BTN_ROW2, 104, 20, I18n.func_135052_a((String)"smoothfont.config.font.fontSize", (Object[])new Object[0]) + ": ", "", -4.0, 6.0, this.tmpConfigFontSizeIndex, false, true){

            protected void func_146119_b(Minecraft mc, int par1, int par2) {
                super.func_146119_b(mc, par1, par2);
                if (this.dragging) {
                    try {
                        GuiFontSelection.this.func_146284_a((GuiButton)this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.hoverChecker[GuiPart.SLD_FONT_SIZE.ordinal()] = new HoverChecker((GuiButton)this.fontSizeSld, 500);
        int maxFontSizeIndex = FontUtils.getMaxFontSizeIndex();
        this.fontResSld = this.addButton(new GuiSliderFontRes(GuiPart.SLD_FONT_RES.ordinal(), this.field_146294_l / 2 - 160 + 104 + 4, this.BTN_ROW1, 104, 20, I18n.func_135052_a((String)"smoothfont.config.font.fontRes", (Object[])new Object[0]) + ": ", "", 0.0, maxFontSizeIndex, this.tmpConfigFontResIndex, false, true, null){

            protected void func_146119_b(Minecraft mc, int par1, int par2) {
                super.func_146119_b(mc, par1, par2);
                if (this.dragging) {
                    try {
                        GuiFontSelection.this.func_146284_a((GuiButton)this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.hoverChecker[GuiPart.SLD_FONT_RES.ordinal()] = new HoverChecker((GuiButton)this.fontResSld, 500);
        this.spaceWidthSld = this.addButton(new GuiSliderEx(GuiPart.SLD_SPACE_WIDTH.ordinal(), this.field_146294_l / 2 - 160 + 216, this.BTN_ROW3, 104, 20, I18n.func_135052_a((String)"smoothfont.config.font.spaceWidth", (Object[])new Object[0]) + ": ", "", 0.0, 4.0, CommonConfig.currentConfig.fontSpaceWidth, false, true, I18n.func_135052_a((String)"smoothfont.config.font.spaceWidth.normal", (Object[])new Object[0]), 4.0){

            protected void func_146119_b(Minecraft mc, int par1, int par2) {
                super.func_146119_b(mc, par1, par2);
                if (this.dragging) {
                    try {
                        GuiFontSelection.this.func_146284_a((GuiButton)this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.spaceWidthSld.setSpecialStr(I18n.func_135052_a((String)"smoothfont.config.auto", (Object[])new Object[0])).setSpecialVal(0.0).updateSliderString();
        this.hoverChecker[GuiPart.SLD_SPACE_WIDTH.ordinal()] = new HoverChecker((GuiButton)this.spaceWidthSld, 500);
        this.autoSizingBtn = this.addButton(new GuiButton(GuiPart.BTN_AUTO_SIZING.ordinal(), this.field_146294_l / 2 - 160 + 216, this.BTN_ROW1, 104, 20, this.tmpConfigFontAutoSizing ? I18n.func_135052_a((String)"smoothfont.config.font.autoSizing.auto", (Object[])new Object[0]) : I18n.func_135052_a((String)"smoothfont.config.font.autoSizing.fixed", (Object[])new Object[0])));
        this.hoverChecker[GuiPart.BTN_AUTO_SIZING.ordinal()] = new HoverChecker(this.autoSizingBtn, 500);
        this.doubleRenderBtn = this.addButton(new GuiButton(GuiPart.BTN_DOUBLE_RENDERING.ordinal(), this.field_146294_l / 2 - 160, this.BTN_ROW2, 104, 20, I18n.func_135052_a((String)"smoothfont.config.font.doubleRendering", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("smoothfont.config.font.doubleRendering." + this.tmpConfigDoubleRendering), (Object[])new Object[0])));
        this.hoverChecker[GuiPart.BTN_DOUBLE_RENDERING.ordinal()] = new HoverChecker(this.doubleRenderBtn, 500);
        this.antiAliasBtn = this.addButton(new GuiButton(GuiPart.BTN_ANTI_ALIAS.ordinal(), this.field_146294_l / 2 - 160, this.BTN_ROW1, 104, 20, I18n.func_135052_a((String)"smoothfont.config.font.antiAlias", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("smoothfont.config.font.antiAlias." + this.tmpConfigAntiAlias), (Object[])new Object[0])));
        this.hoverChecker[GuiPart.BTN_ANTI_ALIAS.ordinal()] = new HoverChecker(this.antiAliasBtn, 500);
        this.detailListBtn = this.addButton(new GuiButton(GuiPart.BTN_DETAIL_LIST.ordinal(), this.field_146294_l - 130, 2, 40, 20, I18n.func_135052_a((String)("smoothfont.config.font.fontDetailList." + (CommonConfig.currentConfig.fontDetailList ? "on" : "off")), (Object[])new Object[0])));
        this.hoverChecker[GuiPart.BTN_DETAIL_LIST.ordinal()] = new HoverChecker(this.detailListBtn, 500);
        this.alignBaselineBtn = this.addButton(new GuiButton(GuiPart.BTN_ALIGN_BASELINE.ordinal(), this.field_146294_l / 2 - 160 + 104 + 4, this.BTN_ROW3, 104, 20, CommonConfig.currentConfig.fontAlignBaseline ? I18n.func_135052_a((String)"smoothfont.config.font.alignBaseline.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"smoothfont.config.font.alignBaseline.off", (Object[])new Object[0])));
        this.hoverChecker[GuiPart.BTN_ALIGN_BASELINE.ordinal()] = new HoverChecker(this.alignBaselineBtn, 500);
        this.targetToReplaceBtn = this.addButton(new GuiButton(GuiPart.BTN_TARGET_TO_REPLACE.ordinal(), this.field_146294_l / 2 - 160, this.BTN_ROW4, 104, 20, I18n.func_135052_a((String)"smoothfont.config.font.targetToReplace", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("smoothfont.config.font.targetToReplace." + CommonConfig.currentConfig.fontTargetToReplace), (Object[])new Object[0])));
        this.hoverChecker[GuiPart.BTN_TARGET_TO_REPLACE.ordinal()] = new HoverChecker(this.targetToReplaceBtn, 500);
        this.applyBtn = this.addButton(new GuiButton(GuiPart.BTN_APPLY.ordinal(), this.field_146294_l / 2 - 160 + 108, this.BTN_ROW4, 104, 20, I18n.func_135052_a((String)"smoothfont.config.font.apply", (Object[])new Object[0])));
        this.finishBtn = this.addButton(new GuiButton(GuiPart.BTN_FINISH.ordinal(), this.field_146294_l / 2 - 160 + 216, this.BTN_ROW4, 104, 20, I18n.func_135052_a((String)"smoothfont.config.font.finish", (Object[])new Object[0])));
        this.guiList = new FontList(this.field_146297_k);
        this.guiList.func_148134_d(7, 8);
        this.hoverChecker[GuiPart.SLOT_FONT_LIST.ordinal()] = new HoverChecker(this.guiList.field_148153_b, this.guiList.field_148154_c, this.guiList.field_148155_a / 2 - 75, this.guiList.field_148155_a / 2 + 75, 500);
        this.guiList.func_148145_f(this.guiList.filteredFontList.indexOf(this.tmpConfigFontName) * 16);
        this.hoverChecker[GuiPart.TEXT_MEM_USAGE.ordinal()] = new HoverChecker(0, this.field_146289_q.field_78288_b + 2, 0, this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"smoothfont.config.font.memUsage", (Object[])new Object[0])) + 2, 500);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            GuiPart[] guiPartArray = GuiPart.values();
            GuiPart guiPart = guiPartArray[button.field_146127_k];
            switch (guiPart) {
                case BTN_ANTI_ALIAS: {
                    ++this.tmpConfigAntiAlias;
                    if (this.tmpConfigAntiAlias > 2) {
                        this.tmpConfigAntiAlias = 0;
                    }
                    this.antiAliasBtn.field_146126_j = I18n.func_135052_a((String)"smoothfont.config.font.antiAlias", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("smoothfont.config.font.antiAlias." + this.tmpConfigAntiAlias), (Object[])new Object[0]);
                    break;
                }
                case BTN_DOUBLE_RENDERING: {
                    ++this.tmpConfigDoubleRendering;
                    if (this.tmpConfigDoubleRendering > 3) {
                        this.tmpConfigDoubleRendering = 0;
                    }
                    button.field_146126_j = I18n.func_135052_a((String)"smoothfont.config.font.doubleRendering", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("smoothfont.config.font.doubleRendering." + this.tmpConfigDoubleRendering), (Object[])new Object[0]);
                    break;
                }
                case SLD_FONT_RES: {
                    this.tmpConfigFontResIndex = ((GuiSlider)button).getValueInt();
                    break;
                }
                case BTN_AUTO_SIZING: {
                    this.tmpConfigFontAutoSizing = !this.tmpConfigFontAutoSizing;
                    button.field_146126_j = this.tmpConfigFontAutoSizing ? I18n.func_135052_a((String)"smoothfont.config.font.autoSizing.auto", (Object[])new Object[0]) : I18n.func_135052_a((String)"smoothfont.config.font.autoSizing.fixed", (Object[])new Object[0]);
                    break;
                }
                case SLD_FONT_SIZE: {
                    this.tmpConfigFontSizeIndex = ((GuiSlider)button).getValueInt();
                    break;
                }
                case SLD_FONT_GAP: {
                    this.tmpConfigFontGap = ((GuiSlider)button).getValueInt();
                    break;
                }
                case SLD_SPACE_WIDTH: {
                    CommonConfig.currentConfig.fontSpaceWidth = ((GuiSliderEx)button).getValueInt();
                    CommonConfig.saveCurrentConfig();
                    break;
                }
                case BTN_DETAIL_LIST: {
                    CommonConfig.currentConfig.fontDetailList = !CommonConfig.currentConfig.fontDetailList;
                    button.field_146126_j = I18n.func_135052_a((String)("smoothfont.config.font.fontDetailList." + (CommonConfig.currentConfig.fontDetailList ? "on" : "off")), (Object[])new Object[0]);
                    this.guiList = new FontList(this.field_146297_k);
                    this.guiList.func_148134_d(7, 8);
                    this.guiList.func_148145_f(this.guiList.filteredFontList.indexOf(this.tmpConfigFontName) * 16);
                    break;
                }
                case BTN_ALIGN_BASELINE: {
                    CommonConfig.currentConfig.fontAlignBaseline = !CommonConfig.currentConfig.fontAlignBaseline;
                    button.field_146126_j = CommonConfig.currentConfig.fontAlignBaseline ? I18n.func_135052_a((String)"smoothfont.config.font.alignBaseline.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"smoothfont.config.font.alignBaseline.off", (Object[])new Object[0]);
                    CommonConfig.saveCurrentConfig();
                    break;
                }
                case BTN_TARGET_TO_REPLACE: {
                    CommonConfig.currentConfig.fontTargetToReplace = CommonConfig.currentConfig.fontTargetToReplace == 0 ? 1 : 0;
                    button.field_146126_j = I18n.func_135052_a((String)"smoothfont.config.font.targetToReplace", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("smoothfont.config.font.targetToReplace." + CommonConfig.currentConfig.fontTargetToReplace), (Object[])new Object[0]);
                    FontRendererHook.updateChangeFontFlagAll();
                    FontRendererHook.updateHookFlagsAll();
                    GuiFontSelection.updateFontSizeInfoAll();
                    CommonConfig.saveCurrentConfig();
                    break;
                }
                case BTN_APPLY: {
                    this.applyFontSetting();
                    break;
                }
                case BTN_FINISH: {
                    this.applyFontSetting();
                    this.field_146297_k.func_147108_a(this.parentScreen);
                    break;
                }
                default: {
                    this.guiList.func_148147_a(button);
                }
            }
        }
    }

    private void applyFontSetting() {
        if (this.tmpConfigAntiAlias == CommonConfig.currentConfig.fontAntiAlias && this.tmpConfigDoubleRendering == CommonConfig.currentConfig.fontEmphasis && this.tmpConfigFontResIndex == CommonConfig.currentConfig.fontResIndex && this.tmpConfigFontSizeIndex == CommonConfig.currentConfig.fontSizeAdjustment && this.tmpConfigFontAutoSizing == CommonConfig.currentConfig.fontAutoSizing && this.tmpConfigFontGap == CommonConfig.currentConfig.fontGap && this.tmpConfigFontName.equals(CommonConfig.currentConfig.fontName) && this.tmpConfigSecondaryFontName.equals(CommonConfig.currentConfig.secondaryFontName) && this.tmpConfigSizeAdjustChars.equals(CommonConfig.currentConfig.sizeAdjustChars)) {
            return;
        }
        CommonConfig.currentConfig.fontAntiAlias = this.tmpConfigAntiAlias;
        CommonConfig.currentConfig.fontEmphasis = this.tmpConfigDoubleRendering;
        CommonConfig.currentConfig.fontResIndex = this.tmpConfigFontResIndex;
        CommonConfig.currentConfig.fontSizeAdjustment = this.tmpConfigFontSizeIndex;
        CommonConfig.currentConfig.fontAutoSizing = this.tmpConfigFontAutoSizing;
        CommonConfig.currentConfig.fontGap = this.tmpConfigFontGap;
        CommonConfig.currentConfig.fontName = this.tmpConfigFontName;
        CommonConfig.currentConfig.secondaryFontName = this.tmpConfigSecondaryFontName;
        CommonConfig.currentConfig.sizeAdjustChars = this.tmpConfigSizeAdjustChars;
        CommonConfig.currentConfig.useOSFont = !this.tmpConfigFontName.equals("Minecraft font (default)");
        CommonConfig.saveCurrentConfig();
        GuiFontSelection.reloadFonts();
    }

    public static void reloadFonts() {
        FontRendererHook.updateChangeFontFlagAll();
        FontRendererHook.updateHookFlagsAll();
        if (!CommonConfig.currentConfig.useOSFont) {
            FontRasterizer.getInstance().clearFontCache();
        } else {
            int fontRes = FontUtils.getFontRes(CommonConfig.currentConfig.fontResIndex);
            boolean result = FontRasterizer.getInstance().setFontSafely(CommonConfig.currentConfig.fontName, CommonConfig.currentConfig.secondaryFontName, fontRes, CommonConfig.currentConfig.fontGap, CommonConfig.currentConfig.fontSizeAdjustment, CommonConfig.currentConfig.fontAntiAlias, CommonConfig.currentConfig.fontEmphasis);
            if (!result) {
                FontRendererHook.clearChangeFontFlagAll();
                FontRendererHook.updateHookFlagsAll();
                FontRasterizer.getInstance().clearFontCache();
            }
        }
        GuiFontSelection.updateFontSizeInfoAll();
    }

    private static void updateFontSizeInfoAll() {
        FontTextureManager.getInstance().func_110549_a(Minecraft.func_71410_x().func_110442_L());
        FontRasterizer.getInstance().restoreGlyphWidthAll();
        FontRendererHook.updateMarginsAll();
    }

    public void func_73876_c() {
        this.fontFilterField.func_146178_a();
        this.sizeAdjustField.func_146178_a();
        super.func_73876_c();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.guiList.func_148128_a(mouseX, mouseY, partialTicks);
        this.fontFilterField.func_146194_f();
        this.sizeAdjustField.func_146194_f();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"smoothfont.config.font.title", (Object[])new Object[0]), this.field_146294_l / 2, 10, 0xFFFFFF);
        if (FontRasterizer.getInstance().glyphsGenerationError) {
            this.func_73731_b(this.field_146289_q, "Cannot change font: " + FontRasterizer.getInstance().glyphsGenerationErrorMessage, 2, 2, 0xFF0000);
        } else {
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"smoothfont.config.font.memUsage", (Object[])new Object[0]) + ": " + FontRasterizer.getInstance().totalImageSize / 1024L / 1024L + "MB", 2, 2, 0xB0B0B0);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawTooltip(mouseX, mouseY);
    }

    public void func_73869_a(char ch, int code) {
        if (this.fontFilterField.func_146206_l()) {
            if (GuiFontSelection.func_146271_m() && code == 35) {
                this.fontFilterField.func_146175_b(-1);
            } else {
                this.fontFilterField.func_146201_a(ch, code);
            }
            this.filterText = this.fontFilterField.func_146179_b();
            this.guiList.filteredFontList.clear();
            for (String fontName : this.guiList.fontList) {
                if (!Normalizer.normalize(fontName, Normalizer.Form.NFKC).toLowerCase().contains(Normalizer.normalize(this.filterText, Normalizer.Form.NFKC).toLowerCase())) continue;
                this.guiList.filteredFontList.add(fontName);
            }
        }
        if (this.sizeAdjustField.func_146206_l()) {
            if (GuiFontSelection.func_146271_m() && code == 35) {
                this.sizeAdjustField.func_146175_b(-1);
            } else {
                this.sizeAdjustField.func_146201_a(ch, code);
            }
            this.tmpConfigSizeAdjustChars = this.sizeAdjustField.func_146179_b();
        }
        if (code == 1) {
            this.field_146297_k.func_147108_a(this.parentScreen);
            return;
        }
        try {
            super.func_73869_a(ch, code);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_73864_a(int posX, int posY, int which) {
        if (this.fontFilterField.func_146176_q()) {
            this.fontFilterField.func_146192_a(posX, posY, which);
        }
        if (this.sizeAdjustField.func_146176_q()) {
            this.sizeAdjustField.func_146192_a(posX, posY, which);
        }
        try {
            super.func_73864_a(posX, posY, which);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawTooltip(int mouseX, int mouseY) {
        for (GuiPart gp : GuiPart.values()) {
            if (this.hoverChecker[gp.ordinal()] == null || !this.hoverChecker[gp.ordinal()].checkHover(mouseX, mouseY)) continue;
            if (mouseX != this.prevX || mouseY != this.prevY) {
                this.hoverChecker[gp.ordinal()].resetHoverTimer();
            } else {
                switch (gp) {
                    case FIELD_SIZE_ADJUST: {
                        this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.sizeAdjustField", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                        break;
                    }
                    case SLOT_FONT_LIST: {
                        this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.fontNameList", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                        break;
                    }
                    case BTN_DETAIL_LIST: {
                        this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.fontDetailList", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                        break;
                    }
                    case FIELD_FILTER: {
                        break;
                    }
                    case SLD_FONT_GAP: {
                        this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.fontGap", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                        break;
                    }
                    case SLD_SPACE_WIDTH: {
                        this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.spaceWidth", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                        break;
                    }
                    case SLD_FONT_RES: {
                        this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.fontRes", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                        break;
                    }
                    case BTN_AUTO_SIZING: {
                        this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.fontAutoSizing", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                        break;
                    }
                    case SLD_FONT_SIZE: {
                        this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.fontSize", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                        break;
                    }
                    case BTN_ANTI_ALIAS: {
                        this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.antiAlias", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                        break;
                    }
                    case BTN_DOUBLE_RENDERING: {
                        this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.doubleRendering", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                        break;
                    }
                    case BTN_ALIGN_BASELINE: {
                        this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.fontAlignBaseline", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                        break;
                    }
                    case BTN_TARGET_TO_REPLACE: {
                        this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.targetToReplace", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                        break;
                    }
                    case TEXT_MEM_USAGE: {
                        this.drawHoveringText(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.font.memUsage", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                        break;
                    }
                }
            }
            this.prevX = mouseX;
            this.prevY = mouseY;
        }
    }

    private List strToList(String str) {
        return GuiCommon.strToList(this.field_146289_q, Math.min(200, this.field_146294_l / 2 - 20), str);
    }

    protected <T extends GuiButton> T addButton(T btn) {
        this.field_146292_n.add(btn);
        return btn;
    }

    @SideOnly(value=Side.CLIENT)
    class FontList
    extends GuiSlot {
        private final List<String> fontList;
        private List<String> filteredFontList;

        public FontList(Minecraft mc) {
            super(mc, GuiFontSelection.this.field_146294_l, GuiFontSelection.this.field_146295_m, 24, GuiFontSelection.this.BTN_ROW1 - 2, 16);
            this.fontList = new ArrayList<String>();
            this.filteredFontList = new ArrayList<String>();
            this.fontList.add("Minecraft font (default)");
            if (CommonConfig.currentConfig.fontDetailList) {
                this.fontList.addAll(FontUtils.getFontList());
            } else {
                this.fontList.addAll(FontUtils.getFontFamilyList());
            }
            for (String fontName : this.fontList) {
                if (!Normalizer.normalize(fontName, Normalizer.Form.NFKC).toLowerCase().contains(Normalizer.normalize(GuiFontSelection.this.filterText, Normalizer.Form.NFKC).toLowerCase())) continue;
                this.filteredFontList.add(fontName);
            }
            if (GuiFontSelection.this.tmpConfigFontName.isEmpty()) {
                if (CommonConfig.currentConfig.useOSFont) {
                    if (this.fontList.indexOf(CommonConfig.currentConfig.fontName) == -1) {
                        GuiFontSelection.this.tmpConfigFontName = CommonConfig.currentConfig.fontName;
                    } else {
                        GuiFontSelection.this.tmpConfigFontName = CommonConfig.currentConfig.fontName;
                    }
                } else {
                    GuiFontSelection.this.tmpConfigFontName = "Minecraft font (default)";
                }
            }
        }

        protected int func_148127_b() {
            return this.filteredFontList.size();
        }

        protected void func_148144_a(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
            if (isDoubleClick && !this.filteredFontList.get(slotIndex).equals("Minecraft font (default)")) {
                GuiFontSelection.this.tmpConfigSecondaryFontName = this.filteredFontList.get(slotIndex);
            }
            GuiFontSelection.this.tmpConfigFontName = this.filteredFontList.get(slotIndex);
        }

        protected boolean func_148131_a(int slotIndex) {
            return slotIndex == this.filteredFontList.indexOf(GuiFontSelection.this.tmpConfigFontName);
        }

        protected int func_148138_e() {
            return this.func_148127_b() * 16;
        }

        protected void func_148123_a() {
            GuiFontSelection.this.func_146276_q_();
        }

        protected void func_148126_a(int p_148126_1_, int p_148126_2_, int p_148126_3_, int p_148126_4_, Tessellator p_148126_5_, int p_148126_6_, int p_148126_7_) {
            if (this.filteredFontList.get(p_148126_1_).equals(GuiFontSelection.this.tmpConfigSecondaryFontName)) {
                GuiFontSelection.this.func_73732_a(GuiFontSelection.this.field_146289_q, this.filteredFontList.get(p_148126_1_), this.field_148155_a / 2, p_148126_3_ + 1, 0xFFFF00);
            } else {
                GuiFontSelection.this.func_73732_a(GuiFontSelection.this.field_146289_q, this.filteredFontList.get(p_148126_1_), this.field_148155_a / 2, p_148126_3_ + 1, 0xFFFFFF);
            }
        }
    }

    private static enum GuiPart {
        FIELD_FILTER,
        FIELD_SIZE_ADJUST,
        SLOT_FONT_LIST,
        SLD_FONT_SIZE,
        SLD_FONT_RES,
        BTN_AUTO_SIZING,
        SLD_FONT_GAP,
        SLD_SPACE_WIDTH,
        BTN_DOUBLE_RENDERING,
        BTN_ANTI_ALIAS,
        BTN_ALIGN_BASELINE,
        BTN_TARGET_TO_REPLACE,
        BTN_DETAIL_LIST,
        BTN_APPLY,
        BTN_FINISH,
        TEXT_MEM_USAGE;

    }
}

