/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont.proxy;

import bre.smoothfont.CommandSfont;
import bre.smoothfont.ExternalFontManager;
import bre.smoothfont.FontRendererHook;
import bre.smoothfont.FontRendererHookList;
import bre.smoothfont.KeyBindEventHandler;
import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.config.GlobalConfig;
import bre.smoothfont.config.OldConfig;
import bre.smoothfont.config.PlayerConfig;
import bre.smoothfont.gui.GuiHandler;
import bre.smoothfont.mod_SmoothFont;
import bre.smoothfont.proxy.CommonProxy;
import bre.smoothfont.util.Logger;
import bre.smoothfont.util.ModLib;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import org.apache.commons.codec.digest.DigestUtils;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    Minecraft mc = Minecraft.func_71410_x();
    public static KeyBinding openGuiKey = new KeyBinding("smoothfont.key.guiOpen", 199, "smoothfont.key.categories");
    private File configDirectory;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        Logger.init(event);
        this.configDirectory = event.getModConfigurationDirectory();
        File globalConfigFile = new File(this.configDirectory, "smoothfont" + File.separator + "smoothfont" + ".cfg");
        if (ModLib.checkDevEnv()) {
            GlobalConfig.existingConfigFile = globalConfigFile.exists();
        }
        CommonConfig.globalConfig = new GlobalConfig(globalConfigFile);
        CommonConfig.currentConfig = CommonConfig.globalConfig;
        File oldConfigFile = event.getSuggestedConfigurationFile();
        if (oldConfigFile.exists()) {
            if (!GlobalConfig.existingConfigFile) {
                OldConfig.readConfig(oldConfigFile);
                CommonConfig.globalConfig.takeoverOldConfigValues();
                CommonConfig.globalConfig.saveConfig();
                Logger.info("New global config file took over the parameters in the old config file.");
            }
            File oldConfigBackup = new File(this.configDirectory, "smoothfont" + File.separator + "oldConfig.bak");
            try {
                if (oldConfigBackup.exists()) {
                    oldConfigBackup.delete();
                }
                oldConfigFile.renameTo(oldConfigBackup);
            }
            catch (Exception e) {
                Logger.error("Configuration file access error. (OldConfig)");
                e.printStackTrace();
            }
        }
        if (CommonConfig.globalConfig.enablePerPlayerConfig) {
            String playerHashStr = ModLib.checkDevEnv() ? "debugDummy" : DigestUtils.md5Hex((String)Minecraft.func_71410_x().func_110432_I().func_148255_b());
            PlayerConfig.playerConfigFile = new File(this.configDirectory, "smoothfont" + File.separator + "player-" + playerHashStr + ".cfg");
            if (PlayerConfig.playerConfigFile.exists()) {
                PlayerConfig.readPlayerConfig();
            }
        }
        GlobalConfig.configLoaded = true;
        ExternalFontManager.getInstance().registerExternalFonts();
        FontRendererHook.initAfterConfigLoaded();
        super.preInit(event);
    }

    @Override
    public void init() {
        FMLCommonHandler.instance().bus().register((Object)new KeyBindEventHandler());
        ClientRegistry.registerKeyBinding((KeyBinding)openGuiKey);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)mod_SmoothFont.instance, (IGuiHandler)new GuiHandler());
        ClientCommandHandler.instance.func_71560_a((ICommand)CommandSfont.INSTANCE);
        super.init();
    }

    @Override
    public void postInit() {
        if (CommonConfig.globalConfig.workaroundKeepOriginalWidthValues) {
            FontRendererHookList hookList = new FontRendererHookList(){

                @Override
                public boolean process(FontRendererHook frh) {
                    if (frh.fontRenderer == ClientProxy.this.mc.field_71466_p) {
                        frh.keepMcFontWidth = true;
                        frh.reloadResources();
                    }
                    return true;
                }
            };
            hookList.executeAll();
        }
        super.postInit();
        FontRendererHook.modLoaded = true;
    }
}

