/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont;

import bre.smoothfont.FontUtils;
import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.util.Logger;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class FontPixels {
    private Font font;
    private FontMetrics fm;
    private boolean antiAlias;
    private boolean fractionalMetrics;
    private double height;
    private double ascent;
    private double decent;
    private double leading;
    private double maxWidth;
    private char maxWidthChar;

    public FontPixels(Font font, FontMetrics fm, boolean antiAlias, boolean fractionalMetrics) {
        this.font = font;
        this.fm = fm;
        this.antiAlias = antiAlias;
        this.fractionalMetrics = fractionalMetrics;
        String charsAlphabet = "!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{}~";
        String charsLocal = FontUtils.getCurrentLangStr();
        String testString = font.canDisplayUpTo(charsLocal) == -1 ? charsAlphabet + charsLocal + CommonConfig.currentConfig.sizeAdjustChars : charsAlphabet + CommonConfig.currentConfig.sizeAdjustChars;
        AffineTransform affinetransform = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(affinetransform, this.antiAlias, this.fractionalMetrics);
        GlyphVector gv = font.createGlyphVector(frc, testString);
        Rectangle2D rectangle = gv.getVisualBounds();
        this.height = rectangle.getHeight();
        this.ascent = Math.abs(rectangle.getY());
        this.decent = this.height - this.ascent;
        this.maxWidthChar = this.getMaxWidthChar(testString);
        gv = font.createGlyphVector(frc, String.valueOf(this.maxWidthChar));
        rectangle = gv.getVisualBounds();
        this.maxWidth = rectangle.getWidth();
    }

    public double getHeight() {
        return this.height;
    }

    public double getAscent() {
        return this.ascent;
    }

    public double getDecent() {
        return this.decent;
    }

    public double getMaxWidth() {
        return this.maxWidth;
    }

    public float getFittedSize(int pixelSize, float startSize, float step) {
        float size = startSize;
        while (true) {
            Font workFont = this.font.deriveFont(size + step);
            FontPixels fp = new FontPixels(workFont, this.fm, this.antiAlias, this.fractionalMetrics);
            Logger.debug("height = " + fp.getHeight() + ", maxWidth(" + this.maxWidthChar + ") = " + fp.getMaxWidth());
            if (fp.getHeight() == 0.0 || !(fp.getHeight() < (double)pixelSize) || !(fp.getMaxWidth() < (double)pixelSize * (double)1.12f)) break;
            size += step;
        }
        return size;
    }

    @Deprecated
    public double getCharWidth(char ch) {
        GlyphVector gv = this.font.createGlyphVector(this.fm.getFontRenderContext(), String.valueOf(ch));
        Rectangle rectangle = gv.getPixelBounds(null, 0.0f, 0.0f);
        return ((RectangularShape)rectangle).getWidth();
    }

    @Deprecated
    public double getCharWidth2(char ch) {
        AffineTransform affinetransform = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
        double width = this.font.getStringBounds(String.valueOf(ch), frc).getWidth();
        return width;
    }

    private char getMaxWidthChar(String testStr) {
        char[] chs;
        double maxCharWidth = 0.0;
        char maxWidthChar = '\u0000';
        for (char ch : chs = testStr.toCharArray()) {
            double chWidth = this.getCharWidth(ch);
            if (!(chWidth > maxCharWidth)) continue;
            maxCharWidth = chWidth;
            maxWidthChar = ch;
        }
        return maxWidthChar;
    }
}

