/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont;

import bre.smoothfont.FontRasterizer;
import bre.smoothfont.FontRendererHook;
import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.util.Logger;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;

public class FontShader {
    private static FontShader INSTANCE = new FontShader();
    private int shaderProg;
    private int shaderProgWithLight;
    private boolean enableShader = true;
    private boolean lightmap;
    private int prevShaderProg;
    private boolean shaderEnabled = false;
    private boolean shaderParamDefaultStatus = false;
    private boolean shaderParamUnicodeStatus = false;
    private float rgbDefault;
    private float rgbUnicode;
    private float alphaDefault;
    private float alphaUnicode;

    private FontShader() {
        this.setupShader();
    }

    public static FontShader getInstance() {
        return INSTANCE;
    }

    private void setupShader() {
        if (!this.enableShader) {
            return;
        }
        String vShaderSrc = "#version 120\nvoid main(void){  gl_Position = ftransform();  gl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0;  gl_FrontColor = gl_Color;}";
        String fShaderSrc = "#version 120\nuniform sampler2D texture;uniform vec4 colorBias;void main(void){  vec4 color = texture2DProj(texture, gl_TexCoord[0]);  color.r = clamp(color.r + colorBias.r , 0.0, 1.0);  color.g = clamp(color.g + colorBias.g , 0.0, 1.0);  color.b = clamp(color.b + colorBias.b , 0.0, 1.0);  color.a = clamp(color.a * colorBias.a , 0.0, 1.0);  gl_FragColor = color * gl_Color;}";
        String vShaderSrc2 = "#version 120\nvoid main(void){  gl_Position = ftransform();  gl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0;  gl_TexCoord[1] = gl_TextureMatrix[1] * gl_MultiTexCoord1;  gl_FrontColor = gl_Color;}";
        String fShaderSrc2 = "#version 120\nuniform sampler2D texture;uniform sampler2D texture2;uniform vec4 colorBias;void main(void){  vec4 color = texture2DProj(texture, gl_TexCoord[0]);  vec4 color2 = texture2DProj(texture2, gl_TexCoord[1]);  color.r = clamp(color.r + colorBias.r , 0.0, 1.0);  color.g = clamp(color.g + colorBias.g , 0.0, 1.0);  color.b = clamp(color.b + colorBias.b , 0.0, 1.0);  color.a = clamp(color.a * colorBias.a , 0.0, 1.0);  gl_FragColor = color * color2 * gl_Color;}";
        this.shaderProg = this.getShaderProg(vShaderSrc, fShaderSrc);
        this.shaderProgWithLight = this.getShaderProg(vShaderSrc2, fShaderSrc2);
    }

    private int getShaderProg(String vShaderSrc, String fShaderSrc) {
        int shader = GL20.glCreateProgram();
        int vShaderId = GL20.glCreateShader((int)35633);
        int fShaderId = GL20.glCreateShader((int)35632);
        GL20.glShaderSource((int)vShaderId, (CharSequence)vShaderSrc);
        GL20.glShaderSource((int)fShaderId, (CharSequence)fShaderSrc);
        GL20.glCompileShader((int)vShaderId);
        String verr = GL20.glGetShaderInfoLog((int)vShaderId, (int)512);
        if (!verr.equals("")) {
            Logger.error("Vertex shader compile error: " + verr);
        }
        GL20.glCompileShader((int)fShaderId);
        String ferr = GL20.glGetShaderInfoLog((int)fShaderId, (int)512);
        if (!verr.equals("")) {
            Logger.error("Fragment shader compile error: " + ferr);
        }
        GL20.glAttachShader((int)shader, (int)fShaderId);
        GL20.glLinkProgram((int)shader);
        return shader;
    }

    private void setColorBias(boolean lightmap, float r, float g, float b, float a) {
        if (lightmap) {
            int colorBiasUniLoc = GL20.glGetUniformLocation((int)this.shaderProgWithLight, (CharSequence)"colorBias");
            GL20.glUniform4f((int)colorBiasUniLoc, (float)r, (float)g, (float)b, (float)a);
        } else {
            int colorBiasUniLoc = GL20.glGetUniformLocation((int)this.shaderProg, (CharSequence)"colorBias");
            GL20.glUniform4f((int)colorBiasUniLoc, (float)r, (float)g, (float)b, (float)a);
        }
    }

    private void useProgram(boolean lightmap) {
        if (lightmap) {
            this.useProgram(this.shaderProgWithLight);
            int texLoc = GL20.glGetUniformLocation((int)this.shaderProgWithLight, (CharSequence)"texture");
            GL20.glUniform1i((int)texLoc, (int)(OpenGlHelper.field_77478_a - 33984));
            int texLoc2 = GL20.glGetUniformLocation((int)this.shaderProgWithLight, (CharSequence)"texture2");
            GL20.glUniform1i((int)texLoc2, (int)(OpenGlHelper.field_77476_b - 33984));
        } else {
            this.useProgram(this.shaderProg);
            int texLoc = GL20.glGetUniformLocation((int)this.shaderProg, (CharSequence)"texture");
            GL20.glUniform1i((int)texLoc, (int)(OpenGlHelper.field_77478_a - 33984));
        }
    }

    public void useProgram(int prog) {
        if (!this.enableShader) {
            return;
        }
        while (GL11.glGetError() != 0) {
        }
        GL20.glUseProgram((int)prog);
        int errno = GL11.glGetError();
        if (errno != 0) {
            Logger.error("glUseProgram Error: " + errno);
        }
    }

    private void disuseProgram() {
        if (!this.enableShader) {
            return;
        }
        GL20.glUseProgram((int)0);
        if (GL11.glGetError() != 0) {
            Logger.error("glUseProgram Error.");
        }
    }

    private int getCurProgram() {
        if (!this.enableShader) {
            return 0;
        }
        return GL11.glGetInteger((int)35725);
    }

    private boolean checkLightmapTexUnit() {
        GL13.glActiveTexture((int)OpenGlHelper.field_77476_b);
        boolean ret = GL11.glGetBoolean((int)3553);
        GL13.glActiveTexture((int)OpenGlHelper.field_77478_a);
        return ret;
    }

    public void setShaderParams(FontRendererHook frh, boolean unicodeFlag) {
        if (this.shaderEnabled) {
            if (unicodeFlag) {
                if (!this.shaderParamUnicodeStatus) {
                    this.setColorBias(this.lightmap & !frh.orthographic, this.rgbUnicode, this.rgbUnicode, this.rgbUnicode, this.alphaUnicode);
                    this.shaderParamDefaultStatus = false;
                    this.shaderParamUnicodeStatus = true;
                }
            } else if (!this.shaderParamDefaultStatus) {
                this.setColorBias(this.lightmap & !frh.orthographic, this.rgbDefault, this.rgbDefault, this.rgbDefault, this.alphaDefault);
                this.shaderParamDefaultStatus = true;
                this.shaderParamUnicodeStatus = false;
            }
        }
    }

    public void restoreShaderTemporarily() {
        if (this.shaderEnabled) {
            this.useProgram(this.prevShaderProg);
        }
    }

    public void resetShader(FontRendererHook frh) {
        if (this.shaderEnabled) {
            this.useProgram(this.lightmap & !frh.orthographic);
        }
    }

    public void prepareAndEnableShader(FontRendererHook frh) {
        this.prevShaderProg = this.getCurProgram();
        if (this.prevShaderProg == 0 && CommonConfig.currentConfig.brightness != 0) {
            float brightnessFactorUnicode;
            float brightnessFactorDefault;
            float boundaryScaleFactorUnicode;
            float boundaryScaleFactorDefault;
            int brightnessUnicode;
            int brightnessDefault;
            this.shaderEnabled = true;
            this.alphaDefault = 1.0f;
            this.alphaUnicode = 1.0f;
            this.rgbDefault = 0.0f;
            this.rgbUnicode = 0.0f;
            if (CommonConfig.currentConfig.autoBrightness && !frh.changeFont) {
                brightnessDefault = frh.autoBrightnessDefault;
                brightnessUnicode = frh.autoBrightnessUnicode;
                boundaryScaleFactorDefault = frh.brightnessBoundaryScaleFactorDefault;
                boundaryScaleFactorUnicode = frh.brightnessBoundaryScaleFactorUnicode;
            } else {
                brightnessDefault = CommonConfig.currentConfig.brightness;
                brightnessUnicode = CommonConfig.currentConfig.brightness;
                boundaryScaleFactorUnicode = boundaryScaleFactorDefault = FontRasterizer.getInstance().brightnessBoundaryScaleFactor;
            }
            if (frh.roundedFontScale < 3.0f) {
                brightnessFactorDefault = 7.0f;
                brightnessFactorUnicode = 7.0f;
            } else {
                brightnessFactorDefault = frh.roundedFontScale < boundaryScaleFactorDefault ? 20.0f - 13.0f / (boundaryScaleFactorDefault - 3.0f) * (boundaryScaleFactorDefault - frh.roundedFontScale) : 20.0f;
                brightnessFactorUnicode = frh.roundedFontScale < boundaryScaleFactorUnicode ? 20.0f - 13.0f / (boundaryScaleFactorUnicode - 3.0f) * (boundaryScaleFactorUnicode - frh.roundedFontScale) : 20.0f;
            }
            this.alphaDefault = 1.0f + (float)brightnessDefault / brightnessFactorDefault;
            this.alphaUnicode = 1.0f + (float)brightnessUnicode / brightnessFactorUnicode;
            if (CommonConfig.currentConfig.enablePremultipliedAlpha) {
                this.rgbDefault = (this.alphaDefault - 1.0f) / 2.0f;
                this.rgbUnicode = (this.alphaUnicode - 1.0f) / 2.0f;
            }
            this.lightmap = this.checkLightmapTexUnit();
            this.useProgram(this.lightmap & !frh.orthographic);
            this.setColorBias(this.lightmap & !frh.orthographic, 0.0f, 0.0f, 0.0f, 1.0f);
            this.shaderParamDefaultStatus = false;
            this.shaderParamUnicodeStatus = false;
        }
    }

    public void restoreShader() {
        if (this.shaderEnabled) {
            this.useProgram(this.prevShaderProg);
            this.shaderEnabled = false;
        }
    }
}

