/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowundertrees;

import bl4ckscor3.mod.snowundertrees.Configuration;
import bl4ckscor3.mod.snowundertrees.SnowUnderTreesFeature;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolder;

@Mod(value="snowundertrees")
@Mod.EventBusSubscriber(modid="snowundertrees", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SnowUnderTrees {
    public static final String MODID = "snowundertrees";
    @ObjectHolder(value="snowundertrees:snow_under_trees")
    public static final Feature<NoFeatureConfig> SNOW_UNDER_TREES = (Feature)new SnowUnderTreesFeature(NoFeatureConfig::func_214639_a).setRegistryName("snow_under_trees");
    private static List<Biome> biomesToAddTo = new ArrayList<Biome>();

    public SnowUnderTrees() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Configuration.CONFIG_SPEC);
    }

    @SubscribeEvent
    public static void onRegisterFeature(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().register(SNOW_UNDER_TREES);
    }

    @SubscribeEvent
    public static void onFMLLoadComplete(FMLLoadCompleteEvent event) {
        if (((Boolean)Configuration.CONFIG.enableBiomeFeature.get()).booleanValue()) {
            for (Biome biome : ForgeRegistries.BIOMES) {
                if (biome.func_201851_b() != Biome.RainType.SNOW && !biomesToAddTo.contains(biome) || ((List)Configuration.CONFIG.filteredBiomes.get()).contains(biome.getRegistryName().toString())) continue;
                biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, Biome.func_222280_a(SNOW_UNDER_TREES, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215022_h, (IPlacementConfig)IPlacementConfig.field_202468_e));
            }
        }
        biomesToAddTo = null;
    }

    public static void addSnowUnderTrees(Biome biome) {
        if (!biomesToAddTo.contains(biome)) {
            biomesToAddTo.add(biome);
        }
    }
}

