/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowundertrees;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class SnowUnderTreesFeature
extends Feature<NoFeatureConfig> {
    public SnowUnderTreesFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        BlockPos.Mutable mPos = new BlockPos.Mutable();
        BlockPos.Mutable mPosDown = new BlockPos.Mutable();
        for (int xi = 0; xi < 16; ++xi) {
            for (int zi = 0; zi < 16; ++zi) {
                int x = pos.func_177958_n() + xi;
                int z = pos.func_177952_p() + zi;
                mPos.func_181079_c(x, world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, x, z) - 1, z);
                if (!(world.func_180495_p((BlockPos)mPos).func_177230_c() instanceof LeavesBlock)) continue;
                mPos.func_181079_c(x, world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, x, z), z);
                BlockState state = world.func_180495_p((BlockPos)mPos);
                if (!state.isAir((IBlockReader)world, (BlockPos)mPos)) continue;
                mPosDown.func_189533_g((Vec3i)mPos).func_189536_c(Direction.DOWN);
                BlockState below = world.func_180495_p((BlockPos)mPosDown);
                world.func_180501_a((BlockPos)mPos, Blocks.field_150433_aE.func_176223_P(), 2);
                if (!below.func_196959_b((IProperty)SnowyDirtBlock.field_196382_a)) continue;
                world.func_180501_a((BlockPos)mPosDown, (BlockState)below.func_206870_a((IProperty)SnowyDirtBlock.field_196382_a, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
        return true;
    }
}

