/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.asm.module;

import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.applecore.asm.ASMConstants;
import squeek.applecore.asm.IClassTransformerModule;
import squeek.asmhelper.applecore.ASMHelper;
import squeek.asmhelper.applecore.ObfHelper;

public class ModuleFoodStats
implements IClassTransformerModule {
    public static String foodStatsPlayerField = "entityplayer";
    public static String foodStatsStarveTimerField = "starveTimer";

    @Override
    public String[] getClassesToTransform() {
        return new String[]{"net.minecraft.entity.player.EntityPlayer", "net.minecraft.util.FoodStats"};
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.entity.player.EntityPlayer")) {
            ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
            MethodNode methodNode = ASMHelper.findMethodNodeOfClass(classNode, "<init>", null);
            if (methodNode != null) {
                this.patchEntityPlayerInit(methodNode);
                return ASMHelper.writeClassToBytes(classNode);
            }
            throw new RuntimeException("EntityPlayer: <init> method not found");
        }
        if (transformedName.equals("net.minecraft.util.FoodStats")) {
            ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
            this.injectFoodStatsPlayerField(classNode);
            this.injectFoodStatsConstructor(classNode);
            classNode.fields.add(new FieldNode(1, foodStatsStarveTimerField, "I", null, null));
            classNode.interfaces.add(ASMHelper.toInternalClassName("squeek.applecore.asm.util.IAppleCoreFoodStats"));
            this.tryAddFieldGetter(classNode, "getFoodTimer", ObfHelper.isObfuscated() ? "field_75123_d" : "foodTimer", "I");
            this.tryAddFieldSetter(classNode, "setFoodTimer", ObfHelper.isObfuscated() ? "field_75123_d" : "foodTimer", "I");
            this.tryAddFieldGetter(classNode, "getStarveTimer", foodStatsStarveTimerField, "I");
            this.tryAddFieldSetter(classNode, "setStarveTimer", foodStatsStarveTimerField, "I");
            this.tryAddFieldGetter(classNode, "getPlayer", foodStatsPlayerField, ASMHelper.toDescriptor("net.minecraft.entity.player.EntityPlayer"));
            this.tryAddFieldSetter(classNode, "setPlayer", foodStatsPlayerField, ASMHelper.toDescriptor("net.minecraft.entity.player.EntityPlayer"));
            this.tryAddFieldSetter(classNode, "setPrevFoodLevel", ObfHelper.isObfuscated() ? "field_75124_e" : "prevFoodLevel", "I");
            this.tryAddFieldGetter(classNode, "getExhaustion", ObfHelper.isObfuscated() ? "field_75126_c" : "foodExhaustionLevel", "F");
            this.tryAddFieldSetter(classNode, "setExhaustion", ObfHelper.isObfuscated() ? "field_75126_c" : "foodExhaustionLevel", "F");
            this.tryAddFieldSetter(classNode, "setSaturation", ObfHelper.isObfuscated() ? "field_75125_b" : "foodSaturationLevel", "F");
            MethodNode addStatsMethodNode = ASMHelper.findMethodNodeOfClass(classNode, "func_75122_a", "addStats", ASMHelper.toMethodDescriptor("V", "I", "F"));
            if (addStatsMethodNode == null) {
                throw new RuntimeException("FoodStats: addStats(IF)V method not found");
            }
            this.hookFoodStatsAddition(classNode, addStatsMethodNode);
            MethodNode methodNode = ASMHelper.findMethodNodeOfClass(classNode, "func_151686_a", "addStats", ASMHelper.toMethodDescriptor("V", "net.minecraft.item.ItemFood", "net.minecraft.item.ItemStack"));
            if (methodNode == null) {
                throw new RuntimeException("FoodStats: ItemStack-aware addStats method not found");
            }
            this.addItemStackAwareFoodStatsHook(classNode, methodNode, ObfHelper.isObfuscated());
            MethodNode updateMethodNode = ASMHelper.findMethodNodeOfClass(classNode, "func_75118_a", "onUpdate", ASMHelper.toMethodDescriptor("V", "net.minecraft.entity.player.EntityPlayer"));
            if (updateMethodNode == null) {
                throw new RuntimeException("FoodStats: onUpdate method not found");
            }
            this.hookUpdate(classNode, updateMethodNode);
            MethodNode needFoodMethodNode = ASMHelper.findMethodNodeOfClass(classNode, "func_75121_c", "needFood", ASMHelper.toMethodDescriptor("Z", new String[0]));
            if (needFoodMethodNode == null) {
                throw new RuntimeException("FoodStats: needFood method not found");
            }
            this.hookNeedFood(classNode, needFoodMethodNode);
            MethodNode addExhaustionMethod = ASMHelper.findMethodNodeOfClass(classNode, "func_75113_a", "addExhaustion", ASMHelper.toMethodDescriptor("V", "F"));
            if (addExhaustionMethod == null) {
                throw new RuntimeException("FoodStats: addExhaustion method not found");
            }
            this.hookAddExhaustion(classNode, addExhaustionMethod);
            return ASMHelper.writeClassToBytes(classNode, 2);
        }
        return basicClass;
    }

    public void patchEntityPlayerInit(MethodNode method) {
        AbstractInsnNode targetNode = ASMHelper.find(method.instructions, (AbstractInsnNode)new TypeInsnNode(187, ASMHelper.toInternalClassName("net.minecraft.util.FoodStats")));
        if (targetNode == null) {
            throw new RuntimeException("patchEntityPlayerInit: NEW instruction not found");
        }
        while ((targetNode = targetNode.getNext()) != null && targetNode.getOpcode() != 183) {
        }
        if (targetNode == null) {
            throw new RuntimeException("patchEntityPlayerInit: INVOKESPECIAL instruction not found");
        }
        method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(25, 0));
        ((MethodInsnNode)targetNode).desc = ASMHelper.toMethodDescriptor("V", "net.minecraft.entity.player.EntityPlayer");
    }

    public void injectFoodStatsPlayerField(ClassNode classNode) {
        classNode.fields.add(new FieldNode(1, foodStatsPlayerField, ASMHelper.toDescriptor("net.minecraft.entity.player.EntityPlayer"), null, null));
    }

    public void injectFoodStatsConstructor(ClassNode classNode) {
        MethodNode defaultConstructor = ASMHelper.findMethodNodeOfClass(classNode, "<init>", ASMHelper.toMethodDescriptor("V", new String[0]));
        if (defaultConstructor == null) {
            throw new RuntimeException("FoodStats.<init>() not found");
        }
        MethodNode constructor = new MethodNode(1, "<init>", ASMHelper.toMethodDescriptor("V", "net.minecraft.entity.player.EntityPlayer"), null, null);
        constructor.instructions = ASMHelper.cloneInsnList(defaultConstructor.instructions);
        InsnList foodLevelNeedle = new InsnList();
        foodLevelNeedle.add((AbstractInsnNode)new IntInsnNode(16, 20));
        InsnList foodLevelReplacement = new InsnList();
        foodLevelReplacement.add((AbstractInsnNode)new VarInsnNode(25, 0));
        foodLevelReplacement.add((AbstractInsnNode)new MethodInsnNode(184, ASMHelper.toInternalClassName("squeek.applecore.asm.Hooks"), "getMaxHunger", ASMHelper.toMethodDescriptor("I", "net.minecraft.util.FoodStats"), false));
        int numReplacements = ASMHelper.findAndReplaceAll(constructor.instructions, foodLevelNeedle, foodLevelReplacement);
        if (numReplacements < 2) {
            throw new RuntimeException("FoodStats.<init>() replaced " + numReplacements + " (BIPUSH 20) instructions, expected >= 2");
        }
        AbstractInsnNode targetNode = ASMHelper.findFirstInstructionWithOpcode(constructor, 183);
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new FieldInsnNode(181, classNode.name, foodStatsPlayerField, ASMHelper.toDescriptor("net.minecraft.entity.player.EntityPlayer")));
        constructor.instructions.insert(targetNode, toInject);
        classNode.methods.add(constructor);
    }

    public void addItemStackAwareFoodStatsHook(ClassNode classNode, MethodNode method, boolean isObfuscated) {
        String internalFoodStatsName = ASMHelper.toInternalClassName(classNode.name);
        InsnList toInject = new InsnList();
        AbstractInsnNode targetNode = ASMHelper.findFirstInstruction(method);
        LabelNode modifiedFoodValuesStart = new LabelNode();
        LabelNode end = ASMHelper.findEndLabel(method);
        LocalVariableNode modifiedFoodValues = new LocalVariableNode("modifiedFoodValues", ASMHelper.toDescriptor("net.minecraft.util.FoodStats"), null, modifiedFoodValuesStart, end, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(modifiedFoodValues);
        LabelNode prevFoodLevelStart = new LabelNode();
        LocalVariableNode prevFoodLevel = new LocalVariableNode("prevFoodLevel", "I", null, prevFoodLevelStart, end, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(prevFoodLevel);
        LabelNode prevSaturationLevelStart = new LabelNode();
        LocalVariableNode prevSaturationLevel = new LocalVariableNode("prevSaturationLevel", "F", null, prevSaturationLevelStart, end, method.maxLocals);
        ++method.maxLocals;
        method.localVariables.add(prevSaturationLevel);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 2));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, foodStatsPlayerField, ASMHelper.toDescriptor("net.minecraft.entity.player.EntityPlayer")));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, ASMConstants.HOOKS_INTERNAL_CLASS, "onFoodStatsAdded", ASMHelper.toMethodDescriptor("squeek.applecore.api.food.FoodValues", "net.minecraft.util.FoodStats", "net.minecraft.item.ItemFood", "net.minecraft.item.ItemStack", "net.minecraft.entity.player.EntityPlayer"), false));
        toInject.add((AbstractInsnNode)new VarInsnNode(58, modifiedFoodValues.index));
        toInject.add((AbstractInsnNode)modifiedFoodValuesStart);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, ObfHelper.isObfuscated() ? "field_75127_a" : "foodLevel", "I"));
        toInject.add((AbstractInsnNode)new VarInsnNode(54, prevFoodLevel.index));
        toInject.add((AbstractInsnNode)prevFoodLevelStart);
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, ObfHelper.isObfuscated() ? "field_75125_b" : "foodSaturationLevel", "F"));
        toInject.add((AbstractInsnNode)new VarInsnNode(56, prevSaturationLevel.index));
        toInject.add((AbstractInsnNode)prevSaturationLevelStart);
        method.instructions.insertBefore(targetNode, toInject);
        InsnList hungerNeedle = new InsnList();
        hungerNeedle.add((AbstractInsnNode)new VarInsnNode(25, 1));
        hungerNeedle.add((AbstractInsnNode)new VarInsnNode(25, 2));
        hungerNeedle.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.item.ItemFood"), ObfHelper.isObfuscated() ? "func_150905_g" : "getHealAmount", ASMHelper.toMethodDescriptor("I", ASMHelper.toDescriptor("net.minecraft.item.ItemStack")), false));
        InsnList hungerReplacement = new InsnList();
        hungerReplacement.add((AbstractInsnNode)new VarInsnNode(25, modifiedFoodValues.index));
        hungerReplacement.add((AbstractInsnNode)new FieldInsnNode(180, ASMHelper.toInternalClassName("squeek.applecore.api.food.FoodValues"), "hunger", "I"));
        InsnList saturationNeedle = new InsnList();
        saturationNeedle.add((AbstractInsnNode)new VarInsnNode(25, 1));
        saturationNeedle.add((AbstractInsnNode)new VarInsnNode(25, 2));
        saturationNeedle.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.item.ItemFood"), ObfHelper.isObfuscated() ? "func_150906_h" : "getSaturationModifier", ASMHelper.toMethodDescriptor("F", ASMHelper.toDescriptor("net.minecraft.item.ItemStack")), false));
        InsnList saturationReplacement = new InsnList();
        saturationReplacement.add((AbstractInsnNode)new VarInsnNode(25, modifiedFoodValues.index));
        saturationReplacement.add((AbstractInsnNode)new FieldInsnNode(180, ASMHelper.toInternalClassName("squeek.applecore.api.food.FoodValues"), "saturationModifier", "F"));
        ASMHelper.findAndReplaceAll(method.instructions, hungerNeedle, hungerReplacement);
        ASMHelper.findAndReplaceAll(method.instructions, saturationNeedle, saturationReplacement);
        targetNode = ASMHelper.findLastInstructionWithOpcode(method, 177);
        toInject.clear();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 2));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, modifiedFoodValues.index));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, ObfHelper.isObfuscated() ? "field_75127_a" : "foodLevel", "I"));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, prevFoodLevel.index));
        toInject.add((AbstractInsnNode)new InsnNode(100));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, ObfHelper.isObfuscated() ? "field_75125_b" : "foodSaturationLevel", "F"));
        toInject.add((AbstractInsnNode)new VarInsnNode(23, prevSaturationLevel.index));
        toInject.add((AbstractInsnNode)new InsnNode(102));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, internalFoodStatsName, foodStatsPlayerField, ASMHelper.toDescriptor("net.minecraft.entity.player.EntityPlayer")));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, ASMConstants.HOOKS_INTERNAL_CLASS, "onPostFoodStatsAdded", ASMHelper.toMethodDescriptor("V", "net.minecraft.util.FoodStats", "net.minecraft.item.ItemFood", "net.minecraft.item.ItemStack", "squeek.applecore.api.food.FoodValues", "I", "F", "net.minecraft.entity.player.EntityPlayer"), false));
        method.instructions.insertBefore(targetNode, toInject);
    }

    private void hookFoodStatsAddition(ClassNode classNode, MethodNode method) {
        AbstractInsnNode targetNode = ASMHelper.findFirstInstruction(method);
        LabelNode ifCanceled = new LabelNode();
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new FieldInsnNode(180, ASMHelper.toInternalClassName(classNode.name), foodStatsPlayerField, ASMHelper.toDescriptor("net.minecraft.entity.player.EntityPlayer")));
        toInject.add((AbstractInsnNode)new TypeInsnNode(187, ASMHelper.toInternalClassName("squeek.applecore.api.food.FoodValues")));
        toInject.add((AbstractInsnNode)new InsnNode(89));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(23, 2));
        toInject.add((AbstractInsnNode)new MethodInsnNode(183, ASMHelper.toInternalClassName("squeek.applecore.api.food.FoodValues"), "<init>", ASMHelper.toMethodDescriptor("V", "I", "F"), false));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, ASMConstants.HOOKS_INTERNAL_CLASS, "fireFoodStatsAdditionEvent", ASMHelper.toMethodDescriptor("Z", "net.minecraft.entity.player.EntityPlayer", "squeek.applecore.api.food.FoodValues"), false));
        toInject.add((AbstractInsnNode)new JumpInsnNode(154, ifCanceled));
        method.instructions.insertBefore(targetNode, toInject);
        targetNode = ASMHelper.findLastInstructionWithOpcode(method, 177);
        method.instructions.insertBefore(targetNode, (AbstractInsnNode)ifCanceled);
        InsnList needle = new InsnList();
        needle.add((AbstractInsnNode)new IntInsnNode(16, 20));
        InsnList replacement = new InsnList();
        replacement.add((AbstractInsnNode)new VarInsnNode(25, 0));
        replacement.add((AbstractInsnNode)new MethodInsnNode(184, ASMHelper.toInternalClassName("squeek.applecore.asm.Hooks"), "getMaxHunger", ASMHelper.toMethodDescriptor("I", "net.minecraft.util.FoodStats"), false));
        ASMHelper.findAndReplaceAll(method.instructions, needle, replacement);
    }

    private void hookUpdate(ClassNode classNode, MethodNode updateMethodNode) {
        LabelNode ifSkipReturn = new LabelNode();
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, ASMHelper.toInternalClassName("squeek.applecore.asm.Hooks"), "onAppleCoreFoodStatsUpdate", ASMHelper.toMethodDescriptor("Z", "net.minecraft.util.FoodStats", "net.minecraft.entity.player.EntityPlayer"), false));
        toInject.add((AbstractInsnNode)new JumpInsnNode(153, ifSkipReturn));
        toInject.add((AbstractInsnNode)new LabelNode());
        toInject.add((AbstractInsnNode)new InsnNode(177));
        toInject.add((AbstractInsnNode)ifSkipReturn);
        updateMethodNode.instructions.insertBefore(ASMHelper.findFirstInstruction(updateMethodNode), toInject);
    }

    private void hookNeedFood(ClassNode classNode, MethodNode needFoodMethodNode) {
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, ASMHelper.toInternalClassName("squeek.applecore.asm.Hooks"), "needFood", ASMHelper.toMethodDescriptor("Z", "net.minecraft.util.FoodStats"), false));
        toInject.add((AbstractInsnNode)new InsnNode(172));
        needFoodMethodNode.instructions.clear();
        needFoodMethodNode.instructions.insert(toInject);
    }

    private void hookAddExhaustion(ClassNode classNode, MethodNode addExhaustionMethodNode) {
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(23, 1));
        toInject.add((AbstractInsnNode)new MethodInsnNode(184, ASMHelper.toInternalClassName("squeek.applecore.asm.Hooks"), "onExhaustionAdded", ASMHelper.toMethodDescriptor("F", "net.minecraft.util.FoodStats", "F"), false));
        toInject.add((AbstractInsnNode)new VarInsnNode(56, 1));
        addExhaustionMethodNode.instructions.insertBefore(ASMHelper.findFirstInstruction(addExhaustionMethodNode), toInject);
    }

    private boolean tryAddFieldGetter(ClassNode classNode, String methodName, String fieldName, String fieldDescriptor) {
        String methodDescriptor = ASMHelper.toMethodDescriptor(fieldDescriptor, new String[0]);
        if (ASMHelper.findMethodNodeOfClass(classNode, methodName, methodDescriptor) != null) {
            return false;
        }
        MethodVisitor mv = classNode.visitMethod(1, methodName, methodDescriptor, null, null);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, ASMHelper.toInternalClassName(classNode.name), fieldName, fieldDescriptor);
        mv.visitInsn(Type.getType((String)fieldDescriptor).getOpcode(172));
        mv.visitMaxs(0, 0);
        return true;
    }

    private boolean tryAddFieldSetter(ClassNode classNode, String methodName, String fieldName, String fieldDescriptor) {
        String methodDescriptor = ASMHelper.toMethodDescriptor("V", fieldDescriptor);
        if (ASMHelper.findMethodNodeOfClass(classNode, methodName, methodDescriptor) != null) {
            return false;
        }
        MethodVisitor mv = classNode.visitMethod(1, methodName, methodDescriptor, null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(Type.getType((String)fieldDescriptor).getOpcode(21), 1);
        mv.visitFieldInsn(181, ASMHelper.toInternalClassName(classNode.name), fieldName, fieldDescriptor);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        return true;
    }
}

