/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.tracking;

import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.tracking.FoodList;

public final class ProgressInfo {
    public final int foodsEaten;

    ProgressInfo(FoodList foodList) {
        this.foodsEaten = (int)foodList.getEatenFoods().stream().filter(food -> SOLCarrotConfig.shouldCount(food.item)).count();
    }

    public boolean hasReachedMax() {
        return this.foodsEaten >= SOLCarrotConfig.highestMilestone();
    }

    public int nextMilestone() {
        return this.hasReachedMax() ? -1 : SOLCarrotConfig.milestone(this.milestonesAchieved());
    }

    public int foodsUntilNextMilestone() {
        return this.nextMilestone() - this.foodsEaten;
    }

    public int milestonesAchieved() {
        return (int)SOLCarrotConfig.getMilestones().stream().filter(milestone -> this.foodsEaten >= milestone).count();
    }
}

