/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.client;

import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.lib.Localization;
import com.cazsius.solcarrot.tracking.FoodList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="solcarrot")
public final class TooltipHandler {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        if (!SOLCarrotConfig.isFoodTooltipEnabled()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (player == null) {
            return;
        }
        Item food = event.getItemStack().func_77973_b();
        if (!food.func_219971_r()) {
            return;
        }
        FoodList foodList = FoodList.get(player);
        boolean hasBeenEaten = foodList.hasEaten(food);
        boolean isAllowed = SOLCarrotConfig.isAllowed(food);
        boolean isHearty = SOLCarrotConfig.isHearty(food);
        List tooltip = event.getToolTip();
        if (!isAllowed) {
            if (hasBeenEaten) {
                tooltip.add(TooltipHandler.localizedTooltip("disabled.eaten", TextFormatting.DARK_RED));
            }
            String key = SOLCarrotConfig.hasWhitelist() ? "whitelist" : "blacklist";
            tooltip.add(TooltipHandler.localizedTooltip("disabled." + key, TextFormatting.DARK_GRAY));
        } else if (isHearty) {
            if (hasBeenEaten) {
                tooltip.add(TooltipHandler.localizedTooltip("hearty.eaten", TextFormatting.DARK_GREEN));
            } else {
                tooltip.add(TooltipHandler.localizedTooltip("hearty.not_eaten", TextFormatting.DARK_AQUA));
            }
        } else {
            if (hasBeenEaten) {
                tooltip.add(TooltipHandler.localizedTooltip("cheap.eaten", TextFormatting.DARK_RED));
            }
            tooltip.add(TooltipHandler.localizedTooltip("cheap", TextFormatting.DARK_GRAY));
        }
    }

    private static ITextComponent localizedTooltip(String path, TextFormatting color) {
        Style style = new Style().func_150238_a(color);
        return Localization.localizedComponent("tooltip", path, new Object[0]).func_150255_a(style);
    }

    private TooltipHandler() {
    }
}

