/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.client.gui;

import com.cazsius.solcarrot.SOLCarrot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
final class PageFlipButton
extends Button {
    private static final ResourceLocation texture = SOLCarrot.resourceLocation("textures/gui/food_book.png");
    public static final int width = 23;
    public static final int height = 13;
    private final Direction direction;
    private final Pageable pageable;

    PageFlipButton(int x, int y, Direction direction, Pageable pageable) {
        super(x, y, 23, 13, "", button -> ((PageFlipButton)button).changePage());
        this.direction = direction;
        this.pageable = pageable;
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        boolean isHovered;
        if (!this.visible) {
            return;
        }
        int textureX = 0;
        boolean bl = isHovered = this.x <= mouseX && mouseX < this.x + 23 && this.y <= mouseY && mouseY < this.y + 13;
        if (isHovered) {
            textureX += 23;
        }
        int textureY = this.direction == Direction.FORWARD ? 192 : 205;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.blit(this.x, this.y, textureX, textureY, 23, 13);
    }

    public void updateState() {
        this.visible = this.pageable.isWithinRange(this.pageable.getCurrentPageNumber() + this.direction.distance);
    }

    private void changePage() {
        this.pageable.switchToPage(this.pageable.getCurrentPageNumber() + this.direction.distance);
    }

    static interface Pageable {
        public void switchToPage(int var1);

        public int getCurrentPageNumber();

        public boolean isWithinRange(int var1);
    }

    static enum Direction {
        FORWARD(1),
        BACKWARD(-1);

        final int distance;

        private Direction(int distance) {
            this.distance = distance;
        }
    }
}

