/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.tracking;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class FoodInstance {
    public final Item item;

    public FoodInstance(Item item) {
        this.item = item;
        if (!item.func_219971_r()) {
            throw new RuntimeException("Attempting to construct FoodInstance from non-food item.");
        }
    }

    @Nullable
    public static FoodInstance decode(String encoded) {
        ResourceLocation name = new ResourceLocation(encoded);
        return Optional.ofNullable(ForgeRegistries.ITEMS.getValue(name)).filter(Item::func_219971_r).map(FoodInstance::new).orElse(null);
    }

    @Nullable
    public String encode() {
        return Optional.ofNullable(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.item)).map(ResourceLocation::toString).orElse(null);
    }

    public int hashCode() {
        return this.item.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FoodInstance)) {
            return false;
        }
        FoodInstance other = (FoodInstance)obj;
        return this.item.equals(other.item);
    }

    public Food getFood() {
        return Objects.requireNonNull(this.item.func_219967_s());
    }

    public Item getItem() {
        return this.item;
    }
}

