/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot;

import com.cazsius.solcarrot.tracking.CapabilityHandler;
import com.cazsius.solcarrot.tracking.FoodList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="solcarrot", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class SOLCarrotConfig {
    public static final Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    private static String localizationPath(String path) {
        return "config.solcarrot." + path;
    }

    public static void setUp() {
        ModLoadingContext context = ModLoadingContext.get();
        context.registerConfig(ModConfig.Type.SERVER, SERVER_SPEC);
        context.registerConfig(ModConfig.Type.CLIENT, CLIENT_SPEC);
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfig.Reloading event) {
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer == null) {
            return;
        }
        PlayerList players = currentServer.func_184103_al();
        for (PlayerEntity player : players.func_181057_v()) {
            FoodList.get(player).invalidateProgressInfo();
            CapabilityHandler.syncFoodList(player);
        }
    }

    public static int getBaseHearts() {
        return (Integer)SOLCarrotConfig.SERVER.baseHearts.get();
    }

    public static int getHeartsPerMilestone() {
        return (Integer)SOLCarrotConfig.SERVER.heartsPerMilestone.get();
    }

    public static List<Integer> getMilestones() {
        return new ArrayList<Integer>((Collection)SOLCarrotConfig.SERVER.milestones.get());
    }

    public static List<String> getBlacklist() {
        return new ArrayList<String>((Collection)SOLCarrotConfig.SERVER.blacklist.get());
    }

    public static List<String> getWhitelist() {
        return new ArrayList<String>((Collection)SOLCarrotConfig.SERVER.whitelist.get());
    }

    public static int getMinimumFoodValue() {
        return (Integer)SOLCarrotConfig.SERVER.minimumFoodValue.get();
    }

    public static boolean shouldResetOnDeath() {
        return (Boolean)SOLCarrotConfig.SERVER.shouldResetOnDeath.get();
    }

    public static boolean limitProgressionToSurvival() {
        return (Boolean)SOLCarrotConfig.SERVER.limitProgressionToSurvival.get();
    }

    public static boolean shouldPlayMilestoneSounds() {
        return (Boolean)SOLCarrotConfig.CLIENT.shouldPlayMilestoneSounds.get();
    }

    public static boolean shouldSpawnIntermediateParticles() {
        return (Boolean)SOLCarrotConfig.CLIENT.shouldSpawnIntermediateParticles.get();
    }

    public static boolean shouldSpawnMilestoneParticles() {
        return (Boolean)SOLCarrotConfig.CLIENT.shouldSpawnMilestoneParticles.get();
    }

    public static boolean isFoodTooltipEnabled() {
        return (Boolean)SOLCarrotConfig.CLIENT.isFoodTooltipEnabled.get();
    }

    public static boolean shouldShowProgressAboveHotbar() {
        return (Boolean)SOLCarrotConfig.CLIENT.shouldShowProgressAboveHotbar.get();
    }

    public static boolean shouldShowUneatenFoods() {
        return (Boolean)SOLCarrotConfig.CLIENT.shouldShowUneatenFoods.get();
    }

    public static int milestone(int i) {
        return (Integer)((List)SOLCarrotConfig.SERVER.milestones.get()).get(i);
    }

    public static int getMilestoneCount() {
        return ((List)SOLCarrotConfig.SERVER.milestones.get()).size();
    }

    public static int highestMilestone() {
        return SOLCarrotConfig.milestone(SOLCarrotConfig.getMilestoneCount() - 1);
    }

    public static boolean hasWhitelist() {
        return !((List)SOLCarrotConfig.SERVER.whitelist.get()).isEmpty();
    }

    public static boolean isAllowed(Item food) {
        String id = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)food)).toString();
        if (SOLCarrotConfig.hasWhitelist()) {
            return SOLCarrotConfig.matchesAnyPattern(id, (Collection)SOLCarrotConfig.SERVER.whitelist.get());
        }
        return !SOLCarrotConfig.matchesAnyPattern(id, (Collection)SOLCarrotConfig.SERVER.blacklist.get());
    }

    public static boolean shouldCount(Item food) {
        return SOLCarrotConfig.isHearty(food) && SOLCarrotConfig.isAllowed(food);
    }

    public static boolean isHearty(Item food) {
        Food foodInfo = food.func_219967_s();
        if (foodInfo == null) {
            return false;
        }
        return foodInfo.func_221466_a() >= (Integer)SOLCarrotConfig.SERVER.minimumFoodValue.get();
    }

    private static boolean matchesAnyPattern(String query, Collection<? extends String> patterns) {
        for (String string : patterns) {
            StringBuilder pattern = new StringBuilder(string.length());
            for (String part : string.split("\\*", -1)) {
                if (!part.isEmpty()) {
                    pattern.append(Pattern.quote(part));
                }
                pattern.append(".*");
            }
            pattern.delete(pattern.length() - 2, pattern.length());
            if (!Pattern.matches(pattern.toString(), query)) continue;
            return true;
        }
        return false;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER = (Server)specPair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT = (Client)specPair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue shouldPlayMilestoneSounds;
        public final ForgeConfigSpec.BooleanValue shouldSpawnIntermediateParticles;
        public final ForgeConfigSpec.BooleanValue shouldSpawnMilestoneParticles;
        public final ForgeConfigSpec.BooleanValue isFoodTooltipEnabled;
        public final ForgeConfigSpec.BooleanValue shouldShowProgressAboveHotbar;
        public final ForgeConfigSpec.BooleanValue shouldShowUneatenFoods;

        Client(ForgeConfigSpec.Builder builder) {
            builder.push("milestone celebration");
            this.shouldPlayMilestoneSounds = builder.translation(SOLCarrotConfig.localizationPath("should_play_milestone_sounds")).comment("If true, reaching a new milestone plays a ding sound.").define("shouldPlayMilestoneSounds", true);
            this.shouldSpawnIntermediateParticles = builder.translation(SOLCarrotConfig.localizationPath("should_spawn_intermediate_particles")).comment("If true, trying a new food spawns particles.").define("shouldSpawnIntermediateParticles", true);
            this.shouldSpawnMilestoneParticles = builder.translation(SOLCarrotConfig.localizationPath("should_spawn_milestone_particles")).comment("If true, reaching a new milestone spawns particles.").define("shouldSpawnMilestoneParticles", true);
            builder.pop();
            builder.push("miscellaneous");
            this.isFoodTooltipEnabled = builder.translation(SOLCarrotConfig.localizationPath("is_food_tooltip_enabled")).comment("If true, foods indicate in their tooltips whether or not they have been eaten.").define("isFoodTooltipEnabled", true);
            this.shouldShowProgressAboveHotbar = builder.translation(SOLCarrotConfig.localizationPath("should_show_progress_above_hotbar")).comment("Whether the messages notifying you of reaching new milestones should be displayed above the hotbar or in chat.").define("shouldShowProgressAboveHotbar", true);
            this.shouldShowUneatenFoods = builder.translation(SOLCarrotConfig.localizationPath("should_show_uneaten_foods")).comment("If true, the food book also lists foods that you haven't eaten, in addition to the ones you have.").define("shouldShowUneatenFoods", true);
            builder.pop();
        }
    }

    public static class Server {
        public final ForgeConfigSpec.IntValue baseHearts;
        public final ForgeConfigSpec.IntValue heartsPerMilestone;
        public final ForgeConfigSpec.ConfigValue<List<? extends Integer>> milestones;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> whitelist;
        public final ForgeConfigSpec.IntValue minimumFoodValue;
        public final ForgeConfigSpec.BooleanValue shouldResetOnDeath;
        public final ForgeConfigSpec.BooleanValue limitProgressionToSurvival;

        Server(ForgeConfigSpec.Builder builder) {
            builder.push("milestones");
            this.baseHearts = builder.translation(SOLCarrotConfig.localizationPath("base_hearts")).comment("Number of hearts you start out with.").defineInRange("baseHearts", 10, 0, 1000);
            this.heartsPerMilestone = builder.translation(SOLCarrotConfig.localizationPath("hearts_per_milestone")).comment("Number of hearts you gain for reaching a new milestone.").defineInRange("heartsPerMilestone", 2, 0, 1000);
            this.milestones = builder.translation(SOLCarrotConfig.localizationPath("milestones")).comment("A list of numbers of unique foods you need to eat to unlock each milestone, in ascending order.").defineList("milestones", (List)Lists.newArrayList((Object[])new Integer[]{5, 10, 15, 20, 25}), e -> e instanceof Integer);
            builder.pop();
            builder.push("filtering");
            this.blacklist = builder.translation(SOLCarrotConfig.localizationPath("blacklist")).comment("Foods in this list won't affect the player's health nor show up in the food book.").defineList("blacklist", (List)Lists.newArrayList(), e -> e instanceof String);
            this.whitelist = builder.translation(SOLCarrotConfig.localizationPath("whitelist")).comment("When this list contains anything, the blacklist is ignored and instead only foods from here count.").defineList("whitelist", (List)Lists.newArrayList(), e -> e instanceof String);
            this.minimumFoodValue = builder.translation(SOLCarrotConfig.localizationPath("minimum_food_value")).comment("The minimum hunger value foods need to provide in order to count for milestones, in half drumsticks.").defineInRange("minimumFoodValue", 1, 0, 1000);
            builder.pop();
            builder.push("miscellaneous");
            this.shouldResetOnDeath = builder.translation(SOLCarrotConfig.localizationPath("reset_on_death")).comment("Whether or not to reset the food list on death, effectively losing all bonus hearts.").define("resetOnDeath", false);
            this.limitProgressionToSurvival = builder.translation(SOLCarrotConfig.localizationPath("limit_progression_to_survival")).comment("If true, eating foods outside of survival mode (e.g. creative/adventure) is not tracked and thus does not contribute towards progression.").define("limitProgressionToSurvival", false);
            builder.pop();
        }
    }
}

