/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.client.gui;

import com.cazsius.solcarrot.SOLCarrot;
import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.client.gui.ConfigInfoPage;
import com.cazsius.solcarrot.client.gui.FoodData;
import com.cazsius.solcarrot.client.gui.ItemListPage;
import com.cazsius.solcarrot.client.gui.Page;
import com.cazsius.solcarrot.client.gui.PageFlipButton;
import com.cazsius.solcarrot.client.gui.StatListPage;
import com.cazsius.solcarrot.client.gui.elements.UIElement;
import com.cazsius.solcarrot.client.gui.elements.UIImage;
import com.cazsius.solcarrot.client.gui.elements.UILabel;
import com.cazsius.solcarrot.lib.Localization;
import com.cazsius.solcarrot.tracking.FoodList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class FoodBookScreen
extends Screen
implements PageFlipButton.Pageable {
    private static final ResourceLocation texture = SOLCarrot.resourceLocation("textures/gui/food_book.png");
    private static final UIImage.Image bookImage = new UIImage.Image(texture, new Rectangle(0, 0, 186, 192));
    static final UIImage.Image carrotImage = new UIImage.Image(texture, new Rectangle(0, 240, 16, 16));
    static final UIImage.Image spiderEyeImage = new UIImage.Image(texture, new Rectangle(16, 240, 16, 16));
    static final UIImage.Image heartImage = new UIImage.Image(texture, new Rectangle(0, 224, 15, 15));
    static final UIImage.Image drumstickImage = new UIImage.Image(texture, new Rectangle(16, 224, 15, 15));
    static final UIImage.Image blacklistImage = new UIImage.Image(texture, new Rectangle(32, 224, 15, 15));
    static final UIImage.Image whitelistImage = new UIImage.Image(texture, new Rectangle(48, 224, 15, 15));
    static final Color fullBlack = Color.BLACK;
    static final Color lessBlack = new Color(0, 0, 0, 128);
    static final Color leastBlack = new Color(0, 0, 0, 64);
    private final List<UIElement> elements = new ArrayList<UIElement>();
    private UIImage background;
    private UILabel pageNumberLabel;
    private PageFlipButton nextPageButton;
    private PageFlipButton prevPageButton;
    private PlayerEntity player;
    private FoodData foodData;
    private final List<Page> pages = new ArrayList<Page>();
    private int currentPageNumber = 0;

    public static void open(PlayerEntity player) {
        Minecraft.func_71410_x().func_147108_a((Screen)new FoodBookScreen(player));
    }

    public FoodBookScreen(PlayerEntity player) {
        super((ITextComponent)new StringTextComponent(""));
        this.player = player;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.foodData = new FoodData(FoodList.get(this.player));
        this.background = new UIImage(bookImage);
        this.background.setCenterX(this.field_230708_k_ / 2);
        this.background.setCenterY(this.field_230709_l_ / 2);
        this.elements.clear();
        this.pageNumberLabel = new UILabel("1");
        this.pageNumberLabel.setCenterX(this.background.getCenterX());
        this.pageNumberLabel.setMinY(this.background.getMinY() + 156);
        this.elements.add(this.pageNumberLabel);
        this.initPages();
        int pageFlipButtonSpacing = 50;
        this.prevPageButton = (PageFlipButton)this.func_230480_a_((Widget)new PageFlipButton(this.background.getCenterX() - pageFlipButtonSpacing / 2 - 23, this.background.getMinY() + 152, PageFlipButton.Direction.BACKWARD, this));
        this.nextPageButton = (PageFlipButton)this.func_230480_a_((Widget)new PageFlipButton(this.background.getCenterX() + pageFlipButtonSpacing / 2, this.background.getMinY() + 152, PageFlipButton.Direction.FORWARD, this));
        this.updateButtonVisibility();
    }

    private void initPages() {
        this.pages.clear();
        this.pages.add(new StatListPage(this.foodData, this.background.frame));
        this.pages.add(new ConfigInfoPage(this.foodData, this.background.frame));
        this.addPages("eaten_foods", this.foodData.eatenFoods);
        if (SOLCarrotConfig.shouldShowUneatenFoods()) {
            this.addPages("uneaten_foods", this.foodData.uneatenFoods);
        }
    }

    private void addPages(String headerLocalizationPath, List<Item> items) {
        String header = Localization.localized("gui", "food_book." + headerLocalizationPath, items.size());
        List<ItemStack> stacks = items.stream().map(ItemStack::new).collect(Collectors.toList());
        this.pages.addAll(ItemListPage.pages(this.background.frame, header, stacks));
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrices);
        UIElement.render(matrices, this.background, mouseX, mouseY);
        super.func_230430_a_(matrices, mouseX, mouseY, partialTicks);
        if (!this.pages.isEmpty()) {
            UIElement.render(matrices, this.elements, mouseX, mouseY);
            UIElement.render(matrices, this.pages.get(this.currentPageNumber), mouseX, mouseY);
        }
    }

    @Override
    public void switchToPage(int pageNumber) {
        if (!this.isWithinRange(pageNumber)) {
            return;
        }
        this.currentPageNumber = pageNumber;
        this.updateButtonVisibility();
        this.pageNumberLabel.text = "" + (this.currentPageNumber + 1);
    }

    @Override
    public int getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    @Override
    public boolean isWithinRange(int pageNumber) {
        return pageNumber >= 0 && pageNumber < this.pages.size();
    }

    private void updateButtonVisibility() {
        this.prevPageButton.updateState();
        this.nextPageButton.updateState();
    }
}

