/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.command;

import com.cazsius.solcarrot.lib.Localization;
import com.cazsius.solcarrot.tracking.CapabilityHandler;
import com.cazsius.solcarrot.tracking.FoodList;
import com.cazsius.solcarrot.tracking.ProgressInfo;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="solcarrot")
public final class FoodListCommand {
    private static final String name = "foodlist";

    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)name).then(FoodListCommand.withPlayerArgumentOrSender(Commands.func_197057_a((String)"size"), FoodListCommand::showFoodListSize))).then(FoodListCommand.withPlayerArgumentOrSender(Commands.func_197057_a((String)"sync"), FoodListCommand::syncFoodList))).then(FoodListCommand.withPlayerArgumentOrSender(Commands.func_197057_a((String)"clear"), FoodListCommand::clearFoodList)));
    }

    static ArgumentBuilder<CommandSource, ?> withPlayerArgumentOrSender(ArgumentBuilder<CommandSource, ?> base, CommandWithPlayer command) {
        String target = "target";
        return base.executes(context -> command.run((CommandContext<CommandSource>)context, (PlayerEntity)((CommandSource)context.getSource()).func_197035_h())).then(Commands.func_197056_a((String)target, (ArgumentType)EntityArgument.func_197096_c()).executes(context -> command.run((CommandContext<CommandSource>)context, (PlayerEntity)EntityArgument.func_197089_d((CommandContext)context, (String)target))));
    }

    static int showFoodListSize(CommandContext<CommandSource> context, PlayerEntity target) {
        ProgressInfo progressInfo = FoodList.get(target).getProgressInfo();
        IFormattableTextComponent progressDesc = FoodListCommand.localizedQuantityComponent("size.desc.foods_eaten", progressInfo.foodsEaten);
        FoodListCommand.sendFeedback((CommandSource)context.getSource(), progressDesc);
        IFormattableTextComponent milestoneDesc = progressInfo.hasReachedMax() ? FoodListCommand.localizedComponent("size.desc.milestone.max", new Object[0]) : FoodListCommand.localizedComponent("size.desc.milestone.more", progressInfo.foodsUntilNextMilestone());
        FoodListCommand.sendFeedback((CommandSource)context.getSource(), milestoneDesc);
        return 1;
    }

    static int syncFoodList(CommandContext<CommandSource> context, PlayerEntity target) {
        CapabilityHandler.syncFoodList(target);
        FoodListCommand.sendFeedback((CommandSource)context.getSource(), FoodListCommand.localizedComponent("sync.success", new Object[0]));
        return 1;
    }

    static int clearFoodList(CommandContext<CommandSource> context, PlayerEntity target) {
        boolean isOp = ((CommandSource)context.getSource()).func_197034_c(2);
        boolean isTargetingSelf = FoodListCommand.isTargetingSelf(context, target);
        if (!isOp && isTargetingSelf) {
            throw new CommandException((ITextComponent)FoodListCommand.localizedComponent("no_permissions", new Object[0]));
        }
        FoodList.get(target).clearFood();
        CapabilityHandler.syncFoodList(target);
        IFormattableTextComponent feedback = FoodListCommand.localizedComponent("clear.success", new Object[0]);
        FoodListCommand.sendFeedback((CommandSource)context.getSource(), feedback);
        if (!isTargetingSelf) {
            target.func_146105_b((ITextComponent)FoodListCommand.applyFeedbackStyle(feedback), true);
        }
        return 1;
    }

    static void sendFeedback(CommandSource source, IFormattableTextComponent message) {
        source.func_197030_a((ITextComponent)FoodListCommand.applyFeedbackStyle(message), true);
    }

    private static IFormattableTextComponent applyFeedbackStyle(IFormattableTextComponent text) {
        return text.func_240700_a_(style -> style.func_240721_b_(TextFormatting.DARK_AQUA));
    }

    static boolean isTargetingSelf(CommandContext<CommandSource> context, PlayerEntity target) {
        return target.func_70028_i(Objects.requireNonNull(((CommandSource)context.getSource()).func_197022_f()));
    }

    static IFormattableTextComponent localizedComponent(String path, Object ... args) {
        return Localization.localizedComponent("command", FoodListCommand.localizationPath(path), args);
    }

    static IFormattableTextComponent localizedQuantityComponent(String path, int number) {
        return Localization.localizedQuantityComponent("command", FoodListCommand.localizationPath(path), number);
    }

    static String localizationPath(String path) {
        return "foodlist." + path;
    }

    @FunctionalInterface
    private static interface CommandWithPlayer {
        public int run(CommandContext<CommandSource> var1, PlayerEntity var2) throws CommandSyntaxException;
    }
}

