/*
 * Decompiled with CFR 0.152.
 */
package jihuayu.spawnvillage.handler;

import java.util.Objects;
import jihuayu.spawnvillage.ModMain;
import jihuayu.spawnvillage.ModMainConfig;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SpawnHandler {
    @SubscribeEvent
    public static void onCreateSpawnPosition(WorldEvent.CreateSpawnPosition event) {
        ModMainConfig.refresh();
        IWorld world = event.getWorld();
        if (world instanceof ServerWorld) {
            if (ModMainConfig.biome.isEmpty()) {
                BlockPos pos = ((ServerWorld)world).func_211157_a(ModMainConfig.struct, new BlockPos(0, 60, 0), 1000, false);
                if (pos != null) {
                    for (int i = 40; i < 100; ++i) {
                        BlockState block = world.func_180495_p(pos.func_177982_a(0, i, 0));
                        if (!block.func_196958_f()) continue;
                        ((ServerWorld)world).func_175652_B(pos.func_177982_a(0, i, 0));
                        event.setCanceled(true);
                        return;
                    }
                } else {
                    ModMain.LOGGER.error(String.format("Could found %s in range 1000m", ModMainConfig.struct));
                }
            } else {
                BlockPos pos = SpawnHandler.findBiome((ServerWorld)world, ModMainConfig.biome, new BlockPos(0, 0, 0), 0);
                if (pos != null) {
                    for (int i = 40; i < 100; ++i) {
                        BlockState block = world.func_180495_p(pos.func_177982_a(0, i, 0));
                        if (!block.func_196958_f()) continue;
                        ((ServerWorld)world).func_175652_B(pos.func_177982_a(0, i, 0));
                        event.setCanceled(true);
                        return;
                    }
                } else {
                    ModMain.LOGGER.error(String.format("Could found %s in range %dm", ModMainConfig.biome, ModMainConfig.biomeSearchRange));
                }
            }
        }
    }

    private static BlockPos findBiome(ServerWorld world, String name, BlockPos pos, int step) {
        if (step > ModMainConfig.biomeSearchRange / ModMainConfig.biomeSearchStepLong) {
            return null;
        }
        if (Objects.equals(world.func_226691_t_(pos).getRegistryName(), new ResourceLocation(name))) {
            return pos;
        }
        BlockPos ans = SpawnHandler.findBiome(world, name, pos.func_177982_a(0, 0, ModMainConfig.biomeSearchStepLong), step + 1);
        if (ans != null) {
            return ans;
        }
        ans = SpawnHandler.findBiome(world, name, pos.func_177982_a(ModMainConfig.biomeSearchStepLong, 0, 0), step + 1);
        return ans;
    }
}

