/*
 * Decompiled with CFR 0.152.
 */
package baguchan.speedillusion.client;

import baguchan.speedillusion.SpeedIllusion;
import baguchan.speedillusion.capability.IllusionCapability;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="speedillusion", value={Dist.CLIENT})
public class ClientIllusionEventHandler {
    @SubscribeEvent
    public static void onRenderEvent(RenderLivingEvent.Pre event) {
        LivingEntity entityIn = event.getEntity();
        MatrixStack matrixStackIn = event.getMatrixStack();
        float partialTicks = event.getPartialRenderTick();
        if (entityIn instanceof LivingEntity) {
            entityIn.getCapability(SpeedIllusion.ILLUSION_CAP).ifPresent(illusion -> {
                double ownerInZ;
                double ownerInY;
                double ownerInX = entityIn.func_226277_ct_() - (double)illusion.shadowX;
                if (ClientIllusionEventHandler.speedMag(new Vec3d(ownerInX, ownerInY = entityIn.func_226278_cu_() - (double)illusion.shadowY, ownerInZ = entityIn.func_226281_cx_() - (double)illusion.shadowZ)) > 1.25 || entityIn instanceof VexEntity && ((VexEntity)entityIn).func_190647_dj()) {
                    ClientIllusionEventHandler.renderFastIllusion(event, illusion, entityIn, matrixStackIn, partialTicks);
                }
            });
        }
    }

    private static void renderFastIllusion(RenderLivingEvent.Pre event, IllusionCapability illusion, LivingEntity entityIn, MatrixStack matrixStackIn, float partialTicks) {
        Direction direction;
        double shadowX = illusion.prevShadowX + (illusion.shadowX - illusion.prevShadowX) * partialTicks;
        double shadowY = illusion.prevShadowY + (illusion.shadowY - illusion.prevShadowY) * partialTicks;
        double shadowZ = illusion.prevShadowZ + (illusion.shadowZ - illusion.prevShadowZ) * partialTicks;
        double shadowX2 = illusion.prevShadowX2 + (illusion.shadowX2 - illusion.prevShadowX2) * partialTicks;
        double shadowY2 = illusion.prevShadowY2 + (illusion.shadowY2 - illusion.prevShadowY2) * partialTicks;
        double shadowZ2 = illusion.prevShadowZ2 + (illusion.shadowZ2 - illusion.prevShadowZ2) * partialTicks;
        double ownerInX = entityIn.field_70169_q + (entityIn.func_226277_ct_() - entityIn.field_70169_q) * (double)partialTicks;
        double ownerInY = entityIn.field_70167_r + (entityIn.func_226278_cu_() - entityIn.field_70167_r) * (double)partialTicks;
        double ownerInZ = entityIn.field_70166_s + (entityIn.func_226281_cx_() - entityIn.field_70166_s) * (double)partialTicks;
        double deltaX = shadowX - ownerInX;
        double deltaY = shadowY - ownerInY;
        double deltaZ = shadowZ - ownerInZ;
        double deltaX2 = shadowX2 - shadowX;
        double deltaY2 = shadowY2 - shadowY;
        double deltaZ2 = shadowZ2 - shadowZ;
        matrixStackIn.func_227860_a_();
        boolean shouldSit = entityIn.func_184218_aH() && entityIn.func_184187_bx() != null && entityIn.func_184187_bx().shouldRiderSit();
        IVertexBuilder ivertexbuilder = event.getBuffers().getBuffer(RenderType.func_228644_e_((ResourceLocation)event.getRenderer().func_110775_a((Entity)entityIn)));
        int i = LivingRenderer.func_229117_c_((LivingEntity)entityIn, (float)0.0f);
        float f = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.field_70760_ar, (float)entityIn.field_70761_aq);
        float f1 = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.field_70758_at, (float)entityIn.field_70759_as);
        float f2 = f1 - f;
        float f9 = MathHelper.func_219805_h((float)partialTicks, (float)illusion.prevRenderYaw, (float)illusion.renderYaw);
        float f10 = MathHelper.func_219805_h((float)partialTicks, (float)illusion.prevRenderYaw2, (float)illusion.renderYaw2);
        if (shouldSit && entityIn.func_184187_bx() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entityIn.func_184187_bx();
            f = MathHelper.func_219805_h((float)partialTicks, (float)livingentity.field_70760_ar, (float)livingentity.field_70761_aq);
            f2 = f1 - f;
            float f3 = MathHelper.func_76142_g((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = MathHelper.func_219799_g((float)partialTicks, (float)entityIn.field_70127_C, (float)entityIn.field_70125_A);
        if (entityIn.func_213283_Z() == Pose.SLEEPING && (direction = entityIn.func_213376_dz()) != null) {
            float f4 = entityIn.func_213307_e(Pose.STANDING) - 0.1f;
            matrixStackIn.func_227861_a_((double)((float)(-direction.func_82601_c()) * f4), 0.0, (double)((float)(-direction.func_82599_e()) * f4));
        }
        float f7 = (float)entityIn.field_70173_aa + partialTicks;
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entityIn.func_70089_S()) {
            f8 = MathHelper.func_219799_g((float)partialTicks, (float)entityIn.field_184618_aE, (float)entityIn.field_70721_aZ);
            f5 = entityIn.field_184619_aG - entityIn.field_70721_aZ * (1.0f - partialTicks);
            if (entityIn.func_70631_g_()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(deltaX, deltaY, deltaZ);
        ClientIllusionEventHandler.applyRotations(entityIn, matrixStackIn, f7, f9, illusion.rotationPitch, partialTicks);
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrixStackIn.func_227861_a_(0.0, (double)-1.501f, 0.0);
        event.getRenderer().func_217764_d().func_212843_a_((Entity)entityIn, f5, f8, partialTicks);
        event.getRenderer().func_217764_d().func_225597_a_((Entity)entityIn, f5, f8, f7, f2, f6);
        event.getRenderer().func_217764_d().func_225598_a_(matrixStackIn, ivertexbuilder, event.getLight(), OverlayTexture.field_229196_a_, 1.0f, 0.5f, 0.5f, 0.5f * MathHelper.func_76131_a((float)((float)ClientIllusionEventHandler.speedMag(entityIn.func_213322_ci())), (float)0.0f, (float)1.25f));
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(deltaX2, deltaY2, deltaZ2);
        ClientIllusionEventHandler.applyRotations(entityIn, matrixStackIn, f7, f10, illusion.rotationPitch2, partialTicks);
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrixStackIn.func_227861_a_(0.0, (double)-1.501f, 0.0);
        event.getRenderer().func_217764_d().func_212843_a_((Entity)entityIn, f5, f8, partialTicks);
        event.getRenderer().func_217764_d().func_225597_a_((Entity)entityIn, f5, f8, f7, f2, f6);
        event.getRenderer().func_217764_d().func_225598_a_(matrixStackIn, ivertexbuilder, event.getLight(), OverlayTexture.field_229196_a_, 0.5f, 1.0f, 0.5f, 0.25f * MathHelper.func_76131_a((float)((float)ClientIllusionEventHandler.speedMag(entityIn.func_213322_ci())), (float)0.0f, (float)1.25f));
        matrixStackIn.func_227865_b_();
        matrixStackIn.func_227865_b_();
    }

    public static double speedMag(Vec3d vec) {
        return vec.field_72450_a * vec.field_72450_a + vec.field_72448_b * vec.field_72448_b + vec.field_72449_c * vec.field_72449_c;
    }

    private static float getFacingAngle(Direction facingIn) {
        switch (facingIn) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    protected static void applyRotations(LivingEntity entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float rotationPitch, float partialTicks) {
        String s;
        Pose pose = entityLiving.func_213283_Z();
        if (pose != Pose.SLEEPING) {
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rotationYaw));
        }
        float f = entityLiving.func_205015_b(partialTicks);
        if (entityLiving.func_184613_cA()) {
            float f1 = (float)entityLiving.func_184599_cB() + partialTicks;
            float f2 = MathHelper.func_76131_a((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!entityLiving.func_204805_cN()) {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f2 * (-90.0f - entityLiving.field_70125_A)));
            }
            Vec3d vec3d = entityLiving.func_70676_i(partialTicks);
            Vec3d vec3d1 = entityLiving.func_213322_ci();
            double d0 = Entity.func_213296_b((Vec3d)vec3d1);
            double d1 = Entity.func_213296_b((Vec3d)vec3d);
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vec3d1.field_72450_a * vec3d.field_72450_a + vec3d1.field_72449_c * vec3d.field_72449_c) / (Math.sqrt(d0) * Math.sqrt(d1));
                double d3 = vec3d1.field_72450_a * vec3d.field_72449_c - vec3d1.field_72449_c * vec3d.field_72450_a;
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            float f3 = entityLiving.func_70090_H() ? -90.0f - entityLiving.field_70125_A : -90.0f;
            float f4 = MathHelper.func_219799_g((float)f, (float)0.0f, (float)f3);
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f4));
            if (entityLiving.func_213314_bj()) {
                matrixStackIn.func_227861_a_(0.0, -1.0, (double)0.3f);
            }
        }
        if (entityLiving.field_70725_aQ > 0) {
            float f2 = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f2 = MathHelper.func_76129_c((float)f2)) > 1.0f) {
                f2 = 1.0f;
            }
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f2 * ClientIllusionEventHandler.getDeathMaxRotation()));
        } else if (entityLiving.func_204805_cN()) {
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f - entityLiving.field_70125_A));
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((float)entityLiving.field_70173_aa + partialTicks) * -75.0f));
        } else if (pose == Pose.SLEEPING) {
            Direction direction = entityLiving.func_213376_dz();
            float f1 = direction != null ? ClientIllusionEventHandler.getFacingAngle(direction) : rotationYaw;
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f1));
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(ClientIllusionEventHandler.getDeathMaxRotation()));
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
        } else if ((entityLiving.func_145818_k_() || entityLiving instanceof PlayerEntity) && ("Dinnerbone".equals(s = TextFormatting.func_110646_a((String)entityLiving.func_200200_C_().getString())) || "Grumm".equals(s)) && (!(entityLiving instanceof PlayerEntity) || ((PlayerEntity)entityLiving).func_175148_a(PlayerModelPart.CAPE))) {
            matrixStackIn.func_227861_a_(0.0, (double)(entityLiving.func_213302_cg() + 0.1f), 0.0);
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        }
    }

    public static float getDeathMaxRotation() {
        return 90.0f;
    }
}

