/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone;

import net.minecraft.entity.EntityClassification;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.telepathicgrunt.bumblezone.ClientEvents;
import net.telepathicgrunt.bumblezone.biome.BzBaseBiome;
import net.telepathicgrunt.bumblezone.biome.BzBiomes;
import net.telepathicgrunt.bumblezone.biome.surfacebuilders.BzSurfaceBuilders;
import net.telepathicgrunt.bumblezone.blocks.BzBlocks;
import net.telepathicgrunt.bumblezone.blocks.SugarWaterEvents;
import net.telepathicgrunt.bumblezone.capabilities.CapabilityPlayerPosAndDim;
import net.telepathicgrunt.bumblezone.config.BzConfig;
import net.telepathicgrunt.bumblezone.effects.BzEffects;
import net.telepathicgrunt.bumblezone.features.BzFeatures;
import net.telepathicgrunt.bumblezone.features.placement.BzPlacements;
import net.telepathicgrunt.bumblezone.items.BzItems;
import net.telepathicgrunt.bumblezone.items.DispenserItemSetup;
import net.telepathicgrunt.bumblezone.modcompatibility.BeesourcefulRedirection;
import net.telepathicgrunt.bumblezone.modcompatibility.ModChecking;
import net.telepathicgrunt.bumblezone.modcompatibility.ProductiveBeesRedirection;
import net.telepathicgrunt.bumblezone.utils.ConfigHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="the_bumblezone")
public class Bumblezone {
    public static final String MODID = "the_bumblezone";
    public static final Logger LOGGER = LogManager.getLogger((String)"the_bumblezone");
    public static BzConfig.BzConfigValues BzConfig = null;

    public Bumblezone() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::resetBiomes);
        BzBlocks.BLOCKS.register(modEventBus);
        BzItems.ITEMS.register(modEventBus);
        BzBlocks.FLUIDS.register(modEventBus);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientEvents.subscribeClientEvents(modEventBus, forgeBus));
        BzConfig = ConfigHelper.register(ModConfig.Type.SERVER, (builder, subscriber) -> new BzConfig.BzConfigValues((ForgeConfigSpec.Builder)builder, (ConfigHelper.Subscriber)subscriber));
    }

    private void setup(FMLCommonSetupEvent event) {
        CapabilityPlayerPosAndDim.register();
        SugarWaterEvents.setup();
        DispenserItemSetup.setupDispenserBehaviors();
        DeferredWorkQueue.runLater(Bumblezone::lateSetup);
    }

    private static void lateSetup() {
        DispenserItemSetup.lateSetupDespenserBehavior();
        BzBaseBiome.addSprings();
        ModChecking.setupModCompat();
        BzBiomes.biomes.forEach(biome -> ((BzBaseBiome)((Object)biome)).increaseVanillaSlimeMobsRates());
    }

    public void resetBiomes(ModConfig.Reloading event) {
        if (Bumblezone.BzConfig.clearUnwantedBiomeFeatures.get().booleanValue()) {
            for (Biome biome2 : BzBiomes.biomes) {
                for (GenerationStage.Decoration decoration : GenerationStage.Decoration.values()) {
                    biome2.func_203607_a(decoration).clear();
                }
                biome2.field_201874_aj.clear();
                ((BzBaseBiome)biome2).addBiomeFeatures();
            }
            BzBaseBiome.addSprings();
            if (ModChecking.beesourcefulPresent) {
                BeesourcefulRedirection.BSAddHoneycombs();
            }
            if (ModChecking.productiveBeesPresent) {
                ProductiveBeesRedirection.PBAddHoneycombs();
            }
        }
        if (Bumblezone.BzConfig.clearUnwantedBiomeMobs.get().booleanValue()) {
            for (Biome biome2 : BzBiomes.biomes) {
                for (GenerationStage.Decoration decoration : EntityClassification.values()) {
                    biome2.func_76747_a((EntityClassification)decoration).clear();
                }
                ((BzBaseBiome)biome2).addBiomeMobs();
            }
            BzBiomes.biomes.forEach(biome -> ((BzBaseBiome)((Object)((Object)biome))).increaseVanillaSlimeMobsRates());
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerBiomes(RegistryEvent.Register<Biome> event) {
            BzBiomes.registerBiomes(event);
        }

        @SubscribeEvent
        public static void onRegisterFeatures(RegistryEvent.Register<Feature<?>> event) {
            BzFeatures.registerFeatures(event);
        }

        @SubscribeEvent
        public static void onRegisterEffects(RegistryEvent.Register<Effect> event) {
            BzEffects.registerEffects(event);
        }

        @SubscribeEvent
        public static void onRegisterPlacements(RegistryEvent.Register<Placement<?>> event) {
            BzPlacements.registerPlacements(event);
        }

        @SubscribeEvent
        public static void onRegisterSurfacebuilders(RegistryEvent.Register<SurfaceBuilder<?>> event) {
            BzSurfaceBuilders.registerSurfaceBuilders(event);
        }

        @SubscribeEvent
        public static void onRegisterSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
            BzItems.registerCustomRecipes(event);
        }
    }
}

