/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.bumblezone.modcompatibility;

import cy.jdkdigital.productivebees.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.block.AdvancedBeehiveAbstract;
import cy.jdkdigital.productivebees.block.ExpansionBox;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.telepathicgrunt.bumblezone.Bumblezone;
import net.telepathicgrunt.bumblezone.biome.BzBaseBiome;
import net.telepathicgrunt.bumblezone.biome.BzBiomes;
import net.telepathicgrunt.bumblezone.modcompatibility.ModChecking;
import org.apache.logging.log4j.Level;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public class ProductiveBeesCompat {
    private static String productivebeesNamespace = "productivebees";
    private static List<Block> ORE_BASED_HONEYCOMB_VARIANTS = new ArrayList<Block>();
    public static List<EntityType<?>> productiveBeesList = new ArrayList();
    private static List<Block> SPIDER_DUNGEON_HONEYCOMBS = new ArrayList<Block>();
    private static boolean newEnoughVersion = false;

    public static void setupProductiveBees() {
        ModChecking.productiveBeesPresent = true;
        for (EntityType productiveBeeType : ForgeRegistries.ENTITIES) {
            if (!productiveBeeType.getRegistryName().func_110624_b().equals(productivebeesNamespace) || !productiveBeeType.getRegistryName().func_110623_a().contains("bee")) continue;
            productiveBeesList.add(productiveBeeType);
        }
        ArtifactVersion versionObj = ((ModContainer)ModList.get().getModContainerById(productivebeesNamespace).get()).getModInfo().getVersion();
        if (versionObj.getMajorVersion() != 0 || versionObj.getMinorVersion() >= 1 && versionObj.getBuildNumber() >= 8) {
            newEnoughVersion = true;
        }
        if (Bumblezone.BzConfig.spawnProductiveBeesHoneycombVariants.get().booleanValue() && newEnoughVersion) {
            OreFeatureConfig.FillerBlockType.create((String)"honeycomb_target".toUpperCase(), (String)"honeycomb_target", (Predicate)new BlockMatcher(Blocks.field_226908_md_));
            ProductiveBeesCompat.PBAddHoneycombs();
            SPIDER_DUNGEON_HONEYCOMBS.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(productivebeesNamespace + ":comb_bauxite")));
            SPIDER_DUNGEON_HONEYCOMBS.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(productivebeesNamespace + ":comb_brazen")));
            SPIDER_DUNGEON_HONEYCOMBS.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(productivebeesNamespace + ":comb_bronze")));
            SPIDER_DUNGEON_HONEYCOMBS.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(productivebeesNamespace + ":comb_copper")));
            SPIDER_DUNGEON_HONEYCOMBS.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(productivebeesNamespace + ":comb_rotten")));
            SPIDER_DUNGEON_HONEYCOMBS.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(productivebeesNamespace + ":comb_slimy")));
            SPIDER_DUNGEON_HONEYCOMBS.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(productivebeesNamespace + ":comb_radioactive")));
            SPIDER_DUNGEON_HONEYCOMBS.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(productivebeesNamespace + ":comb_withered")));
            for (Block block : SPIDER_DUNGEON_HONEYCOMBS) {
                ProductiveBeesCompat.wasBlockFound(block, block.getRegistryName());
            }
        }
    }

    public static void PBAddHoneycombs() {
        if (!ModChecking.beesourcefulPresent || !Bumblezone.BzConfig.spawnBeesourcefulHoneycombVariants.get().booleanValue()) {
            ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_gold"), 34, 3, 6, 230, true);
            ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_iron"), 26, 2, 30, 210, true);
            ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_redstone"), 22, 1, 30, 210, true);
            ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_lapis"), 22, 1, 6, 30, true);
            ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_emerald"), 5, 1, 6, 244, true);
            ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_ender"), 5, 1, 200, 50, true);
            ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_diamond"), 7, 1, 6, 244, true);
        }
        ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_blazing"), 34, 1, 40, 200, false);
        ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_glowing"), 34, 1, 40, 200, false);
        ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_bone"), 22, 1, 6, 25, false);
        ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_fossilised"), 18, 1, 4, 20, false);
        ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_draconic"), 5, 1, 200, 50, false);
        ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_draconic"), 5, 1, 2, 10, false);
        ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_powdery"), 7, 1, 60, 244, false);
        ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_quartz"), 7, 1, 60, 244, false);
        ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_magmatic"), 34, 1, 40, 200, false);
        ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_amber"), 34, 1, 40, 200, false);
        ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_electrum"), 30, 1, 40, 200, false);
        ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_invar"), 10, 1, 2, 244, false);
        ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_leaden"), 10, 1, 1, 30, false);
        ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_nickel"), 10, 1, 1, 30, false);
        ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_osmium"), 9, 1, 1, 30, false);
        ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_platinum"), 5, 1, 1, 30, true);
        ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_silver"), 9, 1, 1, 30, true);
        ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_steel"), 9, 1, 1, 200, false);
        ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_tin"), 9, 1, 1, 200, false);
        ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_titanium"), 6, 1, 1, 30, true);
        ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_tungsten"), 9, 1, 1, 200, false);
        ProductiveBeesCompat.addCombToWorldgen(new ResourceLocation(productivebeesNamespace + ":comb_zinc"), 9, 1, 1, 200, false);
    }

    private static boolean wasBlockFound(Block block, ResourceLocation blockRL) {
        if (block == Blocks.field_150350_a) {
            Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
            Bumblezone.LOGGER.log(Level.INFO, " ");
            Bumblezone.LOGGER.log(Level.INFO, "BUMBLEZONE: Error trying to get the following block: " + blockRL.toString() + ". Please let The Bumblezone developer know about this!");
            Bumblezone.LOGGER.log(Level.INFO, " ");
            Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
            return false;
        }
        return true;
    }

    private static void addCombToWorldgen(ResourceLocation blockRL, int veinSize, int count, int bottomOffset, int range, boolean addToHoneycombList) {
        Block honeycombBlock = (Block)ForgeRegistries.BLOCKS.getValue(blockRL);
        if (!ProductiveBeesCompat.wasBlockFound(honeycombBlock, blockRL)) {
            return;
        }
        BzBiomes.biomes.forEach(biome -> ((BzBaseBiome)((Object)biome)).func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.func_214736_a((String)"honeycomb_target"), honeycombBlock.func_176223_P(), veinSize)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(count, bottomOffset, 0, range)))));
        if (addToHoneycombList) {
            ORE_BASED_HONEYCOMB_VARIANTS.add(honeycombBlock);
        }
    }

    public static boolean PBIsAdvancedBeehiveAbstractBlock(BlockState block) {
        if (block.func_177230_c() instanceof ExpansionBox && ((Boolean)block.func_177229_b((IProperty)AdvancedBeehive.EXPANDED)).booleanValue()) {
            return true;
        }
        return block.func_177230_c() instanceof AdvancedBeehiveAbstract;
    }

    public static void PBMobSpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        if (productiveBeesList.size() == 0) {
            Bumblezone.LOGGER.warn("Error! List of productive bees is empty! Cannot spawn their bees. Please let TelepathicGrunt (The Bumblezone dev) know about this!");
            return;
        }
        MobEntity entity = (MobEntity)event.getEntity();
        IWorld world = event.getWorld();
        MobEntity productiveBeeEntity = (MobEntity)productiveBeesList.get(world.func_201674_k().nextInt(productiveBeesList.size())).func_200721_a(entity.field_70170_p);
        BlockPos.Mutable blockpos = new BlockPos.Mutable(entity.func_180425_c());
        productiveBeeEntity.func_70012_b((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), world.func_201674_k().nextFloat() * 360.0f, 0.0f);
        ILivingEntityData ilivingentitydata = null;
        ilivingentitydata = productiveBeeEntity.func_213386_a(world, world.func_175649_E(new BlockPos((Entity)productiveBeeEntity)), event.getSpawnReason(), ilivingentitydata, (CompoundNBT)null);
        world.func_217376_c((Entity)productiveBeeEntity);
    }

    public static Block PBGetRottenedHoneycomb(Random random) {
        Block replacementBlock = SPIDER_DUNGEON_HONEYCOMBS.get(random.nextInt(random.nextInt(SPIDER_DUNGEON_HONEYCOMBS.size()) + 1));
        return replacementBlock == Blocks.field_150350_a ? Blocks.field_226908_md_ : replacementBlock;
    }

    public static Block PBGetRandomHoneycomb(Random random, int lowerBoundBias) {
        if (newEnoughVersion) {
            int index = ORE_BASED_HONEYCOMB_VARIANTS.size() - 1;
            for (int i = 0; i < lowerBoundBias && index != 0; ++i) {
                index = random.nextInt(index + 1);
            }
            return ORE_BASED_HONEYCOMB_VARIANTS.get(index);
        }
        return Blocks.field_226908_md_;
    }
}

