/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Controllers;

public class KeyHandler {
    private KeyBinding key_powerup = new KeyBinding("key.powerup", 17, "key.categories.thercmod");
    private KeyBinding key_powerdown = new KeyBinding("key.powerdown", 31, "key.categories.thercmod");
    private KeyBinding key_turnleft = new KeyBinding("key.turnleft", 30, "key.categories.thercmod");
    private KeyBinding key_turnright = new KeyBinding("key.turnright", 32, "key.categories.thercmod");
    private KeyBinding key_rollleft = new KeyBinding("key.rollleft", 203, "key.categories.thercmod");
    private KeyBinding key_rollright = new KeyBinding("key.rollright", 205, "key.categories.thercmod");
    private KeyBinding key_pitchdown = new KeyBinding("key.pitchdown", 200, "key.categories.thercmod");
    private KeyBinding key_pitchup = new KeyBinding("key.pitchup", 208, "key.categories.thercmod");
    private KeyBinding key_retrieve = new KeyBinding("key.retrieve", 19, "key.categories.thercmod");
    private KeyBinding key_weaponsmode = new KeyBinding("key.weaponsmode", 46, "key.categories.thercmod");
    private KeyBinding key_motorkill = new KeyBinding("key.motorkill", 37, "key.categories.thercmod");
    private KeyBinding key_camright = new KeyBinding("key.camright", 77, "key.categories.thercmod");
    private KeyBinding key_camleft = new KeyBinding("key.camleft", 75, "key.categories.thercmod");
    private KeyBinding key_camup = new KeyBinding("key.camup", 72, "key.categories.thercmod");
    private KeyBinding key_camdown = new KeyBinding("key.camdown", 80, "key.categories.thercmod");
    private KeyBinding key_camin = new KeyBinding("key.camin", 78, "key.categories.thercmod");
    private KeyBinding key_camout = new KeyBinding("key.camout", 74, "key.categories.thercmod");
    private KeyBinding key_camreset = new KeyBinding("key.camreset", 76, "key.categories.thercmod");
    private KeyBinding key_fire = new KeyBinding("key.fire", 57, "key.categories.thercmod");
    private KeyBinding key_jump = new KeyBinding("key.powerjump", 200, "key.categories.thercmod");
    private boolean controllerEnabled;
    private boolean pitchControllerEnabled;
    private String pitchControllerName;
    private int pitchAxisIndex;
    private int pitchAxisInvert;
    private boolean rollControllerEnabled;
    private String rollControllerName;
    private int rollAxisIndex;
    private int rollAxisInvert;
    private boolean yawControllerEnabled;
    private String yawControllerName;
    private int yawAxisIndex;
    private int yawAxisInvert;
    private boolean powerControllerEnabled;
    private String powerControllerName;
    private int powerAxisIndex;
    private int powerAxisInvert;
    private boolean turnControllerEnabled;
    private String turnControllerName;
    private int turnAxisIndex;
    private int turnAxisInvert;
    private String shootControllerName;
    private int shootButtonIndex;
    private String wModeControllerName;
    private int wModeButtonIndex;
    private String resetControllerName;
    private int resetButtonIndex;
    private String jumpControllerName;
    private int jumpButtonIndex;
    public static float absPowerMovement;
    public static float powerMovement;
    public static float yawMovement;
    public static float turnMovement;
    public static float rollMovement;
    public static float pitchMovement;
    public static boolean retrieve;
    public static boolean weaponsMode;
    public static boolean motorKill;
    public static boolean jump;
    public static boolean shoot;
    public static int camZoom;
    public static int camYaw;
    public static int camHeight;
    public static boolean camReset;
    private Minecraft mc;

    public KeyHandler(Minecraft minecraft) {
        this.mc = minecraft;
        ClientRegistry.registerKeyBinding((KeyBinding)this.key_powerup);
        ClientRegistry.registerKeyBinding((KeyBinding)this.key_powerdown);
        ClientRegistry.registerKeyBinding((KeyBinding)this.key_turnleft);
        ClientRegistry.registerKeyBinding((KeyBinding)this.key_turnright);
        ClientRegistry.registerKeyBinding((KeyBinding)this.key_rollleft);
        ClientRegistry.registerKeyBinding((KeyBinding)this.key_rollright);
        ClientRegistry.registerKeyBinding((KeyBinding)this.key_pitchup);
        ClientRegistry.registerKeyBinding((KeyBinding)this.key_pitchdown);
        ClientRegistry.registerKeyBinding((KeyBinding)this.key_retrieve);
        ClientRegistry.registerKeyBinding((KeyBinding)this.key_weaponsmode);
        ClientRegistry.registerKeyBinding((KeyBinding)this.key_motorkill);
        ClientRegistry.registerKeyBinding((KeyBinding)this.key_camright);
        ClientRegistry.registerKeyBinding((KeyBinding)this.key_camleft);
        ClientRegistry.registerKeyBinding((KeyBinding)this.key_camup);
        ClientRegistry.registerKeyBinding((KeyBinding)this.key_camdown);
        ClientRegistry.registerKeyBinding((KeyBinding)this.key_camin);
        ClientRegistry.registerKeyBinding((KeyBinding)this.key_camout);
        ClientRegistry.registerKeyBinding((KeyBinding)this.key_fire);
        ClientRegistry.registerKeyBinding((KeyBinding)this.key_jump);
        this.discoverControllers();
        this.initControllers();
        absPowerMovement = 0.0f;
        powerMovement = 0.0f;
        yawMovement = 0.0f;
        turnMovement = 0.0f;
        rollMovement = 0.0f;
        pitchMovement = 0.0f;
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (this.mc.field_71415_G && event.phase == TickEvent.Phase.START) {
            Controllers.poll();
            retrieve = false;
            weaponsMode = false;
            shoot = false;
            jump = false;
            motorKill = false;
            camYaw = 0;
            camHeight = 0;
            camZoom = 0;
            camReset = false;
            powerMovement = this.key_powerup.func_151470_d() ? this.offSetValue(powerMovement, 1) : (this.key_powerdown.func_151470_d() ? this.offSetValue(powerMovement, -1) : (this.powerControllerEnabled && this.controllerEnabled ? -this.getAxisValue(this.powerControllerName, this.powerAxisIndex, this.powerAxisInvert) : this.zeroValue(powerMovement)));
            if (this.key_powerup.func_151470_d()) {
                absPowerMovement = this.powerOffSetValue(absPowerMovement, 1);
            } else if (this.key_powerdown.func_151470_d()) {
                absPowerMovement = this.powerOffSetValue(absPowerMovement, -1);
            } else if (this.powerControllerEnabled && this.controllerEnabled) {
                absPowerMovement = Math.abs((this.getAxisValue(this.powerControllerName, this.powerAxisIndex, this.powerAxisInvert) - 1.0f) / 2.0f);
            }
            yawMovement = this.key_turnright.func_151470_d() ? this.offSetValue(yawMovement, 1) : (this.key_turnleft.func_151470_d() ? this.offSetValue(yawMovement, -1) : (this.yawControllerEnabled && this.controllerEnabled ? this.getAxisValue(this.yawControllerName, this.yawAxisIndex, this.yawAxisInvert) : this.zeroValue(yawMovement)));
            turnMovement = this.key_turnright.func_151470_d() ? this.offSetValue(turnMovement, 1) : (this.key_turnleft.func_151470_d() ? this.offSetValue(turnMovement, -1) : (this.turnControllerEnabled && this.controllerEnabled ? this.getAxisValue(this.turnControllerName, this.turnAxisIndex, this.turnAxisInvert) : this.zeroValue(turnMovement)));
            rollMovement = this.key_rollright.func_151470_d() ? this.offSetValue(rollMovement, 1) : (this.key_rollleft.func_151470_d() ? this.offSetValue(rollMovement, -1) : (this.rollControllerEnabled && this.controllerEnabled ? this.getAxisValue(this.rollControllerName, this.rollAxisIndex, this.rollAxisInvert) : this.zeroValue(rollMovement)));
            pitchMovement = this.key_pitchup.func_151470_d() ? this.offSetValue(pitchMovement, 1) : (this.key_pitchdown.func_151470_d() ? this.offSetValue(pitchMovement, -1) : (this.pitchControllerEnabled && this.controllerEnabled ? this.getAxisValue(this.pitchControllerName, this.pitchAxisIndex, this.pitchAxisInvert) : this.zeroValue(pitchMovement)));
            if (this.key_retrieve.func_151470_d() || this.getButtonState(this.resetControllerName, this.resetButtonIndex)) {
                retrieve = true;
            }
            if (this.key_weaponsmode.func_151470_d() || this.getButtonState(this.wModeControllerName, this.wModeButtonIndex)) {
                weaponsMode = true;
            }
            if (this.key_fire.func_151470_d() || this.mc.field_71474_y.field_74312_F.func_151470_d() || this.getButtonState(this.shootControllerName, this.shootButtonIndex)) {
                shoot = true;
            }
            if (this.key_motorkill.func_151470_d()) {
                motorKill = true;
            }
            if (this.key_jump.func_151470_d() || this.getButtonState(this.jumpControllerName, this.jumpButtonIndex)) {
                jump = true;
            }
            if (this.key_camright.func_151470_d()) {
                camYaw = 1;
            } else if (this.key_camleft.func_151470_d()) {
                camYaw = -1;
            }
            if (this.key_camup.func_151470_d()) {
                camHeight = 1;
            } else if (this.key_camdown.func_151470_d()) {
                camHeight = -1;
            }
            if (this.key_camin.func_151470_d()) {
                camZoom = 1;
            } else if (this.key_camout.func_151470_d()) {
                camZoom = -1;
            }
            if (this.key_camreset.func_151470_d()) {
                camReset = true;
            }
        }
    }

    private void discoverControllers() {
        Minecraft mc = Minecraft.func_71410_x();
        try {
            Controllers.create();
            Controllers.poll();
            File dir = new File(mc.field_71412_D + "/thercmod");
            dir.mkdirs();
            File file = new File(dir, "controllerInfo.txt");
            File file2 = new File(dir, "controllerConfig.ini");
            if (!file.createNewFile()) {
                file.delete();
                file.createNewFile();
            }
            FileOutputStream fileoutputstream = new FileOutputStream(file);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(fileoutputstream));
            for (int i = 0; i < Controllers.getControllerCount(); ++i) {
                int j;
                if (Controllers.getController((int)i).getAxisCount() <= 0) continue;
                writer.write("Controller_name:" + Controllers.getController((int)i).getName() + "\n");
                for (j = 0; j < Controllers.getController((int)i).getAxisCount(); ++j) {
                    writer.write("Axis_name:" + Controllers.getController((int)i).getAxisName(j) + "; Index:" + j + "\n");
                }
                for (j = 0; j < Controllers.getController((int)i).getButtonCount(); ++j) {
                    writer.write("Button_name:" + Controllers.getController((int)i).getButtonName(j) + "; Index:" + j + "\n");
                }
                writer.write("\n");
            }
            writer.close();
            fileoutputstream.close();
            if (file2.createNewFile()) {
                fileoutputstream = new FileOutputStream(file2);
                writer = new BufferedWriter(new OutputStreamWriter(fileoutputstream));
                writer.write("Please read the controllerInfo.txt before assigning anything!\n\n");
                writer.write("Controller_enabled=false\n\n");
                writer.write("1_Axis_enabled=false\n");
                writer.write("1_Controller_name=Null\n");
                writer.write("1_Axis_pitch_index=-1\n");
                writer.write("1_Invert_axis=1\n\n");
                writer.write("2_Axis_enabled=false\n");
                writer.write("2_Controller_name=Null\n");
                writer.write("2_Axis_roll_index=-1\n");
                writer.write("2_Invert_axis=1\n\n");
                writer.write("3_Axis_enabled=false\n");
                writer.write("3_Controller_name=Null\n");
                writer.write("3_Axis_yaw_index=-1\n");
                writer.write("3_Invert_axis=1\n\n");
                writer.write("4_Axis_enabled=false\n");
                writer.write("4_Controller_name=Null\n");
                writer.write("4_Axis_power_index=-1\n");
                writer.write("4_Invert_axis=1\n\n");
                writer.write("5_Axis_enabled=false\n");
                writer.write("5_Controller_name=Null\n");
                writer.write("5_Axis_turn_index=-1\n");
                writer.write("5_Invert_axis=1\n\n");
                writer.write("6_Controller_name=Null\n");
                writer.write("6_Button_shoot_index=-1\n\n");
                writer.write("7_Controller_name=Null\n");
                writer.write("7_Button_weapon_mode_index=-1\n\n");
                writer.write("8_Controller_name=Null\n");
                writer.write("8_Button_reset_index=-1\n\n");
                writer.write("9_Controller_name=Null\n");
                writer.write("9_Button_jump_index=-1\n");
                writer.close();
                fileoutputstream.close();
            }
        }
        catch (IOException | LWJGLException e) {
            e.printStackTrace();
        }
    }

    private void initControllers() {
        try {
            String line;
            File file = new File(this.mc.field_71412_D, "/thercmod/controllerConfig.ini");
            FileInputStream inputstream = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("Controller_enabled")) {
                    this.controllerEnabled = Boolean.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("1_Axis_enabled")) {
                    this.pitchControllerEnabled = Boolean.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("1_Controller_name")) {
                    this.pitchControllerName = String.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("1_Axis_pitch_index")) {
                    this.pitchAxisIndex = Integer.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("1_Invert_axis")) {
                    this.pitchAxisInvert = Integer.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("2_Axis_enabled")) {
                    this.rollControllerEnabled = Boolean.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("2_Controller_name")) {
                    this.rollControllerName = String.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("2_Axis_roll_index")) {
                    this.rollAxisIndex = Integer.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("2_Invert_axis")) {
                    this.rollAxisInvert = Integer.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("3_Axis_enabled")) {
                    this.yawControllerEnabled = Boolean.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("3_Controller_name")) {
                    this.yawControllerName = String.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("3_Axis_yaw_index")) {
                    this.yawAxisIndex = Integer.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("3_Invert_axis")) {
                    this.yawAxisInvert = Integer.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("4_Axis_enabled")) {
                    this.powerControllerEnabled = Boolean.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("4_Controller_name")) {
                    this.powerControllerName = String.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("4_Axis_power_index")) {
                    this.powerAxisIndex = Integer.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("4_Invert_axis")) {
                    this.powerAxisInvert = Integer.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("5_Axis_enabled")) {
                    this.turnControllerEnabled = Boolean.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("5_Controller_name")) {
                    this.turnControllerName = String.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("5_Axis_turn_index")) {
                    this.turnAxisIndex = Integer.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("5_Invert_axis")) {
                    this.turnAxisInvert = Integer.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("6_Controller_name")) {
                    this.shootControllerName = String.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("6_Button_shoot_index")) {
                    this.shootButtonIndex = Integer.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("7_Controller_name")) {
                    this.wModeControllerName = String.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("7_Button_weapon_mode_index")) {
                    this.wModeButtonIndex = Integer.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("8_Controller_name")) {
                    this.resetControllerName = String.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("8_Button_reset_index")) {
                    this.resetButtonIndex = Integer.valueOf(line.split("=")[1]);
                    continue;
                }
                if (line.startsWith("9_Controller_name")) {
                    this.jumpControllerName = String.valueOf(line.split("=")[1]);
                    continue;
                }
                if (!line.startsWith("9_Button_jump_index")) continue;
                this.jumpButtonIndex = Integer.valueOf(line.split("=")[1]);
            }
            reader.close();
            inputstream.close();
            boolean overrideFlag = true;
            for (int i = 0; i < Controllers.getControllerCount(); ++i) {
                if (!this.pitchControllerName.matches(Controllers.getController((int)i).getName())) continue;
                overrideFlag = false;
            }
            if (overrideFlag) {
                this.controllerEnabled = false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean getButtonState(String controllerName, int buttonIndex) {
        if (controllerName == null || controllerName == "Null" || buttonIndex == -1 || !this.controllerEnabled) {
            return false;
        }
        for (int i = 0; i < Controllers.getControllerCount(); ++i) {
            if (!controllerName.matches(Controllers.getController((int)i).getName())) continue;
            return Controllers.getController((int)i).isButtonPressed(buttonIndex);
        }
        return false;
    }

    private float getAxisValue(String controllerName, int axisIndex, int invertAxis) {
        if (controllerName == null || controllerName == "Null" || axisIndex == -1 || !this.controllerEnabled) {
            return 0.0f;
        }
        for (int i = 0; i < Controllers.getControllerCount(); ++i) {
            if (!controllerName.matches(Controllers.getController((int)i).getName())) continue;
            return Controllers.getController((int)i).getAxisValue(axisIndex) * (float)invertAxis;
        }
        return 0.0f;
    }

    private float offSetValue(float value, int dir) {
        if (value == 0.0f) {
            return value + 0.2f * (float)dir;
        }
        if (value > 0.0f) {
            return Math.min(value + 0.2f * (float)dir, 1.0f);
        }
        return Math.max(value + 0.2f * (float)dir, -1.0f);
    }

    private float zeroValue(float value) {
        if (value > 0.0f) {
            return Math.max(value - 0.2f, 0.0f);
        }
        if (value < 0.0f) {
            return Math.min(value + 0.2f, 0.0f);
        }
        return 0.0f;
    }

    private float powerOffSetValue(float value, int dir) {
        return Math.min(Math.max(value + 0.04f * (float)dir, 0.0f), 1.0f);
    }

    public static void resetControls() {
        absPowerMovement = 0.0f;
        powerMovement = 0.0f;
        yawMovement = 0.0f;
        turnMovement = 0.0f;
        rollMovement = 0.0f;
        pitchMovement = 0.0f;
    }
}

