/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Packets;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.eldercodes.thercmod.Entities.GlobalEntity;
import net.eldercodes.thercmod.Items.ItemBattery;
import net.eldercodes.thercmod.Items.ItemRemoteControl;
import net.eldercodes.thercmod.RCM_Main;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageItemStackHandler
implements IMessage,
IMessageHandler<MessageItemStackHandler, IMessage> {
    public int ID;
    public int type;
    public float charge;
    public float temp;
    public boolean state;

    public MessageItemStackHandler() {
    }

    public MessageItemStackHandler(int entityID, int messageType, float batteryCharge, float motorTemp, boolean powerState) {
        this.ID = entityID;
        this.type = messageType;
        this.charge = batteryCharge;
        this.temp = motorTemp;
        this.state = powerState;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.ID);
        buf.writeInt(this.type);
        buf.writeFloat(this.charge);
        buf.writeFloat(this.temp);
        buf.writeBoolean(this.state);
    }

    public void fromBytes(ByteBuf buf) {
        this.ID = buf.readInt();
        this.type = buf.readInt();
        this.charge = buf.readFloat();
        this.temp = buf.readFloat();
        this.state = buf.readBoolean();
    }

    public IMessage onMessage(MessageItemStackHandler message, MessageContext ctx) {
        switch (message.type) {
            case 1: {
                this.handleItemRemoteControl(message, ctx);
                break;
            }
            case 2: {
                this.handleItemBattery(message, ctx);
            }
        }
        return null;
    }

    private void handleItemRemoteControl(MessageItemStackHandler message, MessageContext ctx) {
        List entityList = null;
        Entity entity = null;
        EntityPlayer player = null;
        if (ctx.side.isClient()) {
            entityList = RCM_Main.proxy.getClientWorld().field_72996_f;
        } else if (ctx.side.isServer()) {
            entityList = RCM_Main.proxy.getServerWorld().field_72996_f;
        }
        for (int i = 0; i < entityList.size(); ++i) {
            entity = (Entity)entityList.get(i);
            if (entity == null || entity.func_145782_y() != message.ID || !((player = (EntityPlayer)entity).func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemRemoteControl)) continue;
            ItemRemoteControl remote = (ItemRemoteControl)player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b();
            if (ctx.side.isClient()) {
                remote.setClientPowerState(player.func_184586_b(EnumHand.MAIN_HAND), message.state);
                continue;
            }
            if (!ctx.side.isServer()) continue;
            remote.setServerPowerState(message.ID, player.field_70170_p.field_73011_w.getDimension(), player.func_184586_b(EnumHand.MAIN_HAND), message.state);
        }
    }

    private void handleItemBattery(MessageItemStackHandler message, MessageContext ctx) {
        List entityList = null;
        Entity entity = null;
        GlobalEntity nwEntity = null;
        if (ctx.side.isClient()) {
            entityList = RCM_Main.proxy.getClientWorld().field_72996_f;
        } else if (ctx.side.isServer()) {
            entityList = RCM_Main.proxy.getServerWorld().field_72996_f;
        }
        for (int i = 0; i < entityList.size(); ++i) {
            entity = (Entity)entityList.get(i);
            if (entity == null || entity.func_145782_y() != message.ID) continue;
            nwEntity = (GlobalEntity)entity;
            if (!(nwEntity.entityInventory.func_70301_a(2).func_77973_b() instanceof ItemBattery)) continue;
            nwEntity.updateNetInventoryStats(message.temp, message.charge);
        }
    }
}

