/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Physics;

import javax.annotation.Nullable;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.eldercodes.thercmod.Entities.GlobalEntity;
import net.eldercodes.thercmod.Packets.MessageDespawnWeapon;
import net.eldercodes.thercmod.Packets.MessageHandler;
import net.eldercodes.thercmod.Packets.MessageSpawnWeapon;
import net.eldercodes.thercmod.Physics.PhysicsHelper;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class AttachmentHandler {
    private Vector3f position;
    private boolean isEmpty;
    private GlobalEntity aentity;
    private PhysicsHelper helper = new PhysicsHelper();
    private int pylonNumber;
    private float deltaTime;
    private AxisAngle4f rotate;

    public AttachmentHandler(Vector3f pos, AxisAngle4f rot, int type, int place) {
        this.position = pos;
        this.isEmpty = true;
        this.pylonNumber = place;
        this.deltaTime = 0.0f;
        this.rotate = new AxisAngle4f(rot);
    }

    public void setMotionState(Quat4f localQuat, Vector3f linearVelocity, Vector3f pos, float par, int ID) {
        Vector3f gPos = this.helper.rotateVector(localQuat, this.position);
        gPos.add((Tuple3f)pos);
        if (this.isEmpty && this.deltaTime <= 0.0f) {
            MessageHandler.handler.sendToServer((IMessage)new MessageSpawnWeapon(ID, this.pylonNumber, 0));
            this.deltaTime = 10.0f;
        } else if (this.isEmpty) {
            this.deltaTime -= par;
        }
        if (this.aentity != null && this.aentity.physicsWorld != null) {
            Quat4f localRotate = new Quat4f();
            Quat4f finalRotate = new Quat4f();
            localRotate.set(this.rotate);
            finalRotate.mul(localQuat, localRotate);
            this.aentity.physicsWorld.setEntityLinearVelocity(linearVelocity);
            this.aentity.physicsWorld.setEntityMotionState(finalRotate, gPos, 1.0f);
            this.isEmpty = false;
        }
    }

    public void release(@Nullable Entity lockedEntity, @Nullable Vector3f targetLoc) {
        if (this.aentity != null) {
            this.aentity.physicsWorld.setRocketMotorActive();
            this.aentity.physicsWorld.setLockedTarger(lockedEntity);
            this.aentity.physicsWorld.setTargetPosition(targetLoc);
            this.isEmpty = true;
            this.aentity = null;
        }
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void attach(GlobalEntity gEntity) {
        this.aentity = gEntity;
    }

    public void removeAttachment() {
        MessageHandler.handler.sendToServer((IMessage)new MessageDespawnWeapon(this.aentity.func_145782_y()));
    }
}

