/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Physics;

import com.bulletphysics.collision.shapes.BvhTriangleMeshShape;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.collision.shapes.TriangleIndexVertexArray;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.util.vector.Vector3f;

public class DynGroundBlock {
    private CollisionShape groundShape;

    public DynGroundBlock() {
        int j;
        int i;
        float TRIANGLE_SIZE = 1.0f;
        int vertStride = 12;
        int indexStride = 12;
        int NUM_VERTS_X = 2;
        int NUM_VERTS_Y = 2;
        int totalVerts = NUM_VERTS_X * NUM_VERTS_Y;
        int totalTriangles = 2 * (NUM_VERTS_X - 1) * (NUM_VERTS_Y - 1);
        ByteBuffer vertices = ByteBuffer.allocateDirect(totalVerts * vertStride).order(ByteOrder.nativeOrder());
        ByteBuffer gIndices = ByteBuffer.allocateDirect(totalTriangles * 3 * 4).order(ByteOrder.nativeOrder());
        Vector3f tmp = new Vector3f();
        for (i = 0; i < NUM_VERTS_X; ++i) {
            for (j = 0; j < NUM_VERTS_Y; ++j) {
                float height = 0.5f;
                tmp.set(((float)i - (float)NUM_VERTS_X * 0.5f) * 1.0f, height, ((float)j - (float)NUM_VERTS_Y * 0.5f) * 1.0f);
                int index = i + j * NUM_VERTS_X;
                vertices.putFloat((index * 3 + 0) * 4, tmp.x);
                vertices.putFloat((index * 3 + 1) * 4, tmp.y);
                vertices.putFloat((index * 3 + 2) * 4, tmp.z);
            }
        }
        gIndices.clear();
        for (i = 0; i < NUM_VERTS_X - 1; ++i) {
            for (j = 0; j < NUM_VERTS_Y - 1; ++j) {
                gIndices.putInt(j * NUM_VERTS_X + i);
                gIndices.putInt(j * NUM_VERTS_X + i + 1);
                gIndices.putInt((j + 1) * NUM_VERTS_X + i + 1);
                gIndices.putInt(j * NUM_VERTS_X + i);
                gIndices.putInt((j + 1) * NUM_VERTS_X + i + 1);
                gIndices.putInt((j + 1) * NUM_VERTS_X + i);
            }
        }
        gIndices.flip();
        TriangleIndexVertexArray indexVertexArrays = new TriangleIndexVertexArray(totalTriangles, gIndices, indexStride, totalVerts, vertices, vertStride);
        this.groundShape = new BvhTriangleMeshShape(indexVertexArrays, true);
    }

    public CollisionShape getGroundShape() {
        return this.groundShape;
    }
}

