/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Physics;

public class MotorHandler {
    private float omega;
    private float torque;
    private float acceleration;
    private float inertia;
    private float startTorque;
    private float maxRPM;
    private float gearRatio;
    private float motorAngle;
    private float applyTorque;
    private float chargeDrain;
    private float batterySize;
    private float mass;
    private float qLoss;
    private float area;
    private boolean dmg;
    private int ID;
    private int controlChannel;
    private int sensorID;
    private float PI = (float)Math.PI;
    private final float inputVolts;

    public MotorHandler(int ID, float mass, float diameter, float pwr, float kVConstant, float inputVolts, float gearR, float batSize, int senID, int channel) {
        this.ID = ID;
        this.omega = 0.0f;
        this.acceleration = 0.0f;
        this.inertia = mass * diameter * diameter / 8.0f;
        this.mass = mass;
        this.area = diameter * this.PI;
        this.controlChannel = channel;
        this.maxRPM = kVConstant * inputVolts * 2.0f * this.PI / 60.0f;
        this.startTorque = 4.0f * pwr / this.maxRPM;
        this.gearRatio = gearR;
        this.motorAngle = 0.0f;
        this.applyTorque = 0.0f;
        this.sensorID = senID;
        this.inputVolts = inputVolts;
        this.batterySize = batSize * 3.6f;
    }

    public void update(float resistTrqe, float inert, float requestSpeed, boolean wheelConnected, float dt, boolean motorBrake, float batCharge) {
        this.chargeDrain = 0.0f;
        this.qLoss = 0.0f;
        if (batCharge <= 0.0f) {
            requestSpeed = 0.0f;
        }
        if (!this.dmg) {
            this.torque = resistTrqe * this.gearRatio;
            this.torque = requestSpeed != 0.0f ? (this.torque -= this.omega * 1.0E-5f) : (this.torque -= this.motorAngle * Math.abs(this.motorAngle) * 0.08f + this.omega * 1.2E-4f);
            if (this.omega < 6.2f && requestSpeed == 0.0f) {
                this.torque -= this.omega * 0.002f;
            }
            if (requestSpeed == 0.0f) {
                this.applyTorque = 0.0f;
            } else {
                this.applyTorque = -this.torque + 25.0f * (requestSpeed - this.getSpeedUnit());
                if (!motorBrake && requestSpeed * this.applyTorque < 0.0f) {
                    this.applyTorque = 0.0f;
                }
            }
            if (this.omega != 0.0f) {
                this.torque += this.getTorqueLimit(this.applyTorque);
            } else if (requestSpeed > 0.0f) {
                this.torque += this.startTorque;
            } else if (requestSpeed < 0.0f) {
                this.torque -= this.startTorque;
            }
            if (!wheelConnected) {
                this.acceleration = this.torque / (this.inertia + inert * this.gearRatio * this.gearRatio);
                this.omega += this.acceleration * dt;
                this.omega = Math.max(-this.maxRPM, Math.min(this.maxRPM, this.omega));
                this.setMotorAngle(dt);
            }
            if (this.omega != 0.0f && requestSpeed != 0.0f) {
                float powerRequest = Math.abs(this.omega) * (Math.abs(resistTrqe) + Math.abs(this.torque));
                this.chargeDrain = powerRequest * dt / (0.9f * this.inputVolts);
                this.qLoss = powerRequest / 0.9f * 0.1f * dt;
            }
        }
    }

    public void setDmged(boolean dmg) {
        this.dmg = dmg;
        if (dmg) {
            this.omega = 0.0f;
            this.torque = 0.0f;
        }
    }

    public float getChargeDrain() {
        return this.chargeDrain / this.batterySize * 100.0f;
    }

    public float getTempChange(float tempDiff, float delta, int motors) {
        if (this.mass == 0.0f || motors == 0) {
            return 0.0f;
        }
        return (this.qLoss + 20.0f * this.area * tempDiff * delta) / (0.385f * this.mass * 1000.0f * (float)motors);
    }

    private void setMotorAngle(float dt) {
        this.motorAngle += this.omega * dt;
        while (this.motorAngle >= 0.19634955f) {
            this.motorAngle -= 0.3926991f;
        }
        while (this.motorAngle <= -0.19634955f) {
            this.motorAngle += 0.3926991f;
        }
    }

    private float getTorqueLimit(float requiredTorque) {
        if (requiredTorque > 0.0f) {
            return Math.min(requiredTorque, this.startTorque * (1.0f - Math.abs(this.omega) / this.maxRPM));
        }
        if (requiredTorque < 0.0f) {
            return Math.max(requiredTorque, -this.startTorque * (1.0f - Math.abs(this.omega) / this.maxRPM));
        }
        return 0.0f;
    }

    public boolean isDmged() {
        return this.dmg;
    }

    public void setSpeed(float omega) {
        this.omega = omega * this.gearRatio;
    }

    public float getOutputSpeed() {
        return this.omega / this.gearRatio;
    }

    public float getSpeedUnit() {
        return this.omega / this.maxRPM;
    }

    public float getWheelTorque(int wheels) {
        return this.torque * this.gearRatio / (float)wheels;
    }

    public int getChannel() {
        return this.controlChannel;
    }

    public int getID() {
        return this.ID;
    }

    public int getSensorID() {
        return this.sensorID;
    }
}

