/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Physics;

import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.RigidBodyConstructionInfo;
import com.bulletphysics.dynamics.constraintsolver.Generic6DofConstraint;
import com.bulletphysics.dynamics.vehicle.DefaultVehicleRaycaster;
import com.bulletphysics.dynamics.vehicle.RaycastVehicle;
import com.bulletphysics.dynamics.vehicle.VehicleTuning;
import com.bulletphysics.dynamics.vehicle.WheelInfo;
import com.bulletphysics.linearmath.DefaultMotionState;
import com.bulletphysics.linearmath.Transform;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.eldercodes.thercmod.Entities.CameraHandler;
import net.eldercodes.thercmod.Entities.EntityBoat;
import net.eldercodes.thercmod.Entities.EntityDrone;
import net.eldercodes.thercmod.Entities.EntityHeli;
import net.eldercodes.thercmod.Entities.EntityMissile;
import net.eldercodes.thercmod.Entities.EntityOctocopter;
import net.eldercodes.thercmod.Entities.EntityStuntPlane;
import net.eldercodes.thercmod.Entities.EntitySubmarine;
import net.eldercodes.thercmod.Entities.EntityTrainerPlane;
import net.eldercodes.thercmod.Entities.GlobalEntity;
import net.eldercodes.thercmod.Items.ItemBattery;
import net.eldercodes.thercmod.Items.ItemElectricMotor;
import net.eldercodes.thercmod.KeyHandler;
import net.eldercodes.thercmod.Packets.MessageEntityMissle;
import net.eldercodes.thercmod.Packets.MessageHandler;
import net.eldercodes.thercmod.Physics.AttachmentHandler;
import net.eldercodes.thercmod.Physics.AutoControlHandler;
import net.eldercodes.thercmod.Physics.FloatsHandler;
import net.eldercodes.thercmod.Physics.Force;
import net.eldercodes.thercmod.Physics.MotorHandler;
import net.eldercodes.thercmod.Physics.PhysicsHelper;
import net.eldercodes.thercmod.Physics.RocketMotorHandler;
import net.eldercodes.thercmod.Physics.RotaryWingHandler;
import net.eldercodes.thercmod.Physics.TimeToBreak;
import net.eldercodes.thercmod.Physics.VirtualReferenceHandler;
import net.eldercodes.thercmod.Physics.WheelHandler;
import net.eldercodes.thercmod.Physics.WingHandler;
import net.eldercodes.thercmod.PropertiesLoader.PropertiesLoader;
import net.eldercodes.thercmod.RCM_Main;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PhysicsHandler {
    public List<MotorHandler> motors = new ArrayList<MotorHandler>();
    public List<WheelHandler> wheels = new ArrayList<WheelHandler>();
    public List<WingHandler> wings = new ArrayList<WingHandler>();
    public List<RotaryWingHandler> rotaryWings = new ArrayList<RotaryWingHandler>();
    public List<AutoControlHandler> sensors = new ArrayList<AutoControlHandler>();
    public List<AttachmentHandler> attachments = new ArrayList<AttachmentHandler>();
    public List<RocketMotorHandler> rocketMotors = new ArrayList<RocketMotorHandler>();
    public List<FloatsHandler> floats = new ArrayList<FloatsHandler>();
    public List<Force> forces = new ArrayList<Force>();
    public List<Vector3f> torques = new ArrayList<Vector3f>();
    public RigidBody entityBody;
    public RaycastVehicle vehicle;
    private PhysicsHelper helper;
    public VirtualReferenceHandler virtualReference;
    public List<Entity> visibleEntities = Lists.newArrayList();
    public List<Entity> inRadarEntities = Lists.newArrayList();
    public Entity lockedEntity;
    private int lockedEntityID;
    private float unlockCooldown;
    public boolean requestCollisionShapes = false;
    private boolean jump;
    private Vector3f linearVel;
    private Vector3f rotationalVel;
    private Vector3f position;
    private Vector3f frontPath;
    private Vector3f targetPos;
    private Quat4f localQuat;
    private float dragFactor;
    private PropertiesLoader loader;
    public float pitchAngle;
    public float rollAngle;
    public float yawAngle;
    private float[] controlChannels = new float[27];
    private boolean motorActive;
    public boolean weaponsMode;
    private boolean canChangeMode;
    private boolean canFireMissile;
    private boolean releaseWeapons;
    private float releaseWeaponTimer;
    private float prevDist;
    private int weaponCount;
    private float floatDensity;
    private Vector3f Forward;
    private Vector3f Up;
    private Vector3f Left;

    public PhysicsHandler(int ID, Vector3f pos, float spawnRotation, GlobalEntity rcentity) {
        this.localQuat = new Quat4f();
        this.linearVel = new Vector3f();
        this.rotationalVel = new Vector3f();
        this.position = new Vector3f(pos);
        this.frontPath = new Vector3f();
        this.virtualReference = new VirtualReferenceHandler();
        this.setEntity(ID);
        this.setCollisionModel(this.position, spawnRotation, rcentity);
        this.setMotors();
        this.setWheels();
        this.setWings();
        this.setRotaryWings();
        this.setAutoControllers();
        this.setAttachments();
        this.setRocketMotors();
        this.setFloats();
        this.helper = new PhysicsHelper();
        this.dragFactor = this.loader.getDragFactor();
        this.motorActive = true;
        this.canChangeMode = true;
        this.releaseWeaponTimer = 0.0f;
        this.unlockCooldown = 5.0f;
        this.floatDensity = 997.0f;
    }

    private void setEntity(int ID) {
        switch (ID) {
            case 1: {
                this.loader = RCM_Main.planeProperies;
                break;
            }
            case 2: {
                this.loader = RCM_Main.droneProperies;
                break;
            }
            case 3: {
                this.loader = RCM_Main.carProperies;
                break;
            }
            case 4: {
                this.loader = RCM_Main.f22Properies;
                break;
            }
            case 5: {
                this.loader = RCM_Main.heliProperies;
                break;
            }
            case 6: {
                this.loader = RCM_Main.missleProperies;
                break;
            }
            case 7: {
                this.loader = RCM_Main.boatProperies;
                break;
            }
            case 8: {
                this.loader = RCM_Main.submarineProperies;
                break;
            }
            case 9: {
                this.loader = RCM_Main.stuntplaneProperies;
                break;
            }
            case 10: {
                this.loader = RCM_Main.octocopterProperies;
                break;
            }
            case 11: {
                this.loader = RCM_Main.racerProperies;
                break;
            }
        }
    }

    private void setCollisionModel(Vector3f position, float spawnRotation, GlobalEntity entity) {
        AxisAngle4f initRotate = new AxisAngle4f(0.0f, 1.0f, 0.0f, spawnRotation);
        Quat4f localQuat = new Quat4f();
        localQuat.set(initRotate);
        Transform trans = new Transform(new Matrix4f(localQuat, position, 1.0f));
        this.entityBody = this.createRigidBody(this.loader.getProperties()[0], this.loader.getInertiaScaleFactor(), trans, this.loader.getCollisionShapes(), entity instanceof EntityMissile);
        if (!(entity instanceof EntityMissile)) {
            this.entityBody.setActivationState(5);
        }
        if (this.loader.getDynamicShapes().getNumChildShapes() > 0) {
            RigidBody dynBody = this.createRigidBody(0.05f, this.loader.getInertiaScaleFactor(), trans, this.loader.getDynamicShapes(), false);
            dynBody.setUserPointer(new TimeToBreak(0.125f));
            Transform local = new Transform();
            local.setIdentity();
            local.origin.set(0.0f, 0.0f, 0.0f);
            Generic6DofConstraint contraint = new Generic6DofConstraint(this.entityBody, dynBody, local, local, true);
            float LIFT_EPS = 1.0E-7f;
            contraint.setLimit(0, -LIFT_EPS, LIFT_EPS);
            contraint.setLimit(1, -LIFT_EPS, LIFT_EPS);
            contraint.setLimit(2, -LIFT_EPS, LIFT_EPS);
            contraint.setLimit(3, -LIFT_EPS, LIFT_EPS);
            contraint.setLimit(4, -LIFT_EPS, LIFT_EPS);
            contraint.setLimit(5, -LIFT_EPS, LIFT_EPS);
            contraint.setUserConstraintId(0);
            RCM_Main.physicsWorld.getDynamicsWorld().addConstraint(contraint, true);
        }
    }

    private RigidBody createRigidBody(float mass, float inertiaScaleFactor, Transform trans, CollisionShape colShape, boolean isMissile) {
        Vector3f inertia = new Vector3f(0.0f, 0.0f, 0.0f);
        colShape.calculateLocalInertia(mass, inertia);
        inertia.scale(inertiaScaleFactor);
        DefaultMotionState motionState = new DefaultMotionState(trans);
        RigidBodyConstructionInfo entityConstructionInfo = new RigidBodyConstructionInfo(mass, motionState, colShape, inertia);
        entityConstructionInfo.angularDamping = 0.95f;
        entityConstructionInfo.restitution = 0.0f;
        entityConstructionInfo.friction = 0.5f;
        RigidBody rb = new RigidBody(entityConstructionInfo);
        if (isMissile) {
            rb.setCollisionFlags(4);
        }
        RCM_Main.physicsWorld.addRigidBody(rb);
        return rb;
    }

    private void setMotors() {
        if (this.loader.getProperties()[2] > 0.0f) {
            int i = 0;
            while ((float)i < this.loader.getProperties()[2]) {
                this.motors.add(new MotorHandler(this.loader.getMotorProperties().get((int)i).motorID, this.loader.getMotorProperties().get((int)i).mass, this.loader.getMotorProperties().get((int)i).diameter, this.loader.getMotorProperties().get((int)i).motorPower, this.loader.getMotorProperties().get((int)i).motorKVConstant, this.loader.getMotorProperties().get((int)i).motorInputVolts, this.loader.getMotorProperties().get((int)i).gearRatio, this.loader.getMotorProperties().get((int)i).batterySize, this.loader.getMotorProperties().get((int)i).sensorID, this.loader.getMotorProperties().get((int)i).controlChannel));
                ++i;
            }
        }
    }

    private void setWheels() {
        if (this.loader.getProperties()[3] > 0.0f) {
            VehicleTuning tuning = new VehicleTuning();
            DefaultVehicleRaycaster vehicleRayCaster = new DefaultVehicleRaycaster(RCM_Main.physicsWorld.getDynamicsWorld());
            this.vehicle = new RaycastVehicle(tuning, this.entityBody, vehicleRayCaster);
            RCM_Main.physicsWorld.addVehicle(this.vehicle);
            this.vehicle.setCoordinateSystem(0, 1, 2);
            int i = 0;
            while ((float)i < this.loader.getProperties()[3]) {
                this.vehicle.addWheel(this.loader.getWheelProperties().get((int)i).connectionPoint, this.loader.getWheelProperties().get((int)i).wheelDirection, this.loader.getWheelProperties().get((int)i).wheelAxle, this.loader.getWheelProperties().get((int)i).suspensionRestLength, this.loader.getWheelProperties().get((int)i).radius, tuning, this.loader.getWheelProperties().get((int)i).canTurn);
                WheelInfo wheel = this.vehicle.getWheelInfo(i);
                wheel.suspensionStiffness = this.loader.getWheelProperties().get((int)i).suspensionStiffness;
                wheel.wheelsDampingRelaxation = this.loader.getWheelProperties().get((int)i).suspensionDamping;
                wheel.wheelsDampingCompression = this.loader.getWheelProperties().get((int)i).suspensionCompression;
                wheel.rollInfluence = this.loader.getWheelProperties().get((int)i).rollInfluence;
                wheel.frictionSlip = this.loader.getWheelProperties().get((int)i).frictionSlip;
                wheel.brake = this.loader.getWheelProperties().get((int)i).breakForce;
                this.wheels.add(new WheelHandler(this.loader.getWheelProperties().get((int)i).ID, this.loader.getWheelProperties().get((int)i).wheelMaxTurn, this.loader.getWheelProperties().get((int)i).canTurn, this.loader.getWheelProperties().get((int)i).offSet, this.loader.getWheelProperties().get((int)i).channel));
                ++i;
            }
        }
    }

    private void setWings() {
        if (this.loader.getProperties()[4] > 0.0f) {
            int i = 0;
            while ((float)i < this.loader.getProperties()[4]) {
                this.wings.add(new WingHandler(this.loader.getWingProperties().get((int)i).wingID, this.loader.getWingProperties().get((int)i).spanVec, this.loader.getWingProperties().get((int)i).liftVec, this.loader.getWingProperties().get((int)i).chordVec, this.loader.getWingProperties().get((int)i).position, 0.0f, this.loader.getWingProperties().get((int)i).area, this.loader.getWingProperties().get((int)i).span, this.loader.getWingProperties().get((int)i).root, this.loader.getWingProperties().get((int)i).tip, this.loader.getWingProperties().get((int)i).def, this.loader.getWingProperties().get((int)i).defOffset, this.loader.getWingProperties().get((int)i).profileType, this.loader.getWingProperties().get((int)i).controlChannel, this.loader.getWingProperties().get((int)i).sections, 1.0f, this.loader.getWingProperties().get((int)i).sensorID));
                ++i;
            }
        }
    }

    private void setRotaryWings() {
        if (this.loader.getProperties()[5] > 0.0f) {
            int i = 0;
            while ((float)i < this.loader.getProperties()[5]) {
                this.rotaryWings.add(new RotaryWingHandler(this.loader.getRotaryWingProperties().get((int)i).propID, this.loader.getRotaryWingProperties().get((int)i).mass, this.loader.getRotaryWingProperties().get((int)i).ratio, this.loader.getRotaryWingProperties().get((int)i).eqFactor, this.loader.getRotaryWingProperties().get((int)i).spanVec, this.loader.getRotaryWingProperties().get((int)i).liftVec, this.loader.getRotaryWingProperties().get((int)i).chordVec, this.loader.getRotaryWingProperties().get((int)i).position, this.loader.getRotaryWingProperties().get((int)i).hubOffset, this.loader.getRotaryWingProperties().get((int)i).area, this.loader.getRotaryWingProperties().get((int)i).span, this.loader.getRotaryWingProperties().get((int)i).root, this.loader.getRotaryWingProperties().get((int)i).tip, this.loader.getRotaryWingProperties().get((int)i).def, this.loader.getRotaryWingProperties().get((int)i).defOffset, this.loader.getRotaryWingProperties().get((int)i).profileType, this.loader.getRotaryWingProperties().get((int)i).controlChannel, this.loader.getRotaryWingProperties().get((int)i).sections, this.loader.getRotaryWingProperties().get((int)i).sensorID));
                ++i;
            }
        }
    }

    private void setAutoControllers() {
        if (this.loader.getProperties()[6] > 0.0f) {
            int i = 0;
            while ((float)i < this.loader.getProperties()[6]) {
                this.sensors.add(new AutoControlHandler(this.loader.getAutoControlProperties().get((int)i).ID, this.loader.getAutoControlProperties().get((int)i).sensorPoint, this.loader.getAutoControlProperties().get((int)i).linGain, this.loader.getAutoControlProperties().get((int)i).linLimit, this.loader.getAutoControlProperties().get((int)i).angGain, this.loader.getAutoControlProperties().get((int)i).angLimit));
                ++i;
            }
        }
    }

    private void setAttachments() {
        if (this.loader.getProperties()[7] > 0.0f) {
            int i = 0;
            while ((float)i < this.loader.getProperties()[7]) {
                this.attachments.add(new AttachmentHandler(this.loader.getAttachments().get((int)i).position, this.loader.getAttachments().get((int)i).rotate, this.loader.getAttachments().get((int)i).type, i));
                ++i;
            }
        }
    }

    private void setRocketMotors() {
        if (this.loader.getProperties()[8] > 0.0f) {
            int i = 0;
            while ((float)i < this.loader.getProperties()[8]) {
                this.rocketMotors.add(new RocketMotorHandler(this.loader.getRocketMotors().get((int)i).thurst, this.loader.getRocketMotors().get((int)i).burnTime));
                ++i;
            }
        }
    }

    private void setFloats() {
        if (this.loader.getProperties()[9] > 0.0f) {
            int i = 0;
            while ((float)i < this.loader.getProperties()[9]) {
                this.floats.add(new FloatsHandler(this.loader.getFloats().get((int)i).position, this.loader.getFloats().get((int)i).spanVec, this.loader.getFloats().get((int)i).dragCoef, this.loader.getFloats().get((int)i).radius, this.loader.getFloats().get((int)i).sections));
                ++i;
            }
        }
    }

    public void update(GlobalEntity entity, float deltaTime) {
        BlockPos bp;
        this.entityBody.getOrientation(this.localQuat);
        this.entityBody.getLinearVelocity(this.linearVel);
        this.entityBody.getAngularVelocity(this.rotationalVel);
        this.position = this.entityBody.getMotionState().getWorldTransform((Transform)new Transform()).origin;
        this.Forward = this.helper.rotateVector(this.localQuat, new Vector3f(0.0f, 0.0f, 1.0f));
        this.Up = this.helper.rotateVector(this.localQuat, new Vector3f(0.0f, 1.0f, 0.0f));
        this.Left = this.helper.rotateVector(this.localQuat, new Vector3f(1.0f, 0.0f, 0.0f));
        this.updateControls(entity, deltaTime);
        boolean waterEntity = entity instanceof EntityBoat || entity instanceof EntitySubmarine;
        int wCount = 0;
        for (AttachmentHandler mh : this.attachments) {
            mh.setMotionState(this.localQuat, this.linearVel, this.position, deltaTime, entity.func_145782_y());
            if (this.releaseWeapons && !mh.isEmpty()) {
                mh.release(this.lockedEntity, this.targetPos);
                this.releaseWeapons = false;
                this.releaseWeaponTimer = 0.5f;
            }
            if (mh.isEmpty()) continue;
            ++wCount;
        }
        if (this.releaseWeapons) {
            this.releaseWeapons = false;
        }
        this.weaponCount = wCount;
        if (this.releaseWeaponTimer > 0.0f) {
            this.releaseWeaponTimer -= deltaTime;
        }
        for (int i = 0; i < this.wheels.size(); ++i) {
            if (this.wheels.get(i).isSteerable() && this.vehicle != null) {
                this.vehicle.setSteeringValue(this.controlChannels[this.wheels.get(i).getChannel()] * this.wheels.get(i).getMaxSteering(), i);
            }
            if (!(this.vehicle.wheelInfo.get((int)i).wheelsSuspensionForce <= 0.0f)) continue;
            this.jump = false;
        }
        if (this.jump) {
            Vector3f jumpVect = new Vector3f(entity.Up);
            jumpVect.scale(280.0f / this.entityBody.getInvMass());
            this.forces.add(new Force(jumpVect, new Vector3f()));
        }
        if (entity instanceof EntityMissile) {
            if (!this.getRocketMotorActive()) {
                this.frontPath = this.Forward;
            }
            this.virtualReference.updateFlyPath(this.Left, this.Up, this.Forward, this.getTragetPath(entity.func_145782_y(), this.linearVel), this.frontPath);
        } else if (this.sensors.size() > 0) {
            if (entity instanceof EntityDrone || entity instanceof EntityOctocopter) {
                this.virtualReference.resetFlybars(this.Forward);
                this.virtualReference.updateSafeBars(this.Left, this.Up, this.Forward, this.pitchAngle, this.yawAngle, this.rollAngle, deltaTime);
            } else {
                this.virtualReference.updateBars(this.Left, this.Up, this.Forward, this.pitchAngle, this.yawAngle, this.rollAngle, deltaTime);
            }
        }
        int constraints = this.entityBody.getNumConstraintRefs();
        boolean inLiquid = false;
        int finalOffSet = 0;
        for (int offSet = -1; offSet <= 2; ++offSet) {
            bp = new BlockPos((double)this.position.x, (double)(this.position.y + (float)offSet), (double)this.position.z);
            if (!entity.func_130014_f_().func_180495_p(bp).func_185904_a().func_76224_d()) continue;
            finalOffSet = offSet;
            inLiquid = true;
        }
        float floatReference = 0.0f;
        if (inLiquid) {
            bp = new BlockPos((double)this.position.x, (double)(this.position.y + (float)finalOffSet), (double)this.position.z);
            floatReference = BlockLiquid.func_190972_g((IBlockState)entity.func_130014_f_().func_180495_p(bp), (IBlockAccess)entity.field_70170_p, (BlockPos)bp);
        }
        if (constraints == 0 && (entity instanceof EntityTrainerPlane || entity instanceof EntityHeli || entity instanceof EntityDrone || entity instanceof EntityOctocopter || entity instanceof EntityStuntPlane) && !entity.damaged) {
            entity.damaged = true;
        }
        if (!(entity instanceof EntityBoat) && !(entity instanceof EntitySubmarine) && !(entity instanceof EntityMissile) && entity.func_70090_H()) {
            entity.damaged = true;
        }
        entity.prevVeloc.sub((Tuple3f)this.linearVel);
        if (entity.prevVeloc.length() > 20.0f && !(entity instanceof EntityMissile)) {
            entity.damaged = true;
        }
        ItemElectricMotor itemMotor = null;
        ItemBattery itemBattery = null;
        float mTempDelta = 0.0f;
        if (entity.entityInventory.func_70301_a(0).func_77973_b() instanceof ItemElectricMotor) {
            itemMotor = (ItemElectricMotor)entity.entityInventory.func_70301_a(0).func_77973_b();
            mTempDelta = entity.temperature - itemMotor.getMotorTemp(entity.entityInventory.func_70301_a(0));
        }
        if (entity.entityInventory.func_70301_a(2).func_77973_b() instanceof ItemBattery) {
            itemBattery = (ItemBattery)entity.entityInventory.func_70301_a(2).func_77973_b();
        }
        for (MotorHandler motor : this.motors) {
            if (entity.damaged) {
                motor.setDmged(true);
            }
            int wheelsPowered = 0;
            for (WheelHandler wheel : this.wheels) {
                if (wheel.getID() != motor.getID()) continue;
                ++wheelsPowered;
            }
            if (wheelsPowered > 0) {
                float wheelRotation = 0.0f;
                for (int i = 0; i < this.wheels.size(); ++i) {
                    if (motor.getID() != this.wheels.get(i).getID()) continue;
                    this.vehicle.applyEngineForce(motor.getWheelTorque(wheelsPowered) / this.vehicle.getWheelInfo((int)i).wheelsRadius, i);
                    wheelRotation += this.vehicle.getWheelInfo((int)i).deltaRotation * 60.0f;
                }
                if (wheelsPowered != 0) {
                    wheelRotation /= (float)wheelsPowered;
                }
                motor.setSpeed(wheelRotation);
                if (itemBattery != null && itemMotor != null) {
                    motor.update(0.0f, 0.0f, this.controlChannels[motor.getChannel()], true, deltaTime, false, itemBattery.getCharge(entity.entityInventory.func_70301_a(2)));
                    itemMotor.changeMotorTemp(motor.getTempChange(mTempDelta, deltaTime, this.motors.size()), entity.entityInventory.func_70301_a(0));
                    itemBattery.drainCharge(motor.getChargeDrain(), entity.entityInventory.func_70301_a(2));
                    continue;
                }
                motor.update(0.0f, 0.0f, this.controlChannels[motor.getChannel()], true, deltaTime, false, 0.0f);
                continue;
            }
            float totalResistanceTorque = 0.0f;
            float totalInertia = 0.0f;
            for (RotaryWingHandler rotaryWingHandler : this.rotaryWings) {
                if (rotaryWingHandler.getID() != motor.getID()) continue;
                float response = 0.0f;
                if (rotaryWingHandler.getSensorID() != 0) {
                    for (AutoControlHandler sensor : this.sensors) {
                        if (rotaryWingHandler.getSensorID() != sensor.getID()) continue;
                        sensor.update(this.localQuat, this.linearVel, this.virtualReference.getVirtualFlyBar(), this.virtualReference.getVirtualTailBar(), this.virtualReference.getVirtualFlightPath());
                        response = sensor.getResponse();
                    }
                }
                rotaryWingHandler.setAngularVelocity(motor.getOutputSpeed());
                rotaryWingHandler.setRotationAngle(deltaTime);
                rotaryWingHandler.update(this.localQuat, this.linearVel, this.rotationalVel, this.position.y, 1.225f, floatReference, this.controlChannels[rotaryWingHandler.getChannel()] + response, waterEntity);
                for (int i = 0; i < rotaryWingHandler.getSections(); ++i) {
                    Vector3f forcePos = new Vector3f(rotaryWingHandler.getPosition(i));
                    Vector3f forceLift = new Vector3f(rotaryWingHandler.getLift(i));
                    Vector3f forceDrag = new Vector3f(rotaryWingHandler.getDrag(i));
                    this.forces.add(new Force(forceLift, forcePos));
                    this.forces.add(new Force(forceDrag, forcePos));
                    this.torques.add(rotaryWingHandler.getMoment(i));
                }
                totalResistanceTorque += rotaryWingHandler.getTroque();
                totalInertia += rotaryWingHandler.getInertia();
            }
            if (motor.getOutputSpeed() <= 200.0f && constraints > 0 && !entity.damaged) {
                TimeToBreak dTime = (TimeToBreak)this.entityBody.getConstraintRef(0).getRigidBodyB().getUserPointer();
                dTime.setDamageTime(0.125f);
                this.entityBody.getConstraintRef(0).getRigidBodyB().setCollisionFlags(4);
            } else if (constraints > 0) {
                this.entityBody.getConstraintRef(0).getRigidBodyB().setCollisionFlags(8);
            }
            float response = 0.0f;
            if (motor.getSensorID() != 0) {
                for (AutoControlHandler sensor : this.sensors) {
                    if (motor.getSensorID() != sensor.getID()) continue;
                    sensor.update(this.localQuat, this.linearVel, this.virtualReference.getVirtualFlyBar(), this.virtualReference.getVirtualTailBar(), this.virtualReference.getVirtualFlightPath());
                    response = sensor.getMotorResponse(this.controlChannels[motor.getChannel()]);
                }
            }
            if (itemBattery != null && itemMotor != null) {
                motor.update(totalResistanceTorque, totalInertia, this.controlChannels[motor.getChannel()] + response, false, deltaTime, true, itemBattery.getCharge(entity.entityInventory.func_70301_a(2)));
                itemMotor.changeMotorTemp(motor.getTempChange(mTempDelta, deltaTime, this.motors.size()), entity.entityInventory.func_70301_a(0));
                itemBattery.drainCharge(motor.getChargeDrain(), entity.entityInventory.func_70301_a(2));
                continue;
            }
            motor.update(totalResistanceTorque, totalInertia, this.controlChannels[motor.getChannel()] + response, false, deltaTime, true, 0.0f);
        }
        if (!entity.func_70090_H() || !(entity instanceof EntityMissile)) {
            for (WingHandler wing : this.wings) {
                float response = 0.0f;
                if (wing.getSensorID() != 0) {
                    for (AutoControlHandler sensor : this.sensors) {
                        if (wing.getSensorID() != sensor.getID()) continue;
                        sensor.update(this.localQuat, this.linearVel, this.virtualReference.getVirtualFlyBar(), this.virtualReference.getVirtualTailBar(), this.virtualReference.getVirtualFlightPath());
                        response = sensor.getResponse();
                    }
                }
                wing.update(this.localQuat, this.linearVel, this.rotationalVel, this.position.y, 1.225f, floatReference, this.controlChannels[wing.getChannel()] + response, waterEntity);
                for (int i = 0; i < wing.getSections(); ++i) {
                    Vector3f forcePos = new Vector3f(wing.getPosition(i));
                    Vector3f forceLift = new Vector3f(wing.getLift(i));
                    Vector3f vector3f = new Vector3f(wing.getDrag(i));
                    this.forces.add(new Force(forceLift, forcePos));
                    this.forces.add(new Force(vector3f, forcePos));
                    this.torques.add(wing.getMoment(i));
                }
            }
        }
        for (RocketMotorHandler rocketMotor : this.rocketMotors) {
            Vector3f rocketThrust;
            if (this.targetPos != null) {
                rocketThrust = rocketMotor.getThurstVect(this.Forward, this.linearVel.length(), deltaTime, this.position.y - this.targetPos.y, this.linearVel.y);
                this.forces.add(new Force(rocketThrust, new Vector3f()));
                continue;
            }
            rocketThrust = rocketMotor.getThurstVect(this.Forward, this.linearVel.length(), deltaTime, 0.0f, this.linearVel.y);
            this.forces.add(new Force(rocketThrust, new Vector3f()));
        }
        if (inLiquid) {
            for (FloatsHandler flts : this.floats) {
                flts.update(this.position, this.localQuat, this.linearVel, this.rotationalVel, floatReference, this.floatDensity);
                for (int i = 0; i < flts.getSections(); ++i) {
                    Vector3f forcePos = new Vector3f(flts.getPosition(i));
                    Vector3f forceBouy = new Vector3f(flts.getBouyancy(i));
                    Vector3f forceDrag = new Vector3f(flts.getDrag(i));
                    this.forces.add(new Force(forceBouy, forcePos));
                    this.forces.add(new Force(forceDrag, forcePos));
                }
            }
        }
        if (entity instanceof EntitySubmarine && entity.func_70090_H()) {
            float pitchCorrection = (float)Math.sin(this.Forward.y) * 50.0f;
            float rollCorrection = -((float)Math.sin(this.Left.y)) * 10.0f;
            Vector3f torqVec = this.helper.rotateVector(this.localQuat, new Vector3f(pitchCorrection, 0.0f, rollCorrection));
            this.torques.add(torqVec);
        }
        if (entity instanceof EntityDrone || entity instanceof EntityOctocopter) {
            float torqueAssit = 4.5f;
            if (entity instanceof EntityDrone) {
                torqueAssit = 0.25f;
            }
            Vector3f upVec = new Vector3f(this.Up);
            upVec.scale(-KeyHandler.yawMovement * entity.power / 100.0f * torqueAssit);
            Vector3f torqVec = this.helper.rotateVector(this.localQuat, upVec);
            this.torques.add(torqVec);
        }
        if (!entity.func_70090_H()) {
            Vector3f dragForce = entity.helper.getAirDrag(this.linearVel, this.dragFactor);
            this.forces.add(new Force(dragForce, new Vector3f()));
        } else if (!(entity instanceof EntitySubmarine) && !(entity instanceof EntityBoat)) {
            Vector3f dragForce = entity.helper.getWaterDrag(this.linearVel, this.dragFactor);
            this.forces.add(new Force(dragForce, new Vector3f()));
        }
        entity.prevVeloc.set((Tuple3f)this.linearVel);
        for (Force fs : this.forces) {
            this.entityBody.applyForce(fs.getForce(), fs.getPosition());
        }
        for (Vector3f ts : this.torques) {
            this.entityBody.applyTorque(ts);
        }
        this.forces.clear();
        this.torques.clear();
    }

    public void getVisibleEntities(GlobalEntity en) {
        if (this.weaponsMode) {
            List entityList = en.field_70170_p.field_72996_f;
            this.visibleEntities.clear();
            this.inRadarEntities.clear();
            en.weaponLock = false;
            en.prevLockProgress = en.lockProgress;
            float angle = 0.0f;
            float nearAngle = 0.0f;
            Vector3f eVec = new Vector3f();
            if (this.lockedEntity != null) {
                Vec3d rcentityVec = new Vec3d(en.field_70165_t, en.field_70163_u, en.field_70161_v);
                Vec3d entityVec = new Vec3d(this.lockedEntity.field_70165_t, this.lockedEntity.field_70163_u + (double)(this.lockedEntity.func_70047_e() / 2.0f), this.lockedEntity.field_70161_v);
                eVec.set((float)(this.lockedEntity.field_70165_t - en.field_70165_t), (float)(this.lockedEntity.field_70163_u + (double)(this.lockedEntity.func_70047_e() / 2.0f) - en.field_70163_u), (float)(this.lockedEntity.field_70161_v - en.field_70161_v));
                nearAngle = angle = eVec.angle(en.Forward);
                if (en.field_70170_p.func_72901_a(rcentityVec, entityVec, false) != null || angle > 1.047198f) {
                    this.lockedEntity = null;
                }
            }
            for (Object obj : entityList) {
                Entity entity = (Entity)obj;
                if (entity == en || entity == en.thePlayer || entity instanceof CameraHandler || entity instanceof EntityItem || entity instanceof EntityMissile) continue;
                Vec3d rcentityVec = new Vec3d(en.field_70165_t, en.field_70163_u, en.field_70161_v);
                Vec3d entityVec = new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)(entity.func_70047_e() / 2.0f), entity.field_70161_v);
                eVec.set((float)(entity.field_70165_t - en.field_70165_t), (float)(entity.field_70163_u + (double)(entity.func_70047_e() / 2.0f) - en.field_70163_u), (float)(entity.field_70161_v - en.field_70161_v));
                angle = eVec.angle(en.Forward);
                if (angle > 1.047198f || en.field_70170_p.func_72901_a(rcentityVec, entityVec, false) != null) continue;
                this.visibleEntities.add(entity);
                if (angle > 0.43633232f) continue;
                if (this.lockedEntity == null) {
                    this.lockedEntity = entity;
                    this.unlockCooldown = 2.0f;
                    continue;
                }
                if (!(angle < nearAngle) || !(this.unlockCooldown <= 0.0f)) continue;
                this.lockedEntity = entity;
                this.unlockCooldown = 2.0f;
            }
            if (this.lockedEntity != null) {
                en.weaponLock = true;
                this.unlockCooldown -= 0.05f;
                if (this.lockedEntity.func_145782_y() != this.lockedEntityID) {
                    en.lockProgress = 0.0f;
                    en.prevLockProgress = 0.0f;
                    en.weaponLock = false;
                } else if (this.lockedEntity.func_145782_y() == this.lockedEntityID && en.lockProgress < 1.0f) {
                    en.lockProgress += 0.05f;
                }
                en.lockProgress = Math.min(1.0f, en.lockProgress);
                this.lockedEntityID = this.lockedEntity.func_145782_y();
            } else {
                en.lockProgress = 0.0f;
                en.prevLockProgress = 0.0f;
                en.weaponLock = false;
            }
        } else {
            this.lockedEntity = null;
            en.lockProgress = 0.0f;
            en.prevLockProgress = 0.0f;
            en.weaponLock = false;
        }
    }

    public Vector3f getTragetPath(int entityID, Vector3f linearMotion) {
        if (this.lockedEntity != null && !this.lockedEntity.field_70128_L) {
            Vector3f distanceToGo = new Vector3f((float)this.lockedEntity.field_70165_t, (float)(this.lockedEntity.field_70163_u + (double)this.lockedEntity.func_70047_e()), (float)this.lockedEntity.field_70161_v);
            Vector3f motionVect = new Vector3f(linearMotion);
            Vector3f entityMotion = new Vector3f((float)this.lockedEntity.field_70159_w, (float)this.lockedEntity.field_70181_x, (float)this.lockedEntity.field_70179_y);
            Vector3f normDistToGo = new Vector3f();
            Vector3f downDriftOffSet = new Vector3f(0.0f, 3.0f, 0.0f);
            distanceToGo.add((Tuple3f)downDriftOffSet);
            distanceToGo.sub((Tuple3f)this.position);
            entityMotion.scale(20.0f);
            float distanceCheck = distanceToGo.length();
            if (distanceCheck < 30.0f) {
                downDriftOffSet.set(0.0f, 3.0f - distanceCheck / 10.0f, 0.0f);
                distanceToGo.sub((Tuple3f)downDriftOffSet);
            }
            Vector3f relVel = new Vector3f(motionVect);
            relVel.sub((Tuple3f)entityMotion);
            float distanceToGoMag = distanceToGo.length();
            float motionVectMag = motionVect.length();
            normDistToGo.set((Tuple3f)distanceToGo);
            if (distanceToGoMag > 0.0f) {
                normDistToGo.normalize();
            }
            if (motionVectMag > 0.0f) {
                motionVect.normalize();
            }
            float closingVel = relVel.dot(normDistToGo);
            float timeToTarget = 0.0f;
            if (closingVel != 0.0f) {
                timeToTarget = distanceToGoMag / closingVel;
            }
            if (timeToTarget > 0.0f) {
                entityMotion.scale(timeToTarget);
                distanceToGo.add((Tuple3f)entityMotion);
            }
            if (distanceToGo.length() > 0.0f) {
                distanceToGo.normalize();
            }
            float projection = distanceToGo.dot(motionVect) * 0.1f;
            motionVect.scale(projection);
            distanceToGo.sub((Tuple3f)motionVect);
            distanceToGo.scale(-1.0f);
            if (distanceToGoMag <= 1.5f && this.prevDist <= distanceToGoMag) {
                MessageHandler.handler.sendToServer((IMessage)new MessageEntityMissle(entityID, this.position.x, this.position.y, this.position.z));
            }
            this.prevDist = distanceToGoMag;
            return distanceToGo;
        }
        if (this.targetPos != null && (this.position.y - this.targetPos.y >= 15.0f || this.linearVel.y < 0.0f)) {
            Vector3f distanceToGo = new Vector3f(this.targetPos.x, this.targetPos.y, this.targetPos.z);
            Vector3f normDistToGo = new Vector3f();
            Vector3f downDriftOffSet = new Vector3f(0.0f, 6.0f, 0.0f);
            distanceToGo.add((Tuple3f)downDriftOffSet);
            distanceToGo.sub((Tuple3f)this.position);
            float distanceCheck = distanceToGo.length();
            if (distanceCheck < 30.0f) {
                downDriftOffSet.set(0.0f, 6.0f - distanceCheck / 5.0f, 0.0f);
                distanceToGo.sub((Tuple3f)downDriftOffSet);
            }
            float distanceToGoMag = distanceToGo.length();
            normDistToGo.set((Tuple3f)distanceToGo);
            if (distanceToGoMag > 0.0f) {
                normDistToGo.normalize();
            }
            if (distanceToGo.length() > 0.0f) {
                distanceToGo.normalize();
            }
            distanceToGo.scale(-1.0f);
            if (distanceToGoMag <= 1.5f && this.prevDist <= distanceToGoMag) {
                MessageHandler.handler.sendToServer((IMessage)new MessageEntityMissle(entityID, this.position.x, this.position.y, this.position.z));
            }
            this.prevDist = distanceToGoMag;
            return distanceToGo;
        }
        return null;
    }

    public void updateControls(GlobalEntity entity, float deltaTime) {
        if (entity.activated && entity.holdingremotecontrol(entity.thePlayer)) {
            this.yawAngle = -KeyHandler.yawMovement;
            this.pitchAngle = -KeyHandler.pitchMovement;
            this.rollAngle = KeyHandler.rollMovement;
        }
        if (this.canChangeMode && KeyHandler.weaponsMode) {
            this.weaponsMode = !this.weaponsMode;
            this.canChangeMode = false;
        } else if (!this.canChangeMode && !KeyHandler.weaponsMode) {
            this.canChangeMode = true;
        }
        if (KeyHandler.shoot && this.canFireMissile && this.weaponsMode) {
            this.releaseWeapons = true;
            this.canFireMissile = false;
        } else if (this.releaseWeaponTimer <= 0.0f) {
            this.canFireMissile = true;
        }
    }

    public void setControlChannel(int place, float value) {
        this.controlChannels[place] = value;
    }

    public void jump() {
        this.jump = true;
    }

    public Quat4f getLocalQuad() {
        return this.localQuat;
    }

    public Vector3f getLinearVel() {
        return this.linearVel;
    }

    public Vector3f getRotationalVel() {
        return this.rotationalVel;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public void setEntityLinearVelocity(Vector3f vel) {
        this.entityBody.setLinearVelocity(vel);
    }

    public void setEntityMotionState(Quat4f quad, Vector3f pos, float par) {
        this.entityBody.setMotionState(new DefaultMotionState(new Transform(new Matrix4f(quad, pos, par))));
    }

    public void getEntityAABB(Vector3f minAABB, Vector3f maxAABB) {
        this.entityBody.getAabb(minAABB, maxAABB);
    }

    public void removePhysicsEntity() {
        if (this.vehicle != null) {
            RCM_Main.physicsWorld.removeVehicle(this.vehicle);
        }
        if (this.entityBody != null) {
            int constraints = this.entityBody.getNumConstraintRefs();
            if (constraints > 0) {
                RigidBody dynBody = this.entityBody.getConstraintRef(0).getRigidBodyB();
                RCM_Main.physicsWorld.removeConstraint(this.entityBody.getConstraintRef(0));
                RCM_Main.physicsWorld.removeRigidBody(dynBody);
            }
            RCM_Main.physicsWorld.removeRigidBody(this.entityBody);
        }
    }

    public void setRocketMotorActive() {
        for (RocketMotorHandler rmh : this.rocketMotors) {
            rmh.setActive();
        }
    }

    public boolean getRocketMotorActive() {
        Iterator<RocketMotorHandler> iterator = this.rocketMotors.iterator();
        if (iterator.hasNext()) {
            RocketMotorHandler rmh = iterator.next();
            return rmh.isActive();
        }
        return false;
    }

    public void attachWeapon(int place, GlobalEntity entity) {
        this.attachments.get(place).attach(entity);
    }

    public int getWeaponCount() {
        return this.weaponCount;
    }

    public boolean canExplode() {
        return this.motorActive;
    }

    public void setLockedTarger(@Nullable Entity lockedTarget) {
        this.lockedEntity = lockedTarget;
    }

    public void setFloatDensity(float par) {
        this.floatDensity = 997.0f * (0.1155f + 0.1f * (par + 1.0f) / 2.0f);
    }

    public void setTargetPosition(@Nullable Vector3f targetPosition) {
        this.targetPos = targetPosition;
    }
}

