/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Renders;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Vector3f;
import net.eldercodes.thercmod.Entities.EntityOctocopter;
import net.eldercodes.thercmod.Entities.GlobalEntity;
import net.eldercodes.thercmod.Models.Model;
import net.eldercodes.thercmod.RCM_Main;
import net.eldercodes.thercmod.Renders.GlobalRender;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

public class RenderOctocopter
extends GlobalRender {
    private ResourceLocation textureLocation = new ResourceLocation("thercmod:textures/models/octocopterskin.png");
    public Model propellerCW = null;
    public Model propellerCCW = null;
    public Model propellerBlur = null;
    public Model canopy = null;
    private List<Vector3f> propPos = new ArrayList<Vector3f>();
    private boolean[] propDir;

    public RenderOctocopter() {
        this.field_76989_e = 0.25f;
        String filePath = RCM_Main.modelFilePath + "octocopter.rcm";
        this.propPos.add(new Vector3f(0.702146f, 0.040356f, 0.290838f));
        this.propPos.add(new Vector3f(0.702146f, 0.040356f, -0.290838f));
        this.propPos.add(new Vector3f(-0.702146f, 0.040356f, 0.290838f));
        this.propPos.add(new Vector3f(-0.702146f, 0.040356f, -0.290838f));
        this.propPos.add(new Vector3f(0.290838f, 0.040356f, -0.702146f));
        this.propPos.add(new Vector3f(-0.290838f, 0.040356f, -0.702146f));
        this.propPos.add(new Vector3f(0.290838f, 0.040356f, 0.702146f));
        this.propPos.add(new Vector3f(-0.290838f, 0.040356f, 0.702146f));
        this.propDir = new boolean[]{false, true, true, false, false, true, true, false};
        try {
            this.mainBody = new Model();
            this.propellerCW = new Model();
            this.propellerCCW = new Model();
            this.propellerBlur = new Model();
            this.canopy = new Model();
            this.mainBody.loadModel(filePath, "MainBody");
            this.propellerCW.loadModel(filePath, "PropellerCW");
            this.propellerCCW.loadModel(filePath, "PropellerCCW");
            this.propellerBlur.loadModel(filePath, "PropellerBlur");
            this.canopy.loadModel(filePath, "Canopy");
        }
        catch (FileNotFoundException e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"RC Drone model file is missing!!", (Object[])new Object[0]);
        }
        catch (IOException e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"RC Drone model file loaded incorrectly!!", (Object[])new Object[0]);
        }
    }

    @Override
    public void renderExtras(GlobalEntity rcentity, float timeStep) {
        EntityOctocopter drone = (EntityOctocopter)rcentity;
        if (rcentity.physicsWorld != null) {
            GL11.glPushMatrix();
            GL11.glBegin((int)4);
            this.canopy.draw();
            GL11.glEnd();
            GL11.glPopMatrix();
            Vector3f rotateAxis = new Vector3f();
            for (int i = 0; i < 8; ++i) {
                GL11.glPushMatrix();
                rotateAxis.setY(1.0f);
                if (this.propDir[i]) {
                    rotateAxis.setY(-1.0f);
                }
                GL11.glTranslatef((float)this.propPos.get((int)i).x, (float)this.propPos.get((int)i).y, (float)this.propPos.get((int)i).z);
                GL11.glRotatef((float)(drone.prevState[i] + (drone.state[i] - drone.prevState[i]) * timeStep), (float)rotateAxis.x, (float)rotateAxis.y, (float)rotateAxis.z);
                this.field_76990_c.field_78724_e.func_110577_a(this.textureLocation);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glBegin((int)4);
                if (this.propDir[i]) {
                    this.propellerCW.draw();
                } else {
                    this.propellerCCW.draw();
                }
                GL11.glEnd();
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3042);
                GL11.glDepthMask((boolean)false);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glAlphaFunc((int)516, (float)0.01f);
                GL11.glBegin((int)4);
                float visiblility = 1.0f;
                float par1 = drone.prevState[i + 8] + (drone.state[i + 8] - drone.prevState[i + 8]) * timeStep;
                if (Math.abs(par1) < 500.0f) {
                    visiblility = Math.abs(par1 / 500.0f);
                }
                if (visiblility > 1.0f) {
                    visiblility = 1.0f;
                } else if (visiblility < 0.0f) {
                    visiblility = 0.0f;
                }
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)visiblility);
                this.propellerBlur.draw();
                GL11.glEnd();
                GL11.glDepthMask((boolean)true);
                GL11.glDisable((int)3042);
                GL11.glAlphaFunc((int)516, (float)0.1f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
        }
    }

    @Override
    protected ResourceLocation func_110775_a(Entity entity) {
        return this.textureLocation;
    }
}

