/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Entities;

import javax.vecmath.Vector3f;
import net.eldercodes.thercmod.Entities.EntityBoat;
import net.eldercodes.thercmod.Entities.EntityCar;
import net.eldercodes.thercmod.Entities.EntityDrone;
import net.eldercodes.thercmod.Entities.EntityHeli;
import net.eldercodes.thercmod.Entities.EntityOctocopter;
import net.eldercodes.thercmod.Entities.EntityRacer;
import net.eldercodes.thercmod.Entities.EntitySubmarine;
import net.eldercodes.thercmod.Entities.GlobalEntity;
import net.eldercodes.thercmod.KeyHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class CameraHandler
extends Entity {
    public float degToRad = (float)Math.PI / 180;
    private GlobalEntity rcentity;
    private AxisAlignedBB nullAABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private double CamPosX;
    private double CamPosZ;
    private double CamPosY;
    private double CamRadialXZ;
    private double CamRadialY;
    private double radial;
    private float yawOffset;
    private float heightOffset;
    private float zoomOffset;
    private float lastTick;

    public CameraHandler(EntityType<?> entityType, World worldIn) {
        super(entityType, worldIn);
        this.field_70145_X = true;
    }

    public CameraHandler(World world, GlobalEntity entity) {
        this(EntityType.field_200729_aH, world);
        this.rcentity = entity;
        this.field_70177_z = entity.field_70177_z;
        this.field_70126_B = entity.field_70177_z;
        this.field_70125_A = 0.0f;
        this.field_70127_C = 0.0f;
        this.yawOffset = 0.0f;
        this.heightOffset = this.getEntityHeightOffset();
        this.zoomOffset = 3.3f;
        this.func_70107_b(entity.field_70165_t, entity.field_70163_u + (double)this.heightOffset, entity.field_70161_v);
        this.field_70169_q = entity.field_70169_q;
        this.field_70167_r = entity.field_70167_r + (double)this.heightOffset;
        this.field_70166_s = entity.field_70166_s;
        this.lastTick = 0.0f;
    }

    public float getEntityHeightOffset() {
        if (this.rcentity instanceof EntityCar || this.rcentity instanceof EntityRacer) {
            return 0.75f - this.func_70047_e();
        }
        if (this.rcentity instanceof EntityBoat) {
            return 1.0f - this.func_70047_e();
        }
        return 0.5f - this.func_70047_e();
    }

    public void customTick(float delta, Minecraft mc) {
        boolean collideCeck;
        double distance = 0.3;
        this.setValues(delta);
        double deltaPosX = this.rcentity.field_70169_q + (this.rcentity.field_70165_t - this.rcentity.field_70169_q) * (double)delta;
        double deltaPosY = this.rcentity.field_70167_r + (this.rcentity.field_70163_u - this.rcentity.field_70167_r) * (double)delta;
        double deltaPosZ = this.rcentity.field_70166_s + (this.rcentity.field_70161_v - this.rcentity.field_70166_s) * (double)delta;
        float deltaPitch = this.rcentity.field_70127_C + (this.rcentity.field_70125_A - this.rcentity.field_70127_C) * delta;
        float deltaYaw = this.rcentity.field_70126_B + (this.rcentity.field_70177_z - this.rcentity.field_70126_B) * delta;
        this.CamRadialXZ = (double)(-(deltaYaw + this.yawOffset)) / 180.0 * Math.PI;
        do {
            this.CamRadialY = this.rcentity instanceof EntityCar || this.rcentity instanceof EntityDrone || this.rcentity instanceof EntityHeli || this.rcentity instanceof EntityOctocopter || this.rcentity instanceof EntityRacer ? 0.0 : (double)deltaPitch / 180.0 * Math.PI;
            this.CamPosX = deltaPosX - Math.sin(this.CamRadialXZ) * Math.cos(this.CamRadialY) * distance;
            this.CamPosZ = deltaPosZ - Math.cos(this.CamRadialXZ) * Math.cos(this.CamRadialY) * distance;
            this.CamPosY = deltaPosY + Math.sin(this.CamRadialY) * distance * Math.cos(this.yawOffset * this.degToRad);
            BlockPos bp = new BlockPos(this.CamPosX, this.CamPosY + (double)this.heightOffset + (double)this.func_70047_e() - (double)0.05f, this.CamPosZ);
            boolean bl = collideCeck = !this.field_70170_p.func_180495_p(bp).func_185904_a().func_76230_c();
            if (!collideCeck || distance >= (double)this.zoomOffset) {
                this.CamRadialY = this.rcentity instanceof EntityCar || this.rcentity instanceof EntityDrone || this.rcentity instanceof EntityHeli || this.rcentity instanceof EntityOctocopter || this.rcentity instanceof EntityRacer ? 0.0 : (double)deltaPitch / 180.0 * Math.PI;
                this.CamPosX = deltaPosX - Math.sin(this.CamRadialXZ) * Math.cos(this.CamRadialY) * (distance -= 0.3);
                this.CamPosZ = deltaPosZ - Math.cos(this.CamRadialXZ) * Math.cos(this.CamRadialY) * distance;
                this.CamPosY = deltaPosY + Math.sin(this.CamRadialY) * distance * Math.cos(this.yawOffset * this.degToRad);
                continue;
            }
            distance += 0.005;
        } while (collideCeck && distance <= (double)(this.zoomOffset - 0.3f));
        if (this.rcentity.weaponsMode && mc.field_71474_y.field_74320_O <= 1 && this.rcentity instanceof EntitySubmarine) {
            distance = 10.0;
            this.field_70177_z = mc.field_71439_g.field_70177_z;
            this.radial = (double)(-this.field_70177_z) / 180.0 * 3.141592654;
            if (mc.field_71439_g.field_70125_A < 5.0f) {
                mc.field_71439_g.field_70125_A = 5.0f;
            } else if (mc.field_71439_g.field_70125_A > 40.0f) {
                mc.field_71439_g.field_70125_A = 40.0f;
            }
            this.field_70125_A = mc.field_71439_g.field_70125_A;
            this.CamPosX = deltaPosX - Math.sin(this.radial) * distance;
            this.CamPosZ = deltaPosZ - Math.cos(this.radial) * distance;
            if ((double)(this.field_70170_p.func_217301_I() / 4) <= this.CamPosY) {
                this.func_70107_b(this.CamPosX, this.CamPosY + 20.0, this.CamPosZ);
            } else if ((double)(this.field_70170_p.func_217301_I() / 4) > this.CamPosY) {
                this.func_70107_b(this.CamPosX, this.field_70170_p.func_72919_O() + 20.0, this.CamPosZ);
            }
        } else {
            this.func_70107_b(this.CamPosX, this.CamPosY + (double)this.heightOffset, this.CamPosZ);
            mc.field_71439_g.field_70177_z = this.field_70177_z = deltaYaw + this.yawOffset;
        }
        if (!(this.rcentity instanceof EntityCar || this.rcentity instanceof EntityDrone || this.rcentity instanceof EntityHeli || this.rcentity.weaponsMode && this.rcentity instanceof EntitySubmarine || this.rcentity instanceof EntityOctocopter || this.rcentity instanceof EntityRacer)) {
            this.field_70125_A = deltaPitch * (float)Math.cos(this.yawOffset * this.degToRad);
            mc.field_71439_g.field_70125_A = deltaPitch;
        }
        if (this.rcentity instanceof EntitySubmarine && this.rcentity.weaponsMode) {
            this.getRaytracePos();
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
    }

    public void setValues(float delta) {
        if (delta <= this.lastTick) {
            this.lastTick = 0.0f;
        }
        float tick = (delta - this.lastTick) * 1.0f / 20.0f;
        this.yawOffset += (float)KeyHandler.camYaw * 160.0f * tick;
        this.heightOffset += (float)KeyHandler.camHeight * 3.2f * tick;
        this.zoomOffset -= (float)KeyHandler.camZoom * 3.2f * tick;
        this.heightOffset = Math.max(-1.52f, this.heightOffset);
        this.zoomOffset = Math.max(3.3f, this.zoomOffset);
        this.heightOffset = Math.min(-0.22f, this.heightOffset);
        this.zoomOffset = Math.min(6.3f, this.zoomOffset);
        if (KeyHandler.camReset) {
            this.yawOffset = 0.0f;
            this.heightOffset = this.getEntityHeightOffset();
            this.zoomOffset = 3.3f;
        }
        this.lastTick = delta;
    }

    private void getRaytracePos() {
        float f8;
        float f6;
        double d3;
        float f5;
        float f1 = this.field_70125_A;
        float f2 = this.field_70177_z;
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u + (double)this.func_70047_e();
        double d2 = this.field_70161_v;
        Vec3d pos = new Vec3d(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f7 = f4 * (f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180))));
        Vec3d vec3d1 = pos.func_72441_c((double)f7 * (d3 = 150.0), (double)(f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)))) * d3, (double)(f8 = f3 * f5) * d3);
        BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(pos, vec3d1, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        if (raytraceresult != null) {
            BlockPos bp = new BlockPos(raytraceresult.func_216347_e().field_72450_a, raytraceresult.func_216347_e().field_72448_b, raytraceresult.func_216347_e().field_72449_c);
            this.rcentity.physicsWorld.setTargetPosition(new Vector3f((float)bp.func_177958_n() + 0.5f, (float)bp.func_177956_o() + 0.5f, (float)bp.func_177952_p() + 0.5f));
        }
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public AxisAlignedBB func_174813_aQ() {
        return this.nullAABB;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70093_af() {
        return false;
    }

    public boolean func_175149_v() {
        return false;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

